#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <CON_All.h>
#include <2D_World.h>
#include <2D_Object2D.h>
#include <2D_Sprite.h>
#include <2D_SpriteCache.h>
#include <stdio.h>

int initConsole(int& Width, int& Height, int& FullScreen, int& Flags, Screen* S)
{
  if (!S->isModeAvailable(640,480))
  {
    MessageBox(NULL,"Mode 640x480x16 not available","ERROR",MB_OK);
    return -1;
  }
  Width=640;
  Height=480;
  FullScreen=0;
  Flags=NoAccel;
  //setDebugLevel(1);
  //enableDiagnostics();
  return 0;
}

ResourceStream* RS=NULL;
World2D* W=NULL;
View2D*  v2d=NULL;
class MyObj* O;
float Num=0.0f;

class MyObj : public AnimatedSprite
{
public:
  MyObj() : sc(new SpriteCache(*RS)), dx(1), cnt(0)
  {
    addAnimationFrame(sc->load("pacman.bmp"),0.5f);
    addAnimationFrame(sc->load("pacman2.bmp"),0.2f);
  }

  long advance(float Fraction)
  {
    fVector2D v=getPosition();
    v.x+=dx;
    setPosition(v);
    cnt++;
    if ((cnt&0x3f)==0) dx=-dx;
    return AnimatedSprite::advance(Fraction);
  }

  ~MyObj() { delete sc; }

  SpriteCache* sc;
  int     dx,cnt;
};

int action(Console* C)
{
  Screen* S=C->getScreen();
  Drawable* D=S;
  if (W==NULL)
  {
    RS=newResourceStream();
    W=new World2D();
    v2d=new View2D(S,0,0,639,479);
    O=new MyObj();
    O->setPosition(fVector2D(100.0f,100.0f));
    W->add(O);
  }

  S->clear(0);

  W->advance(getFrameTime());
  W->render(*v2d);

  S->beginDraw();
  char buf[128];
  sprintf(buf,"Hello %d",(int)(Num+=0.01f));
  S->printXY(500,50,0xffffffff,buf);
  S->endDraw();
  S->flip();
  Keyboard& K=*C->getKeyboard();
  K.update();
  if (K[DIK_ESCAPE])
  {
    delete v2d;
    delete W;
    RS->release();
    return 1;
  }
  return 0;
}