// ------------------------------------------------------------ //
// if you use the file, do not delete the copyright infomation  //
// ------------------------------------------------------------ //
//             HOOKAPI sample									//
//   Copyright 2002 Frus Studio Software						//
//       www.frussoft.com										//
// ------------------------------------------------------------ //

#include "stdafx.h"
#include <winsock.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
//#include <lmcons.h>
//#include <lmalert.h>
#include "mydll.h"
//#include <nb30.h>
#include "util.h"

#ifdef WIN95

#pragma comment(linker, "/section:.data,RWS /section:.idata,RWS /section:.bss,RWS")
#pragma comment(linker, "/base:0xBFF70000")

#endif

HINSTANCE g_hInstance;

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	if(ul_reason_for_call =DLL_PROCESS_ATTACH)
	{
		//GetProfileString("HookAPI", "dll_path", "", g_szDllPath, sizeof(g_szDllPath));
	}

	return TRUE;
}

int GetLocalPortBySocket(SOCKET s)
{
	struct sockaddr name;
	int namelen =sizeof(name);

	getsockname(s, &name, &namelen);
	return ntohs(((struct sockaddr_in *)&name)->sin_port);
}

int GetLocalIPBySocket(SOCKET s, char *ip)
{
	struct sockaddr name;
	int namelen =sizeof(name);

	getsockname(s, &name, &namelen);
	strcpy(ip, inet_ntoa(((struct sockaddr_in *)&name)->sin_addr));
	return 0;
}

int GetRemotePortBySocket(SOCKET s)
{
	struct sockaddr name;
	int namelen =sizeof(name);

	getpeername(s, &name, &namelen);
	return ntohs(((struct sockaddr_in *)&name)->sin_port);
}

int GetRemoteIPBySocket(SOCKET s, char *ip)
{
	struct sockaddr name;
	int namelen =sizeof(name);

	getpeername(s, &name, &namelen);
	strcpy(ip, inet_ntoa(((struct sockaddr_in *)&name)->sin_addr));
	return 0;
}

int WINAPI mysocket(int af, int type, int protocol)
{
	WriteLog("mysocket, af=%d, type=%d, protocol=%d", af, type, protocol);

	return socket(af, type, protocol);
}

struct hostent * WINAPI mygethostbyname (const char * name)
{
	// filter IE url
	WriteLog("gethostbyname:name:%s", name);
	return gethostbyname(name);
}

int WINAPI myaccept(SOCKET s, struct sockaddr *pname, int *pnamelen)
{
	WriteLog("myaccept");
	int port =GetLocalPortBySocket(s);

	int s1 =accept(s, pname, pnamelen);

	if(s1 >0)
	{
		// check filter 
	}

	return s1;
}

int WriteBinData(char *function, char *buf, int len)
{
	char mod_name[100];
	char fname[128];

	if(len <=0) return 0;

	GetFileName(mod_name);
	wsprintf(fname, "c:\\%s.log", mod_name);
	FILE *fp;

	if((fp =fopen(fname, "ab")) ==NULL)
	{
		WriteLog("open file %s failed", fname);
		return -1;
	}
	fprintf(fp, "\n(%s,len=%d) ", function, len);
	for(int i =0; i<len; i++)
	{
		if(buf[i] !=0)
			fprintf(fp, "%c", buf[i]);
		else
		    fprintf(fp, "(\\%02x)", buf[i]&0x00FF);
	}
	fclose(fp);

	return 0;
}

int WINAPI myconnect(SOCKET s, struct sockaddr *name, int namelen)
{
	WriteLog("myconnect");
	struct sockaddr_in *paddr =(struct sockaddr_in *)name;

	char *ip =inet_ntoa(paddr->sin_addr);
	int port =ntohs(paddr->sin_port);
	WriteLog("connect: ip=%s, port=%d\n", ip, port);
	WriteBinData("connect", ip, strlen(ip));
	// check filter
	return connect(s, name, namelen);
}

int WINAPI myrecv(SOCKET s,	char *buf, int len, int flags)
{
	WriteLog("\nmyrecv, len:%d", len);

	int recved_len =recv(s, (char *)buf, len, flags);
	int err;

	if(recved_len <=0) err =WSAGetLastError();

	if(recved_len >0)
	{
		int port =GetLocalPortBySocket(s);
		int port1 =GetRemotePortBySocket(s);
		char ip[16];
		GetRemoteIPBySocket(s, ip);
	}
	
	WriteBinData("recv", buf, recved_len);

	if(recved_len <=0) WSASetLastError(err);
	
	return recved_len;
}

int WINAPI mysend(SOCKET s,	char *buf, int len,	int flags)
{
	int ret;

	WriteLog("mysend");

	int port =GetLocalPortBySocket(s);
	int port1 =GetRemotePortBySocket(s);
	char ip[16];

	GetRemoteIPBySocket(s, ip);

	WriteBinData("send", buf, len);

	ret =send(s, (char *)buf, len, flags);
	
	int err;
	if(ret <=0) err =WSAGetLastError();
	// other process...
	if(ret <=0) WSASetLastError(err);
	
	return ret;
}

int WINAPI mysendto (SOCKET s, char FAR * buf, int len, int flags, struct sockaddr FAR * to, int tolen)
{
	WriteLog("mysendto");
	return sendto(s, buf, len, flags, to, tolen);
}

int WINAPI myrecvfrom (SOCKET s, char FAR * buf, int len, int flags, struct sockaddr FAR * from, int *fromlen)
{
	WriteLog("myrecvfrom");
	return recvfrom(s, buf, len, flags, from, fromlen);
}

MYAPIINFO myapi_info[] =
{
	{"WSOCK32.DLL", "socket(a,b,c)", "mysocket"},
	{"WSOCK32.DLL", "accept(a,b,c)", "myaccept"},
	{"WSOCK32.DLL", "connect(SOCKET, struct sockaddr *, INT)", "myconnect"},
	{"WSOCK32.DLL", "recv(INT, char *, INT, INT)", "myrecv"},
	{"WS2_32.DLL", "recv(INT, char *, INT, INT)", "myrecv"},
	{"WSOCK32.DLL", "send(INT, char *, INT, INT)", "mysend"},
	{"WSOCK32.DLL", "sendto(INT, char *, INT, INT, struct sockaddr *, int)", "mysendto"},
	{"WSOCK32.DLL", "recvfrom(INT, char *, INT, INT, struct sockaddr *, int)", "myrecvfrom"},
	{"WSOCK32.DLL", "gethostbyname(char *)", "mygethostbyname"},
	{NULL,NULL,NULL}
};

MYAPIINFO *GetMyAPIInfo()
{
	return &myapi_info[0];
}

