/*
 *  Sample application that demonstrates using functions
 *  from ee.dll. Link it with ee.lib.
 */
#include <stdio.h>
#include <string.h>
#include "ee.h"

double result, lowlimit, highlimit;
char   *buff, error[128];
int    size, errorposition;

int main (int argc, char *arg[])
{
  if(argc == 1)
  {
    printf("This program evaluates expressions or functions using ee.dll.\n"
           "Usage:    ee <expression>\n"
           "          or\n"
           "          ee <function(x)> <low limit> [<high limit>]\n"
           "Examples: ee \" e ^ pi - pi ^ e\"\n"
           "          ee 1/ln(x)/x 0.5\n"
           "          ee exp(-1/pow(x/100,2)) -30 30\n");
    return 0;
  }

  if(argc == 2)
  { /*Image of any expression is larger than sizeof(int)*/
    if(MakeImage(&size, sizeof(int), arg[1], error,
                 &errorposition, NULL) == EE_SMALLBUFFER)
    {
      buff = new char[size];
      if(buff == NULL) return 2;
      if(MakeImage(buff, size, arg[1], NULL, NULL, NULL) == EE_OK)
      {
        if(Value(buff, &result, error, 0) == EE_OK)
          printf("%.15g\n", result);
        else printf("Error during calculation: %s.\n"
                    "Result may be wrong: %0.15g\n", error, result);
      }
      else printf("ee.dll is a bad program\n.");
      delete buff;
    }
    else
    {
      if(errorposition != -1)
      {
        printf("%s\n", arg[1]);
        printf("%*s\n", errorposition+1, "^");
      }
      printf("%s\n\n", error);
    }
    return 0;
  }

  if(argc == 3)
  {
    if(sscanf(arg[2], "%lg", &lowlimit) != 1)
    {
      printf("Cannot recognize number %s\n", arg[2]);
      return 1;
    }
    if(MakeImage(&size, sizeof(int), arg[1], error,
                 &errorposition, "x") == EE_SMALLBUFFER)
    {
      buff = new char[size];
      if(buff == NULL) return 2;
      if(MakeImage(buff, size, arg[1], NULL, NULL, "x") == EE_OK)
      {
        if(Value(buff, &result, error, 1, lowlimit) == EE_OK)
          printf("%.15g\n", result);
        else printf("Error during calculation: %s.\n"
                    "result may be wrong: %0.15g\n", error, result);
      }
      else printf("ee.dll is a bad program\n.");
      delete buff;
    }
    else
    {
      if(errorposition != -1)
      {
        printf("%s\n", arg[1]);
        printf("%*s\n", errorposition+1, "^");
      }
      printf("%s\n\n", error);
    }
    return 0;
  }

  if(argc > 3)
  {
    if(sscanf(arg[2], "%lg", &lowlimit) != 1)
    {
      printf("Cannot recognize number %s\n", arg[2]);
      return 1;
    }
    if(sscanf(arg[3], "%lg", &highlimit) != 1)
    {
      printf("Cannot recognize number %s\n", arg[3]);
      return 1;
    }
    if(MakeImage(&size, sizeof(int), arg[1], error, &errorposition, "x X")
                == EE_SMALLBUFFER) /* In this case user can use */
    {                              /* either x or X in function */
      buff = new char[size];       /* definition.               */
      if(buff == NULL) return 2;
      if(MakeImage(buff, size, arg[1], NULL, NULL, "x X")
                  == EE_OK)
      {
        Simplify(buff, NULL);
        while(lowlimit <= highlimit)
        {
          if(Value(buff, &result, error, 2, lowlimit, lowlimit) == EE_OK)
            printf("%.15g\n", result);
          else
          {
            printf("Error during calculation: %s.\n"
                   "Result may be wrong: %0.15g\n", error, result);
            break;
          }
          lowlimit++;
        }
      }
      else printf("ee.dll is a bad program.\n");
      delete buff;
    }
    else
    {
      if(errorposition != -1)
      {
        printf("%s\n", arg[1]);
        printf("%*s\n", errorposition+1, "^");
      }
      printf("%s\n\n", error);
    }
  }
  return 0;
}

