
/*
 * Copyright (C) 1998 David Stes.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "fab.h"
#include <runarray.h> 
#include <assert.h> 
#include "Textlink.h" 
#include "Textanchor.h" 

static void pchar(char c)
{
  if (c == '<') {printf("&lt;");return;}
  if (c == '>') {printf("&gt;");return;}
  if (c == '&') {printf("&amp;");return;}
  putchar(c);
}

static void opencode(id a)
{
  if ([a isMemberOf:Textlink]) {
    printf("<A HREF=\"#%i\">",[a linknum]);return;
  }
  if ([a isMemberOf:Textanchor]) {
    printf("<A NAME=\"%i\">",[a linknum]);return;
  }
  switch([a emphasiscode]) {
    case ROMAN : break;
    case BOLD    :
    case COURIER : printf("<B>");break;
    case ITALIC  : printf("<I>");break;
    default : break;
  }
}

static void closecode(id a)
{
  if ([a isMemberOf:Textlink] || [a isMemberOf:Textanchor]) {
    printf("</A>");return;
  }
  switch([a emphasiscode]) {
    case ROMAN : break;
    case BOLD    :
    case COURIER : printf("</B>");break;
    case ITALIC  : printf("</I>");break;
    default : break;
  }
}

static void phtml(id t)
{
  unsigned p = 0;
  char *chars = [t str];
  unsigned size = [t size];
  id runArray = [t runs];

  while (p < size) {
    int i,n;
    id attrs;
    unsigned q;
    attrs = [runArray at:p];
    n = [attrs size];
    q = p + [runArray runLengthAt:p];
    assert(q != p && q <= size);
    for(i=0;i<n;i++) opencode([attrs at:i]);
    for(;p<q;p++) pchar(chars[p]);
    while (n--) closecode([attrs at:n]);
  }
}

static void ptitle(id t)
{
  printf("<H1>");phtml(t);printf("</H1>\n");
}

static void psubtitle(id t)
{
  printf("<H2>");phtml(t);printf("</H2>\n");
}

static void psubsubtitle(id t)
{
  printf("<H3>");phtml(t);printf("</H3>\n");
}

static void pdot(id t)
{
  printf("<LI>");phtml(t);printf("</LI>\n");
}

static void pmethodproto(id t)
{
  printf("<BLOCKQUOTE>");phtml(t);printf("</BLOCKQUOTE>\n");
}

static void pexample(id t)
{
  printf("<BLOCKQUOTE><PRE>\n");
  phtml(t);
  printf("</PRE></BLOCKQUOTE>\n");
}

void writehtml(id paragraphs)
{
  int i,n = [paragraphs size];

  for(i=0;i<n;i++) {
    id p = [paragraphs at:i];
    char *style = [[p textStyle] name];
    id t = [p text];
    assert(style != NULL && style != NULL);
    if (!strcmp(style,"Title")) ptitle(t);
    else if (!strcmp(style,"Subtitle")) psubtitle(t);
    else if (!strcmp(style,"Subsubtitle")) psubsubtitle(t);
    else if (!strcmp(style,"Dotbegin")) printf("<UL>\n");
    else if (!strcmp(style,"Dotitem")) pdot(t);
    else if (!strcmp(style,"Dotend")) printf("</UL>\n");
    else if (!strcmp(style,"Methodname")) psubsubtitle(t);
    else if (!strcmp(style,"Methodproto")) pmethodproto(t);
    else if (!strcmp(style,"Example")) pexample(t);
    else { phtml(t);printf("<P>\n"); }
  }
}

