/*
 * mrsa.h -- Multiprecision math and  RSA public key crypt library
 * 1993 Risto Paasivirta, paasivir@jyu.fi
 * Public Domain, no warranty. Use as you wish.
 */

#ifndef	MRSA_H
#define MRSA_H 1
#ifndef NSIZE
/* #define NSIZE 32 for max 512 (actually 511) bit modulus */
#define NSIZE 16
#endif

/*
 * unsigned 16 and 32 -bit types (other sizes may need some porting)
 */

#ifndef	UWORD	
typedef unsigned short UWORD;
#endif
#ifndef	ULONG
typedef unsigned long ULONG;
#endif

typedef UWORD *N, NN[NSIZE];

class GCS_CLASS_DECL rsa_key {
public:
	rsa_key();
	~rsa_key();
		// Create a string that can be reloaded
	CString Save();
		// Load a string to re-create the key
	void Load(CString &str);
		// Create a key from 2 relative primes
	BOOL CreateKey(CString strP, CString strQ);
		// Decode a string
	CString DeCode(CString strIn);
		// Encode a string
	CString EnCode(CString strIn);
		// Create a string that can be published and be reloaded (decode only)
	CString SaveAsPublic();
public:
	ULONG b;
	NN pq,e,d,p,q,dp,dq,qp;
};

#if !defined(RSA_ONLY) || defined(MRSA_C)

#define UNIT_BITS 16		/* unit bits */
#define SIGN_BIT (1<<15)	/* top bit of unit */
#define PRIMES 54		/* number of primes in prime table */

#ifdef	RSA_ONLY	/* define RSA_ONLY if math stuff not needed */
#define PRIVATE static
#else
#define PRIVATE
#endif


int	ts(N a);		/* test signed, returns -1, 0 or 1 */
ULONG	ng(N a);		/* negate, return carry*/
void	clearN(N a);		/* clear */
void	copyN(N a,N b);		/* copy, a = b */
int	cu(N a,N b);		/* compare unsigned, returns, -1 0 or 1 */
ULONG	ad(N a,N b);		/* add, a += b */
ULONG	sb(N a,N b);		/* substract, a -= b */
ULONG	sr(N a);		/* shift right, a >>= 1, return carry */
ULONG	sl(N a);		/* shift left, a <<= 1, return carry */
void	dm(N a,N b,N c);	/* div-mod unsigned, a /= b, c = a % b */
void	mu(N a,N b);		/* multiply unsigned, a *= b */
void	mm(N a,N b,N m);	/* modular multiply, a = a * b mod m */
void	em(N a,N e,N m);	/* modular exponentiation, a = a^e mod m */
void	gd(N a,N b);		/* greatst common divisor, a = gcd(a,b) */
void	iv(N a,N b);		/* multiplicative inverse, a = a^{-1} mod p */
void	Num2Hex(char *a,N b);	/* convert number to hex string */
void	Hex2Num(N a,char *b);	/* convert lowercase hex string to number */
ULONG	ri();			/* weak pseudorandom integer */

#endif /* RSA_C */

void	randomize(N a, ULONG bits);
ULONG	sieve_prime(N);
int	prob_prime(N);
void	next_prime(N);
ULONG 	rsa_gen(rsa_key *);
void 	rsa_enc(N,rsa_key *);
void 	rsa_dec(N,rsa_key *);
ULONG 	n_to_b(unsigned char *,N);
void 	b_to_n(N,unsigned char *,ULONG);

#define HashStrip(A) {									\
		const int nLen = A.GetLength() - 9;				\
		A = A.Right(nLen);								\
	}

#define HashGetUserKey(A) {								\
		A = Options.GetUserKey();						\
		HashStrip(A);									\
	}

#define HashDecodeUserKey(B, A) {						\
		rsa_key rsaKey;									\
		CString strPublicKey;							\
		strPublicKey.LoadString(IDS_RSA_KEY);			\
		rsaKey.Load(strPublicKey);						\
		B = rsaKey.DeCode(A);							\
	}


#endif /* MRSA_H */

