/****************************** Utility.h ***********************************
****************************************************************************/

#ifndef __UTILITY_H__
#define __UTILITY_H__


/*
 *	REMINDER() and FIXME() macros are to be used to warn about possible
 *	problems or 'todo' items. The usage is:
 *
 *	#pragma RENINDER( msg )
 *	#pragma FIXME( msg )
 *
 *  During the debug/development build they will generate compile time
 *	messages, for RELEASE build, FIXME() will cause a compilation error.
 */

#define chSTR( x )			#x
#define chSTR2( x )			chSTR( x )
#define FILEANDLINE()		__FILE__"("chSTR2( __LINE__ )") : "

#define REMINDER( desc )	message( FILEANDLINE() desc )

#if defined( RELEASE )
/* we want to generate a compile error for items that have to be fixed */
#pragma warning( error : 4612 )
#define FIXME( desc )		include_alias( "FILEANDLINE()", <desc> )	
#else
#define FIXME( desc )		REMINDER( "MUST BE FIXED! " desc )
#endif


/* get the number of items in array */
#define TBLSIZE( tbl )		( sizeof( tbl ) / sizeof( tbl[0] ) )


#define STATUS_CHAR			0
#define STATUS_INT			1
#define STATUS_LONG			2
#define STATUS_STRING		3
#define STATUS_FLOAT		4

//#include <ospace/stl.h>
//#include <ospace/string.h>

__declspec(dllexport) void ProcessMessages(int message=-1);
__declspec(dllexport) void Error(LPCTSTR format,...);
__declspec(dllexport) void StatusMessage(CWnd* pWnd,LPCTSTR szFormat,...);
__declspec(dllexport) CString GetFileName(CString strFileName);
__declspec(dllexport) CString GetPath(CString strFileName);
__declspec(dllexport) CString GetExtension(CString strFileName);
__declspec(dllexport) int GetFileSize( LPCTSTR szFileName );
__declspec(dllexport) CString GetUserName();
__declspec(dllexport) CString GetRootDirName(CString strPath);
__declspec(dllexport) CString ParseOneArg(CString& strSource);
__declspec(dllexport) unsigned long CreateUID();
__declspec(dllexport) BOOL Exists(CString strFileName);
__declspec(dllexport) BOOL ExistsDir(CString strDirName);
__declspec(dllexport) BOOL CreateDirPath( LPCTSTR szDirectory );
__declspec(dllexport) BOOL StrSuf(CString strString,CString strSuf);
__declspec(dllexport) void StripWhitespace(CString& strSource);
__declspec(dllexport) void ConvertString(LPSTR szString,LPWSTR wszString,int len,BOOL bToWide);
__declspec(dllexport) CString GetModulePath();
__declspec(dllexport) CString GetCurrentPath();
__declspec(dllexport) CDocTemplate* GetDocTemplate(CWinApp *pApp,int nTemplateIndex);
__declspec(dllexport) CDocument* NewDocument(CWinApp *pApp,int nTemplateIndex,LPCTSTR szFileName=NULL, BOOL bMakeVisible = TRUE);
__declspec(dllexport) void ListAllDocuments(CWinApp *pApp,int nTemplateIndex,CObList& lstDocuments);
__declspec(dllexport) unsigned long HexToLong(LPCTSTR s);
__declspec(dllexport) CDocument* GetDoc(CWinApp *myApp,int nTemplateIndex);
__declspec(dllexport) void SubstStr(CString &source,LPCTSTR what, LPCTSTR with);
__declspec(dllexport) int StrStrNoCase(CString strSource,CString strSearch,BOOL bWholeWord=FALSE);
__declspec(dllexport) int FindWholeWord(LPCTSTR szSearchIn,LPCTSTR szSearchFor);
__declspec(dllexport) CString GetLocalIniPath();
__declspec(dllexport) int GetEditBoxIndex(CEdit* pEdit);
__declspec(dllexport) CFrameWnd* GetFrameWindow(CWnd* pWnd);
__declspec(dllexport) CProgress* GetProgress(CWnd* pWnd);
__declspec(dllexport) CWnd* GetFirstChild(CWnd* pWnd,DWORD dwStyle=WS_TABSTOP,BOOL bEnabled=TRUE);
__declspec(dllexport) CWnd* GetLastChild(CWnd* pWnd,DWORD dwStyle=WS_TABSTOP,BOOL bEnabled=TRUE);
__declspec(dllexport) void CmdRouteMenu(CWnd* pWnd,CMenu* pPopupMenu);
__declspec(dllexport) BOOL IsPressed(int nVirtKey);
__declspec(dllexport) void ConvertToUNC( CString& strPath );
__declspec(dllexport) BOOL CreatePointFont(CFont& font,int nPointSize,LPCTSTR szFaceName,int nWeight=400,BOOL bUnderline=FALSE,BOOL bItalics=FALSE);
__declspec(dllexport) void DrawShellIcon(CDC* pDC,LPCTSTR szPath,CPoint point);
__declspec(dllexport) LPCTSTR AbbreviateString(CDC* pDC,LPCTSTR szString,int nWidth);
__declspec(dllexport) BOOL IsNumber(LPCTSTR szNumber,BOOL bFloat=TRUE);

// Returns a pointer to an error string associated with the (Windows) error
// code. If the error code is (-1), it will call GetLastError() and then
// retrieve the message.
__declspec(dllexport)
CString
GetLastErrorString(
	DWORD	dwErrCode = 0xffffffffL );

// Makes sure that the string can be correctly displayed in the rectangle of given size
//   Will replace some components with ... if needed
__declspec(dllexport) void FormatPathStringForDisplay( CDC* pDC, int nWidth, CString& strString );

// Tests the string for special characters: /\:*?"<>|
//   returns TRUE if non of the above appear in the string
__declspec(dllexport) BOOL IsValidFileName( LPCTSTR szFileName );

// Returns user local directory (to look for ini files)
__declspec(dllexport) CString GetUserDirectory();

#endif // __UTILITY_H__

/****************************** Utility.h **********************************/
