//	Encapsulates the MapiMessage structure

#ifndef __GCSMAPIMSG_H__
#define __GCSMAPIMSG_H__

#pragma once

#include "GCSDllExt.h"

#include <mapi.h>
#include "GCSMapiex.h"
#include "GCSMapifl.h"
#include "GCSMapirc.h"


class CLASS_DECL_GCS CGCSMapiMessage : public CObject
{
DECLARE_SERIAL( CGCSMapiMessage );

friend class CGCSMapi;


// Data members -------------------------------------------------------------
public:
	
protected:
    
private:
	lpMapiMessage		m_pMapiMessage;
	CGCSMapiRecipient	m_Orig, m_Recip;
	CGCSMapiFile			m_File;

// Member functions ---------------------------------------------------------
public:
	CGCSMapiMessage();
	// --- In  : 
	// --- Out : 
	// --- Returns :
	// --- Effect : Contructor of object
	//				It will initialize the internal state

    CGCSMapiMessage( lpMapiMessage pMessage );
	// --- In  : pMessage : pointer to a MapiMessage to initialize from
	// --- Out : 
	// --- Returns :
	// --- Effect : Contructor of object
	//				It will initialize the internal state from a MapiMessage pointer
    
	CGCSMapiMessage( CGCSMapiMessage& b );
	// --- In  : 
	// --- Out : 
	// --- Returns :
	// --- Effect : Copy constructor Can throw a CGCSMapiException
	//				It will initialize the internal state

	void Flush();
	// --- In  : 
	// --- Out : 
	// --- Returns : 
	// --- Effect : deallocates all allocated memory

	DWORD GetFlags();
	// --- In  : 
	// --- Out : 
	// --- Returns : the flags for a mapimessage structure
	// --- Effect : gets the flags for the mapimessage
	//				See MAPI doco for mapimessage flags types.
	
	DWORD SetFlags( DWORD dwNewFlags );
	// --- In  : 
	// --- Out : 
	// --- Returns : SUCCESS_SUCCESS, POINTER_NOT_THERE, or NOT_VALID_POSITION
	// --- Effect : sets the flags for the mapimessage
	//				See MAPI doco for mapimessage flags types.

    CString GetSubject();
	// --- In  : 
	// --- Out : 
	// --- Returns : the subject of the message
	// --- Effect : gets the subject of the message
	//				can throw a CGCSMapiException See MAPI doco for more info
		
	DWORD SetSubject( CString Subject );
	// --- In  : Subject : the new subject of the message
	// --- Out : 
	// --- Returns : SUCCESS_SUCCESS, POINTER_NOT_THERE or MEMORY_ERROR_ON_NEW 
	// --- Effect : sets the subject of the message	struct
	//				See MAPI doco for more info

	CString GetNoteText();
	// --- In  : 
	// --- Out : 
	// --- Returns : the text of the message
	// --- Effect : gets the text of the message
	//				can throw a CGCSMapiException See MAPI doco for more info
			
	DWORD SetNoteText( CString NoteText );
	// --- In  : NoteText : the new subject of the message
	// --- Out : 
	// --- Returns : SUCCESS_SUCCESS, POINTER_NOT_THERE or MEMORY_ERROR_ON_NEW 
	// --- Effect : sets the text of the message struct
	//				See MAPI doco for more info

	CString GetMessageType();
	// --- In  : 
	// --- Out : 
	// --- Returns : the type of the message
	// --- Effect : gets the type of the message
	//				can throw a CGCSMapiException See MAPI doco for more info
	
	DWORD SetMessageType( CString MessageType );
	// --- In  : MessageType : the new type of the message
	// --- Out : 
	// --- Returns : SUCCESS_SUCCESS, POINTER_NOT_THERE or MEMORY_ERROR_ON_NEW 
	// --- Effect : sets the type of the message
	//				See MAPI doco for more info

	DWORD GetTimeReceived( CTime& retval );
	// --- In  : 
	// --- Out : retval : the receive time of the message
	// --- Returns : SUCCESS_SUCCESS or POINTER_NOT_THERE
	// --- Effect : gets receive time of the message
	//				See MAPI doco for more info
			
	CString GetConversationID();
	// --- In  : 
	// --- Out : 
	// --- Returns : the conversationID of the message
	// --- Effect : gets the conversationID of the message
	//				can throw a CGCSMapiException See MAPI doco for more info
		
	DWORD SetConversationID( CString ConversationID );
	// --- In  : MessageType : the new conversationID of the message
	// --- Out : 
	// --- Returns : SUCCESS_SUCCESS, POINTER_NOT_THERE or MEMORY_ERROR_ON_NEW 
	// --- Effect : sets the conversationID of the message
	//				See MAPI doco for more info

	CGCSMapiRecipient& GetOriginator();
	// --- In  : 
	// --- Out : 
	// --- Returns : the originator of the message
	// --- Effect : gets the originator of the message

	DWORD SetOriginator( CGCSMapiRecipient& recip );
	// --- In  : recip : the originator of the message
	// --- Out : 
	// --- Returns : SUCCESS_SUCCESS or POINTER_NOT_THERE
	// --- Effect : sets the originator of the message
	//				can throw a CGCSMapiException See MAPI doco for more info

	CGCSMapiRecipient& GetRecips();
	// --- In  : 
	// --- Out : 
	// --- Returns : the recipients of the message
	// --- Effect : gets the recipients of the message

	DWORD SetRecips( CGCSMapiRecipient& Recip );
	// --- In  : recip : the recipients of the message
	// --- Out : 
	// --- Returns : SUCCESS_SUCCESS or POINTER_NOT_THERE
	// --- Effect : sets the recipients of the message
	//				can throw a CGCSMapiException See MAPI doco for more info
	
	CGCSMapiFile& GetFiles();	
	// --- In  : 
	// --- Out : 
	// --- Returns : the attachments of the message
	// --- Effect : gets the attachments of the message

	DWORD SetFiles( CGCSMapiFile& File );
	// --- In  : File : the attachments of the message
	// --- Out : 
	// --- Returns : SUCCESS_SUCCESS or POINTER_NOT_THERE
	// --- Effect : sets the attachments of the message
	//				can throw a CGCSMapiException See MAPI doco for more info
	
	CGCSMapiMessage& operator=( CGCSMapiMessage& b );
	// --- In  : 
	// --- Out : 
	// --- Returns : 
	// --- Effect : assignment operator
	//				May throw a CGCSMapiFileException

	friend CArchive& AFXAPI operator <<( CArchive& ar, CGCSMapiMessage& file );
	// --- In  : 
	// --- Out : 
	// --- Returns : 
	// --- Effect : piping operator to disk
	//				may throw a CMemoryException, CArchiveException, CFileException, CGCSMapiException

    friend CArchive& AFXAPI operator >>( CArchive& ar, CGCSMapiMessage& file );
	// --- In  : 
	// --- Out : 
	// --- Returns : 
	// --- Effect : piping operator from disk
	//				may throw a CMemoryException, CArchiveException, CFileException, CGCSMapixception
	        
#ifdef _DEBUG
	virtual void Dump(CDumpContext&) const;
	virtual void AssertValid() const;
#endif //_DEBUG

	virtual ~CGCSMapiMessage();
	// --- In  :
	// --- Out : 
	// --- Returns :
	// --- Effect : Destructor of object

protected:      

private:
	// Helper functions;
	DWORD SetTimeReceived( CTime time );
	
	DWORD CreatePointer();
	
	DWORD CopyFromPointer( lpMapiMessage pMessage );

	lpMapiMessage GetPointer();
                   
};

CArchive& AFXAPI operator <<( CArchive& ar, CGCSMapiMessage& file );
CArchive& AFXAPI operator >>( CArchive& ar, CGCSMapiMessage& file );


#endif
