#ifndef GCSMisc_H__
#define GCSMisc_H__

#include "ZipAPI.h"
#include "GCSFindFile.h"
#include "GCPriority.h"
#include "GCMemory.h"
#include "GCCompression.h"
#include "GCTime.h"

// Get the path name of the current process (DLL, EXE, EAX, etc.)
CString GCS_CLASS_DECL GetModulePath();

// Return the path protion of the passed in filename (C:\Util\RunMe.exe will return C:\Util\)
CString GCS_CLASS_DECL GetPath(CString strFileName);

// Return the filename protion of the passed in filename (C:\Util\RunMe.exe will return RunMe.exe)
CString GCS_CLASS_DECL GetFileName(CString strFileName);

// Return the file extension protion of the passed in filename (C:\Util\RunMe.exe will return .exe)
CString GCS_CLASS_DECL GetExtension(CString strFileName);

// Expands macros in a string (normally used for parameters passed to another program)
//	%USERNAME%
//	%PASSWORD%
//	%SENDER%
//	%ASSISTANT%
//	%SUBJECT%
//	%ATTACHMENT%
CString GCS_CLASS_DECL XlateParam(CString strParam, CString &strUserName, CString &strUserPassword, CString &strFrom, CString &strSubject, CString &strAssist, CString &strAttachPath);


#define WordSize	4

	// output a message while compiling, with file and line #.
#define chSTR(x) #x
#define chSTR2(x) chSTR(x)
#define FILEANDLINE __FILE__"("chSTR2(__LINE__)") : "
#define REMINDER(desc) message(FILEANDLINE desc)

static inline int rand(int max)
{
	return (rand() % max);
}

class GCS_CLASS_DECL DCSaveState
{
public:
	DCSaveState(CDC* pDC1) { m_pDC = pDC1; DCsaveState = m_pDC->SaveDC(); };
	~DCSaveState() { m_pDC->RestoreDC(DCsaveState); };
private:
	int DCsaveState;
	CDC* m_pDC;
};

void GCS_CLASS_DECL ProcessMessages(int message);

#endif