#ifndef __STL_HPP
#define __STL_HPP

#include <map>
#include <set>

using namespace std;

typedef set< int, less<int> > set_of_int;
typedef set< String, less<String> > set_of_str;
typedef set< char, less<char> > set_of_char;

typedef map< String, set_of_str, less<String> > string_groups;
typedef map< String, unsigned, less<String> > map_of_su;
typedef map< String, bool, less<String> > map_str_bool;
typedef map< String, String, less<String> > map_of_str;
typedef map< int, bool, less<int> > map_int_bool;
typedef map< int, String, less<int> > map_int_str;

typedef multimap< unsigned, unsigned, less<unsigned> > multimap_uu;
typedef multimap< String, int, less<String> > multimap_of_si;

typedef map< String, TForm*, less<String> > forms_t;

template <class FI> void map_release(FI first, FI last) {
	while(first != last) {
		delete (*first).second;
		first++;
	}
}

template <class FI> void sequence_release(FI first, FI last) {
	while(first != last) {
		delete (*first);
		first++;
	}
}

#include "datety.hpp"
#include "numeric.hpp"
#include "text.hpp"

#endif // __STL_HPP

