#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <dir.h>
#include <ctype.h>

#define TRUE 1
#define FALSE 0

#pragma startup expand_wildcards 10
#define MAXFILES 10000

extern int _argc ;
extern char ** _argv_arr ;
static char oldcwd[256];
static int oldDrive = 0;
static struct ffblk fileBlock;
static char **filelist=0;
static int filenum=0,filecount=0;

static char *FirstFile(char *spec)
{
  if (findfirst(spec, &fileBlock, _A_NORMAL ))
    return(0);
  return(fileBlock.ff_name) ;
}
static char *NextFile(void)
{
  if (findnext( &fileBlock))
    return(0);
  return(fileBlock.ff_name);
}
static int rfsort(const void *elem1, const void *elem2)
{
	return(strcmp(*(char **)elem1, *(char **)elem2));
}
static char *litlate(char *dir, char *t)
{
   char *q,buf[256];
	if (!t)
		return 0;
   if (dir) {
      strcpy(buf,dir) ;
      q = strrchr(buf,'\\') ;
      if (q)
        strcpy(q+1,t) ;
      else
         strcpy(buf,t) ; 
   } else
      strcpy(buf,t) ;
   q = malloc(strlen(buf)+1);
	if (!q) {
		fprintf(stdout,"out of memory");
		exit(1) ;
	}
   strcpy(q,buf);
	return q;
}
static void ClearFiles(void)
{
	free(filelist);
	filelist = 0;
	filecount = 0 ;
}
static char *ReadFiles(char *spec)
{
   char buf[256] ;
   int fullpath = FALSE ;
   if (spec[0] == '.') {
      char *p ;
      getcwd(buf,256) ;
      p = strlen(buf) + buf ;

      while (spec[0] == '.' && spec[1] == '.') {
         spec += 2 ;
         while (*(p-1) != '\\' && *(p-1) != ':')
            p-- ;
         if (*(p-1) == '\\')
            p-- ;
         if (spec [0] != '\\')
            break ;
         spec++ ;
      }
      *p++ = '\\' ;
      strcpy(p,spec) ;
   } else
      strcpy(buf,spec) ;
   if (strchr(buf,'\\'))
      fullpath = TRUE ;
	if (!filelist) {
		filelist = malloc(sizeof(char *)*MAXFILES);
		if (!filelist) {
			fprintf(stderr,"out of memory");
			exit(1) ;
		}
	}
   if ((filelist[0] = litlate(fullpath ? buf : 0,FirstFile(buf))) == 0) {    
		return 0;
	}
   while((filelist[++filecount] = litlate(fullpath ? buf : 0,NextFile())) != 0)
		if (filecount >= MAXFILES-1) {
			fprintf(stderr,"Too many files... qualify file names to limit to %d at a time",MAXFILES);
			break ;
		}
	return (char *)1;
}
static int qualify(char *name)
{
  int i ;
	for(i=0; i < strlen(name); i++)
      if (!isalnum(*name) && *name != '\\' && *name != ':' && *name != '*' && *name != '?' && *name != '.')
			return FALSE ;
	return TRUE ;
}
void expand_wildcards( void) 
{
  int i;
	filenum = 0;
	filecount = 0;
  for (i=1; i< _argc; i++) {
    char *dir;
    char *file;
    char *fileName;
    int drive;
		if (qualify(_argv_arr[i])) {
      if ((fileName = ReadFiles(_argv_arr[i])) == 0) {
       	continue;
    	}    	
			if (filecount) {
				_argv_arr = realloc(_argv_arr,(_argc + filecount) * sizeof(char *)) ;
				memmove(_argv_arr+i+filecount,_argv_arr+i+1,(_argc - i)* sizeof(char *)) ;
				memcpy(_argv_arr+i,filelist,filecount *sizeof(char *)) ;
				_argc += filecount-1 ;
				i += filecount-1 ;
				ClearFiles() ;
			}
		}
	}
}