#include "chartdir.h"

int main(int argc, char *argv[])
{
	//The data for the chart
	double data[] = {25, 18, 9, 4, 5, 8, 14, 20, 40, 92, 75, 88, 75, 
		58, 90, 95, 83, 75, 70, 66, 46, 38, 28, 15, 22};

	//The labels for the bottom x axis. Note the "-" means a minor tick.
	const char *label0[] = {"0\nJun 4", "-", "-", "3", "-", "-", "6", 
		"-", "-", "9", "-", "-", "12", "-", "-", "15", "-", "-", "18",
		"-", "-", "21", "-", "-", "0\nJun 5"};

	//The labels for the top x axis. Note that "-" means a minor tick.
	const char *label1[] = {"Jun 3\n12", "-", "-", "15", "-", "-", "18",
		"-", "-", "21", "-", "-", "Jun 4\n0", "-", "-", "3", "-", "-", "6",
		"-", "-", "9", "-", "-", "12"};

	//First, create a XYChart of size 300 pixels x 320 pixels
	XYChart *c = XYChart::create(320, 320);

	//Set the plotarea at (60, 50) and of 200 pixel (w) x 200 pixels (h)
	c->setPlotArea(60, 50, 200, 200);

	//Add a title to the primary (left) y-axis
	c->yAxis()->setTitle("Server Load (%)");

	//Set the tick length to -4 pixels (-ve means ticks inside the plot area)
	c->yAxis()->setTickLength(-4);

	//Add a title to the secondary (right) y-axis
	c->yAxis2()->setTitle("Transactions per hour");

	//Set the tick length to -4 pixels (-ve means ticks inside the plot area)
	c->yAxis2()->setTickLength(-4);

	//Set y2 = 300 x y1 (that means 1% load = 300 transactions per hour)
	c->syncYAxis(300);

	//Add a title to the bottom x-axis
	c->xAxis()->setTitle("Hong Kong Time");
	
	//Set the x axis labels using the supplied labels
	c->xAxis()->setLabels(sizeof(label0) / sizeof(label0[0]), label0);

	//Set the major tick length to -4 pixels and minor tick length to -2 pixels
	//(-ve means ticks inside the plot area)
	c->xAxis()->setTickLength(-4, -2);

	//Add a title to the top x-axis
	c->xAxis2()->setTitle("New York Time");

	//Set the x axis labels using the supplied labels
	c->xAxis2()->setLabels(sizeof(label1) / sizeof(label1[0]), label1);

	//Set the major tick length to -4 pixels and minor tick length to -2 pixels
	//(-ve means ticks inside the plot area)
	c->xAxis2()->setTickLength(-4, -2);

	c->xAxis2()->setColors(0, 0);
	
	//Add an line layer to the chart
	c->addLineLayer(sizeof(data) / sizeof(data[0]), data, 0x0000ff);

	//output the chart as a PNG file
	c->makeChart("dualxaxis.png");

	//destroy the chart to free up resources
	c->destroy();

	return 0;
}

