#include "chartdir.h"

int main(int argc, char *argv[])
{
	//The data for the area chart
	double data0[] = {25, 18, 9, 4, 5, 8, 14, 20, 40, 92, 75, 88, 75, 
		58, 90, 95, 83, 75, 70, 66, 46, 38, 28, 15, 22};
	double data1[] = {36, 28, 25, 33, 38, 42, 44, 36, 50, 68, 60, 50, 55, 
		67, 58, 52, 57, 46, 33, 38, 25, 33, 42, 37, 30};
	double data2[] = {88, 70, 43, 55, 35, 28, 17, 25, 30, 33, 36, 45, 28, 
		45, 60, 47, 25, 30, 41, 49, 67, 82, 88, 95, 98};

	//The labels for the area chart
	const char *labels[] = {"0", "", "", "3", "", "", "6", "", "", "9", "", "", 
		"12", "", "", "15", "", "", "18", "", "", "21", "", "", "24"};
	
	//First, create a XYChart of size 500 pixels x 300 pixels
	XYChart *c = XYChart::create(500, 300);

	//Set the plotarea rectangle to start at (90, 30) and of 
	//300 pixels in width and 240 in height
	c->setPlotArea(90, 30, 300, 240);

	//Add a legend box at (410, 100)
	c->addLegend(410, 100);

	//Add a title to the chart
	c->addTitle("Daily System Load");

	//Add a multiline title to the y axis. draw the title upright by setting the 
	//font angle 0 (the default is to draw the title sideways for y axis)
	c->yAxis()->setTitle("Database\nQueries\nper sec)")->setFontAngle(0);
	
	//Set the labels on the x axis
	c->xAxis()->setLabels(sizeof(labels) / sizeof(labels[0]), labels);

	//Add an area layer
	AreaLayer *layer = c->addAreaLayer();

	//Draw the area layer in 3D
	layer->set3D();

	//Add the three data sets to the area layer
	layer->addDataSet(sizeof(data0) / sizeof(data0[0]), data0, -1, "Server #1");
	layer->addDataSet(sizeof(data1) / sizeof(data1[0]), data1, -1, "Server #2");
	layer->addDataSet(sizeof(data2) / sizeof(data2[0]), data2, -1, "Server #3");

	//output the chart as a PNG file
	c->makeChart("stackarea.png");

	//destroy the chart to free up resources
	c->destroy();

	return 0;
}

