#include "chartdir.h"

void background(const char *img, const char *filename)
{
	//data for chart
	double data[] = {85, 156, 179.5, 211, 123};
	const char *labels[] = {"Mon", "Tue", "Wed", "Thu", "Fri"};

	//create a chart object of 300(w) x 300(h) 
	XYChart *c = XYChart::create(300, 300);

	if (img)
		//has wallpaper image, use it as background
		c->setWallpaper(img);
	else
		//no wallpaper image, use a dark background palette
		c->setColors(whiteOnBlackPalette);
	
	//set the plot area to start at (50, 50) and of size 200(w) x 200(h)
	c->setPlotArea(50, 50, 200, 200);

	//Set the labels on the x axis using the supplied labels
	c->xAxis()->setLabels(sizeof(labels) / sizeof(labels[0]), labels);

	//Add a 3D bar layer using the supplied data
	c->addBarLayer(sizeof(data) / sizeof(data[0]), data, 0x00ff00)->set3D();

	//output the chart
	c->makeChart(filename);

	//destroy the chart to free up resources
	c->destroy();
}


int main(int argc, char *argv[])
{
	background("tile.gif", "imgbg.png");
	background(0, "darkbg.png");
	return 0;
}

