/*
 * Decompiled with CFR 0.152.
 */
import java.util.NoSuchElementException;

public class VectorBoolean {
    public boolean[] elementData;
    public int elementCount;
    protected int capacityIncrement;
    protected int initialCapacity;
    public int index = 0;

    public VectorBoolean(int n, int n2) {
        this.elementData = new boolean[n];
        this.capacityIncrement = n2;
        this.initialCapacity = n;
    }

    public VectorBoolean(int n) {
        this(n, 1);
    }

    public VectorBoolean() {
        this(16);
    }

    public void clear() {
        this.elementData = new boolean[this.initialCapacity];
        this.elementCount = 0;
    }

    public final synchronized void copyInto(boolean[] blArray) {
        int n = this.elementCount;
        while (n-- > 0) {
            blArray[n] = this.elementData[n];
        }
    }

    public final synchronized void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            boolean[] blArray = this.elementData;
            this.elementData = new boolean[this.elementCount];
            VectorBoolean.copy(blArray, this.elementData, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3;
            boolean[] blArray = this.elementData;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new boolean[n3];
            VectorBoolean.copy(blArray, this.elementData, this.elementCount);
        }
    }

    public final synchronized void setSize(int n) {
        if (n > this.elementCount) {
            this.ensureCapacity(n);
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                this.elementData[i] = false;
            }
        }
        this.elementCount = n;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final synchronized boolean elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(new StringBuffer(String.valueOf(n)).append(" >= ").append(this.elementCount)));
        }
        return this.elementData[n];
    }

    public final synchronized void setElementAt(boolean bl, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(new StringBuffer(String.valueOf(n)).append(" >= ").append(this.elementCount)));
        }
        this.elementData[n] = bl;
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(new StringBuffer(String.valueOf(n)).append(" >= ").append(this.elementCount)));
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            VectorBoolean.copy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = false;
    }

    public final synchronized void insertElementAt(boolean bl, int n) {
        if (n >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(new StringBuffer(String.valueOf(n)).append(" > ").append(this.elementCount)));
        }
        this.ensureCapacity(this.elementCount + 1);
        VectorBoolean.copy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = bl;
        ++this.elementCount;
    }

    public final synchronized void addElement(boolean bl) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = bl;
    }

    public final synchronized void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = false;
        }
        this.elementCount = 0;
    }

    public static void copy(boolean[] blArray, boolean[] blArray2, int n) {
        for (int i = 0; i < n; ++i) {
            blArray2[i] = blArray[i];
        }
    }

    public static void copy(boolean[] blArray, int n, boolean[] blArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            blArray2[i + n2] = blArray[i + n];
        }
    }

    public void restart() {
        this.index = 0;
    }

    public boolean hasMoreElements() {
        return this.index < this.elementCount;
    }

    public boolean nextElement() {
        if (this.index < this.elementCount) {
            return this.elementData[this.index++];
        }
        throw new NoSuchElementException("BooleanEnumerator");
    }
}

