/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;

public class DComboBox
extends Panel
implements ActionListener,
MouseListener {
    boolean traversable;
    boolean wasPressed = false;
    protected String actionCommand;
    protected ActionListener actionListener = null;
    protected ComboField editBox;
    protected ComboButton arrow;
    protected ComboList list;
    protected transient boolean bOverList = false;
    protected transient boolean bDown = false;
    protected transient String sLastText;
    protected boolean bEditable;
    protected boolean bSearchable;
    protected boolean bCaseSensitive;
    protected int ix;
    protected int iy;
    protected int iwidth;
    protected int lheight;
    protected int arrowDim;
    protected int hPad = 1;
    protected int vPad = 0;
    protected boolean showHScroll = false;
    protected boolean showVScroll = true;
    protected String sSearchText;
    protected String sSearchItem;
    protected String sSearchOrig;
    protected int searchIndex;
    protected int searchLen;
    protected int searchI;
    protected static transient boolean bOsFlag = !OS.isWindows() && !OS.isMacintosh();
    private KeyList _$22177 = null;
    private KeyBox _$22191 = null;
    private Focus _$22207 = null;
    private Item _$21815 = null;
    public int MAXITEMS = 16;
    public int baseSize = 0;

    public DComboBox() {
        this(true, false, 0);
    }

    public DComboBox(int n) {
        this(true, false, n);
    }

    public DComboBox(boolean bl, boolean bl2, int n) {
        super.setLayout(null);
        this.editBox = new ComboField("", n);
        this.editBox.setEditable(false);
        this.editBox.addMouseListener(this);
        this.arrow = new ComboButton(3);
        this.arrow.setShowFocus(true);
        this.arrow.setEnabled(false);
        this.arrow.setBevelHeight(2);
        this.arrow.setComboEnabled(false);
        this.arrow.setBorderEnabled(false);
        this.arrow.addActionListener(this);
        this.list = new ComboList(true);
        this.list.hide();
        this.list.setComboMode(true);
        this.list.setShowHorizontalScroll(false);
        this.list.setShowVerticalScroll(true);
        this.list.addMouseListener(this);
        this.add(this.list);
        this.add(this.editBox);
        this.add(this.arrow);
        this.lheight = 0;
        this.traversable = true;
        this.setEditable(bl);
        this.setSearchable(bl2);
        this.bCaseSensitive = true;
    }

    public void setShowFocus(boolean bl) {
        this.traversable = bl;
        this.arrow.setShowFocus(bl);
    }

    public boolean isFocusTraversable() {
        return this.traversable;
    }

    public void setArrowStyle(boolean bl, boolean bl2, int n) {
        this.arrow.setComboEnabled(bl);
        this.arrow.setBorderEnabled(bl2);
        this.arrow.setBevelHeight(n);
    }

    public void setEditable(boolean bl) {
        this.bEditable = bl;
        this.editBox.setEditable(this.bEditable || this.bSearchable);
    }

    public void setSearchable(boolean bl) {
        this.bSearchable = bl;
        this.editBox.setEditable(this.bEditable || this.bSearchable);
    }

    public void setCaseSensitive(boolean bl) {
        this.bCaseSensitive = bl;
    }

    public void setShowHorizontalScroll(boolean bl) {
        if (this.showHScroll != bl) {
            this.showHScroll = bl;
            this.list.setShowHorizontalScroll(bl);
        }
    }

    public boolean isShowHorizontalScroll() {
        return this.showHScroll;
    }

    public void setShowVerticalScroll(boolean bl) {
        if (this.showVScroll != bl) {
            this.showVScroll = bl;
            this.list.setShowVerticalScroll(bl);
        }
    }

    public boolean isShowVerticalScroll() {
        return this.showVScroll;
    }

    public void setListItems(String[] stringArray) {
        this.reset();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addItem(stringArray[i]);
        }
    }

    public String[] getListItems() {
        int n = this.countItems();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getItem(i);
        }
        return stringArray;
    }

    public synchronized void setFont(Font font) {
        super.setFont(font);
        this.editBox.setFont(font);
        this.list.setFont(font);
        this.repaint();
    }

    public String getItem(int n) {
        return this.getListText(n);
    }

    public String getListText(int n) {
        return this.list.getText(n);
    }

    public void setText(String string) {
        this.editBox.setText(string);
    }

    public String getText() {
        this.verify();
        return this.editBox.getText();
    }

    public String getSelectedItem() {
        return this.list.getSelectedItem();
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public synchronized boolean isSelected(int n) {
        return this.list.isSelected(n);
    }

    public static boolean addFirstTopDown() {
        return !DComboBox.addLastBottomUp();
    }

    public static boolean addLastBottomUp() {
        return OS.isFirstDrawnOverSecond();
    }

    public static boolean needsPlatformHelp() {
        return bOsFlag;
    }

    public void clear() {
        this.list.clear();
        this.baseSize = 0;
    }

    public void reset() {
        this.list.clear();
        this.editBox.setText("");
    }

    public synchronized void addItem(String string) {
        this.addItem(null, string, true);
    }

    public synchronized void addItem(String string, boolean bl) {
        this.addItem(null, string, bl);
    }

    public synchronized void addItem(Image image, String string) {
        this.addItem(image, string, true);
    }

    public synchronized void addItem(Image image, String string, boolean bl) {
        this.list.addItem(image, string, bl);
        this.arrow.setEnabled(true);
    }

    public synchronized boolean addUnicItem(String string) {
        int n = this.countItems();
        for (int i = 0; i < n; ++i) {
            if (!Sort.superEquals(this.getItem(i), string)) continue;
            return false;
        }
        if (n >= this.MAXITEMS) {
            this.delItem(this.baseSize);
            n = this.MAXITEMS - 1;
        }
        this.list.addItem(null, string);
        return true;
    }

    public int countItems() {
        return this.list.countItems();
    }

    public void setImage(int n, Image image) {
        this.list.setImage(n, image);
    }

    public void setListText(int n, String string) {
        this.list.setText(n, string);
    }

    public void setEnabled(int n) {
        this.setEnabled(n, true);
    }

    public void setEnabled(int n, boolean bl) {
        this.list.setEnabled(n, bl);
    }

    public synchronized void delItem(int n) {
        this.list.delItem(n);
        if (this.list.countItems() == 0) {
            this.arrow.setEnabled(false);
            this.setListDown(false);
        }
    }

    public synchronized void delItems(int n, int n2) {
        this.list.delItems(n, n2);
        if (this.list.countItems() == 0) {
            this.arrow.setEnabled(false);
            this.setListDown(false);
        }
    }

    public synchronized void delSelectedItem() {
        this.list.delSelectedItems();
    }

    public synchronized void select(int n) {
        if (n >= 0 && n <= this.list.countItems()) {
            this.list.setSelectedIndex(n, true);
            this.editBox.setText(this.list.getSelectedItem());
            if (bOsFlag) {
                this.repaint();
            }
        }
    }

    public void select(String string) {
        this.list.setSelectedItem(string, true);
        this.editBox.setText(this.list.getSelectedItem());
        if (bOsFlag) {
            this.repaint();
        }
    }

    public synchronized void deselect(int n) {
        this.list.setSelectedIndex(n, false);
        this.editBox.setText("");
    }

    public void setListDown(boolean bl) {
        if (this.bDown != bl) {
            this.bDown = bl;
            if (this.bDown) {
                this.list.show();
                this.vPad = 1;
            } else {
                this.list.hide();
                this.vPad = 0;
            }
            this.reshapeInternals();
            super.reshape(this.ix, this.iy, this.iwidth, this.lheight + this.arrowDim + this.vPad);
            this.invalidate();
        }
    }

    public boolean isListDown() {
        return this.bDown;
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.ix = n;
        this.iy = n2;
        this.iwidth = n3;
        this.reshapeInternals();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.reshapeInternals();
    }

    public Dimension getPreferredSize() {
        this.reshapeInternals();
        int n = this.editBox.getPreferredSize().width;
        if (this.bDown) {
            return new Dimension(n + this.arrowDim + this.hPad, this.arrowDim + this.vPad + this.lheight);
        }
        return new Dimension(n + this.arrowDim + this.hPad, this.arrowDim);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this._$22177 == null) {
            this._$22177 = new KeyList();
            this.list.addKeyListener(this._$22177);
        }
        if (this._$22191 == null) {
            this._$22191 = new KeyBox();
            this.editBox.addKeyListener(this._$22191);
        }
        if (this._$21815 == null) {
            this._$21815 = new Item();
            this.list.addItemListener(this._$21815);
        }
        if (this._$22207 == null) {
            this._$22207 = new Focus();
            this.addFocusListener(this._$22207);
            this.arrow.addFocusListener(this._$22207);
            this.editBox.addFocusListener(this._$22207);
        }
    }

    public synchronized void removeNotify() {
        if (this._$22177 != null) {
            this.list.removeKeyListener(this._$22177);
            this._$22177 = null;
        }
        if (this._$22191 != null) {
            this.editBox.removeKeyListener(this._$22191);
            this._$22191 = null;
        }
        if (this._$21815 != null) {
            this.list.removeItemListener(this._$21815);
            this._$21815 = null;
        }
        if (this._$22207 != null) {
            this.removeFocusListener(this._$22207);
            this.arrow.removeFocusListener(this._$22207);
            this.editBox.removeFocusListener(this._$22207);
            this._$22207 = null;
        }
        super.removeNotify();
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public void validate() {
        super.validate();
        this.reshapeInternals();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.list) {
            this.bOverList = true;
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.bOverList = false;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        this.wasPressed = object == this.editBox;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.editBox && this.wasPressed && !this.bEditable && !this.bSearchable) {
            this.setListDown(!this.bDown);
        }
        this.wasPressed = false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof DirButton) {
            this.setListDown(!this.bDown);
        } else if (actionEvent.getActionCommand().equals("ImageSelected")) {
            this.sourceActionEvent("ImageSelected");
        }
    }

    protected void sourceActionEvent(String string) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    protected void sourceActionEvent() {
        this.sourceActionEvent(this.actionCommand);
    }

    protected void reshapeInternals() {
        Dimension dimension = this.size();
        Dimension dimension2 = this.arrow.getPreferredSize();
        Dimension dimension3 = this.editBox.getPreferredSize();
        this.arrowDim = Math.max(dimension2.width, dimension2.height);
        if (dimension3.height > this.arrowDim) {
            this.arrowDim = dimension3.height;
        }
        if (OS.isMacintosh()) {
            ++this.arrowDim;
            this.editBox.reshape(0, 1, dimension.width + 1 - this.arrowDim - this.hPad, dimension3.height);
        } else {
            this.editBox.reshape(0, 0, dimension.width + 1 - this.arrowDim - this.hPad, dimension3.height);
        }
        this.arrow.setBounds(dimension.width - this.arrowDim, 0, this.arrowDim, this.arrowDim);
        if (this.bDown) {
            this.lheight = this.getParent() != null ? Math.min(this.getParent().bounds().height - this.iy - this.arrowDim - this.vPad, this.list.getMinimumSize().height) : this.list.getMinimumSize().height;
            this.list.reshape(0, this.arrowDim + this.vPad, dimension.width, this.lheight);
        } else {
            this.lheight = 0;
        }
    }

    protected void verify() {
        if (this.bSearchable) {
            this.searchIndex = this.editBox.getSelectionStart();
            this.sSearchOrig = this.editBox.getText().substring(0, this.searchIndex);
            this.sSearchText = this.bCaseSensitive ? this.sSearchOrig : this.sSearchOrig.toUpperCase();
            this.searchLen = this.list.countItems();
            if (this.sSearchText.length() > 0) {
                this.searchI = 0;
                while (this.searchI < this.searchLen) {
                    this.sSearchItem = this.bCaseSensitive ? this.list.getText(this.searchI) : this.list.getText(this.searchI).toUpperCase();
                    if (this.sSearchItem.startsWith(this.sSearchText)) {
                        this.editBox.setText(this.sSearchOrig);
                        this.list.setSelectedIndex(this.searchI, true);
                        this.editBox.select(this.searchIndex, this.searchIndex);
                        break;
                    }
                    ++this.searchI;
                }
                if (!this.bEditable && this.searchI == this.searchLen) {
                    this.editBox.setText(this.sLastText);
                    this.editBox.select(this.searchIndex - 1, this.searchIndex - 1);
                }
            }
        }
        this.sLastText = this.editBox.getText();
    }

    public int setMaxItems(int n) {
        int n2 = this.MAXITEMS;
        this.MAXITEMS = n;
        return n2;
    }

    public void setBaseSize(int n) {
        if (n >= this.MAXITEMS) {
            n = this.MAXITEMS;
        }
        this.baseSize = n;
    }

    public int getMaxItems() {
        return this.MAXITEMS;
    }

    public int getBaseSize() {
        return this.baseSize;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.arrow.setBackground(color);
        this.arrow.setComboColors(color);
        this.editBox.setBackground(color);
        this.list.setBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.arrow.setForeground(color);
    }

    public void setFieldsBackground(Color color) {
        this.editBox.setBackground(color);
        this.list.setBackground(color);
    }

    public void setFieldsForeground(Color color) {
        this.editBox.setForeground(color);
        this.list.setForeground(color);
    }

    public void setButtonBackground(Color color) {
        this.arrow.setBackground(color);
    }

    public void setStyle(Style style) {
        this.setFieldsBackground(style.background);
        this.setFieldsForeground(style.foreground);
        this.setFont(style.font);
    }

    public void deleteInList() {
        String string = this.editBox.getText();
        this.list.setSelectedItem(string, true);
        int n = this.list.getSelectedIndex();
        this.delSelectedItem();
        if (n >= this.list.countItems()) {
            --n;
        }
        string = n < 0 ? "" : this.list.getText(n);
        this.editBox.setText(string);
    }

    public void Resize(int n) {
        int n2 = this.getMaxItems();
        int n3 = OS.isWindows() ? this.baseSize : Preferences.MemBaseSize;
        int n4 = this.getBaseSize();
        if (n == n2 && n3 == n4) {
            return;
        }
        String[] stringArray = this.getListItems();
        int n5 = stringArray.length;
        n3 = SortDir.separeDrives(stringArray, 0, n5);
        this.clear();
        if (n < n5) {
            n5 = n;
        }
        for (int i = 0; i < n5; ++i) {
            this.addItem(stringArray[i]);
        }
        this.setMaxItems(n);
        this.setBaseSize(n3);
    }

    void separeDrives() {
        String[] stringArray = this.getListItems();
        int n = stringArray.length;
        int n2 = SortDir.separeDrives(stringArray, 0, n);
        this.clear();
        for (int i = 0; i < n; ++i) {
            this.addItem(stringArray[i]);
        }
        this.setBaseSize(n2);
    }

    void setBaseSize() {
        this.setBaseSize(SortDir.countDrives(this.getListItems()));
    }

    protected int search(String string) {
        if (string.length() < 1) {
            return -1;
        }
        int n = this.list.countItems();
        for (int i = 0; i < n; ++i) {
            if (!(this.bCaseSensitive ? this.list.getText(i).equalsIgnoreCase(string) : this.list.getText(i).equals(string))) continue;
            return i;
        }
        return -1;
    }

    class ComboList
    extends DListBox {
        public ComboList(boolean bl) {
            super(bl);
        }

        public boolean isFocusTraversable() {
            return DComboBox.this.traversable;
        }
    }

    class ComboButton
    extends DirButton {
        public ComboButton(int n) {
            super(n);
        }

        public boolean isFocusTraversable() {
            return DComboBox.this.traversable;
        }
    }

    class ComboField
    extends TextField {
        public ComboField(String string) {
            super(string);
        }

        public ComboField(String string, int n) {
            super(string, n);
        }

        public boolean isFocusTraversable() {
            return DComboBox.this.traversable;
        }
    }

    class Item
    implements ItemListener,
    Serializable {
        Item() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            DComboBox.this.editBox.setText(DComboBox.this.list.getSelectedItem());
            DComboBox.this.sourceActionEvent();
            DComboBox.this.setListDown(false);
        }
    }

    class Focus
    implements FocusListener,
    Serializable {
        Focus() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (object instanceof DComboBox && !DComboBox.this.bDown) {
                DComboBox.this.editBox.selectAll();
                DComboBox.this.editBox.requestFocus();
            }
            if (bOsFlag && object == DComboBox.this.editBox) {
                DComboBox.this.setListDown(false);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == DComboBox.this.arrow && !DComboBox.this.bOverList) {
                DComboBox.this.setListDown(false);
            }
        }
    }

    class KeyList
    extends KeyAdapter
    implements Serializable {
        KeyList() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 36: {
                    DComboBox.this.list.setSelectedIndex(0, true);
                    break;
                }
                case 35: {
                    DComboBox.this.list.setSelectedIndex(DComboBox.this.list.countItems() - 1, true);
                    break;
                }
                case 33: 
                case 38: {
                    DComboBox.this.list.setSelectedIndex(DComboBox.this.list.getSelectedIndex() - 1, true);
                    break;
                }
                case 34: 
                case 40: {
                    DComboBox.this.list.setSelectedIndex(DComboBox.this.list.getSelectedIndex() + 1, true);
                }
            }
            DComboBox.this.editBox.setText(DComboBox.this.list.getSelectedItem());
            DComboBox.this.editBox.selectAll();
            DComboBox.this.verify();
        }
    }

    class KeyBox
    extends KeyAdapter
    implements Serializable {
        KeyBox() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (keyEvent.isControlDown()) {
                switch (n) {
                    case 89: {
                        break;
                    }
                    case 88: {
                        DComboBox.this.editBox.setText("");
                    }
                }
            }
            switch (n) {
                case 10: {
                    break;
                }
                default: {
                    DComboBox.this.sLastText = DComboBox.this.editBox.getText();
                }
            }
        }
    }
}

