// DBFTable.h: interface for the CDBFTable class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DBFTABLE_H__0A9AEE21_19EA_11D4_80E1_00A02437D5FA__INCLUDED_)
#define AFX_DBFTABLE_H__0A9AEE21_19EA_11D4_80E1_00A02437D5FA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#include "adbf.h"


class CDBFTable  
{
	public:
		CDBFTable();
		virtual ~CDBFTable();

	public:

		BOOL			Open		(const char* sFileName);
		BOOL			Create		(const char* sFileName, int fCount, const DBFField* pDBFField);
		BOOL			Close		(void);
		BOOL			Pack		(void);
		BOOL			GetLastError(void);
		DBF_Error_Code	GetLastError(CString& sErrorMsg);
		BOOL			IsOpen		(void);

		const DBFField*	GetFields		(void);
		long			GetRecordCount	(void);
		long			GetRecordLength	(void);
		long			GetFieldCount	(void);
		long			GetRecordNumber	(void);
		long			GetRelRecordNumber(void);
		CString			GetVersion		(void);
		CString			GetFileName		(void);

		BOOL			IsRecordDeleted	(void);
		BOOL			GetShowDeleted	(void);
		BOOL			SetShowDeleted	(BOOL bShow);
		
		BOOL			IsBOF			(void);
		BOOL			IsEOF			(void);
		BOOL			GoTop			(void);
		BOOL			GoBottom		(void);
		BOOL			Skip			(long count = 1);
		BOOL			GoToRecord		(long recno);	// absolute record number (1,...)
		BOOL			GoToNonDeletedRecord (long recno);	// relative record number (1,...)
		BOOL			MoveTo			(long recno);

		BOOL			Append			(void);
		BOOL			Delete			(void);
		BOOL			Recall			(void);
		BOOL			Edit			(void);
		BOOL			Post			(void);
		BOOL			Cancel			(void);

		// Get Field Value: fieldNumber - from 0 to (FieldCount - 1)
		CString			GetString		(const char* pszFieldName);
		CString			GetString		(int fieldNumber);
		int				GetInt			(const char* pszFieldName);
		int				GetInt			(int fieldNumber);
		long			GetLong			(const char* pszFieldName);
		long			GetLong			(int fieldNumber);
		double			GetDouble		(const char* pszFieldName);
		double			GetDouble		(int fieldNumber);
		BOOL			GetLogical		(const char* pszFieldName);
		BOOL			GetLogical		(int fieldNumber);
		CTime			GetDate			(const char* pszFieldName);
		CTime			GetDate			(int fieldNumber);

		CString			GetStringField	(const char* pszFieldName);
		CString			GetStringField	(int fieldNumber);

		// Put Field Value: fieldNumber - from 0 to (FieldCount - 1)
		BOOL			PutString		(const char* pszFieldName, const char* sValue);
		BOOL			PutString		(int fieldNumber, const char* sValue);
		BOOL			PutInt			(const char* pszFieldName, int iValue);
		BOOL			PutInt			(int fieldNumber, int iValue);
		BOOL			PutLong			(const char* pszFieldName, long lValue);
		BOOL			PutLong			(int fieldNumber, long lValue);
		BOOL			PutDouble		(const char* pszFieldName, double fValue);
		BOOL			PutDouble		(int fieldNumber, double fValue);
		BOOL			PutLogical		(const char* pszFieldName, BOOL bValue);
		BOOL			PutLogical		(int fieldNumber, BOOL bValue);
		BOOL			PutDate			(const char* pszFieldName, CTime& dValue);
		BOOL			PutDate			(int fieldNumber, CTime& dValue);


	// Obsolete functions - only for compatibility
		long			GetRecNo		(void);
		BOOL			GetDeleted		(void);
		BOOL			GetEOF			(void);
		BOOL			GetBOF			(void);
		BOOL			MoveTop			(void);
		BOOL			MoveBottom		(void);
		
		BOOL			SetBoolField	(CString sFieldName, BOOL bValue);
		BOOL			SetFloatField	(CString sFieldName, double fValue);
		BOOL			SetStringField	(CString sFieldName, CString sValue);
		BOOL			SetDateField	(CString sFieldName, CTime dtValue);


		BOOL			GetBoolField	(CString sFieldName);
		double			GetFloatField	(CString sFieldName);
		CTime			GetDateField	(CString sFieldName);

	protected:
		DBFTable	m_pTable;


};

#endif // !defined(AFX_DBFTABLE_H__0A9AEE21_19EA_11D4_80E1_00A02437D5FA__INCLUDED_)
