VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "PowerPrn"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

' class handle
Dim hdl As Long


'function declarations

Private Sub Class_Initialize()
    hdl = CWin32Prn_CPP_CONSTRUCTOR()
End Sub


Private Sub Class_Terminate()
    CWin32Prn_CPP_DESTRUCTOR (hdl)
End Sub



Public Function GetDefaultPrinterName() As String

    Dim PrnName As String
    Dim ret As Long
    
    ' make sure that the buffer is large enough
    PrnName = String(200, 0)

    ' call API
    ret = dwGetDefaultPrinterName(hdl, PrnName)

    If ret < 0 Then
        PrnName = "Unable to fecth printer name"
    End If
    
    GetDefaultPrinterName = PrnName
End Function



Public Function GetDefaultPrinterDriver() As String

    Dim DrvName As String
    Dim ret As Long
    
    ' make sure that the buffer is large enough
    DrvName = String(200, 0)

    ' call API
    ret = dwGetDefaultPrinterDriver(hdl, DrvName)

    If ret < 0 Then
        DrvName = "Unable to fecth Driver name"
    End If
    
    GetDefaultPrinterDriver = DrvName


End Function

Public Function GetDefaultPrinterPort() As String

    Dim PortName As String
    Dim ret As Long
    
    ' make sure that the buffer is large enough
    PortName = String(200, 0)

    ' call API
    ret = dwGetDefaultPrinterPort(hdl, PortName)

    If ret < 0 Then
        PortName = "Unable to fecth Port name"
    End If
    
    GetDefaultPrinterPort = PortName
End Function

Public Function SetPrinterOrientation(iOrient As Integer)
    
    ' check value
    If ((iOrient = DMORIENT_PORTRAIT) Or (iOrient = DMORIENT_LANDSCAPE)) Then
        SetPrinterOrientation = dwSetPrinterOrientation(hdl, iOrient)
    Else
        SetPrinterOrientation = -2  ' bad param
    End If
    
End Function

Public Function GetPrinterOrientation(ByRef iOrient As Integer) As Long

    GetPrinterOrientation = dwGetPrinterOrientation(hdl, iOrient)
    
End Function

Public Function GetPrinterOrientationString(ByRef PrnOrient As String) As Long

    Dim iOrient As Integer
    Dim iRet As Long
    
    ' get it
    iRet = dwGetPrinterOrientation(hdl, iOrient)
    
    
    If iRet > 0 Then
        Select Case iOrient
        
            Case DMORIENT_PORTRAIT
                PrnOrient = "Portrait"
                
            Case DMORIENT_LANDSCAPE
                PrnOrient = "Landscape"
                
            Case Else
                PrnOrient = "Unknown Orientation"
                
        End Select
    Else
        PrnOrient = "Unknown Orientation"
    End If
    
    ' return error code
    GetPrinterOrientationString = iRet
    
End Function

Public Function GetPrinterList(ByRef PrnList As String) As Long

    PrnList = String(2000, 0)
    GetPrinterList = dwGetPrinterList(hdl, PrnList)
    
End Function

Public Function SetDefaultPrinter(DefaultPrinter As String) As Long
       
    Dim x As String
    Dim y As Long
    
    x = String(200, 0)
    
    x = DefaultPrinter
    
    y = dwSetDefaultPrinter(hdl, x)
    SetDefaultPrinter = y

End Function

Public Sub About()
    dwAbout
End Sub

Public Function UnlockDLL(RegUser As String, lKey As Long) As Long

    Dim ret As Long
    
    ret = dwUnlock(RegUser, lKey)
    
    If ret > 0 Then
        MsgBox ("Valid KEY. The registration reminder will not be shown when PowerPrinter gets unloaded.")
    End If
    
    UnlockDLL = ret
    
End Function

Public Function GetPaperBinList() As String

    Dim lsBinList As String
    Dim ret As Long
    
    lsBinList = String(500, 0)
    
    ret = dwGetPaperBinList(hdl, lsBinList)
    
    If ret < 0 Then
        lsBinList = "Could NOt Fetch Paper Bin List"
    End If
    
    GetPaperBinList = lsBinList
End Function

Public Function GetNamedPaperBinList() As String

    Dim lsBinList As String
    Dim ret As Long
    
    lsBinList = String(500, 0)
    
    ret = dwGetNamedPaperBinList(hdl, lsBinList)
    
    If ret < 0 Then
        lsBinList = "Could Not Fetch Named Paper Bin List"
    End If
    
    GetNamedPaperBinList = lsBinList

End Function

Public Function GetPaperSize(ByRef iSize As Integer) As Long
    
    GetPaperSize = dwGetPaperSize(hdl, iSize)
    
End Function

Public Function GetPaperSource(ByRef iSource As Integer) As Long

    GetPaperSource = dwGetDefaultSource(hdl, iSource)
    
End Function

Public Function SetDefaultSource(iSource As Integer)
    SetDefaultSource = dwSetDefaultSource(hdl, iSource)
End Function

Public Function GetPaperSizeList() As String
    
    Dim lsPaperSizeList As String
    Dim ret As Long
    
    lsPaperSizeList = String(3000, 0)
    
    ret = dwGetSupportedPaperSizeList(hdl, lsPaperSizeList)
    
    If ret < 0 Then
        lsPaperSizeList = "Could Not Fetch Paper Size List List"
    End If
    
    GetPaperSizeList = lsPaperSizeList

End Function

Public Function SetPaperSize(iSize As Integer)
       SetPaperSize = dwSetPaperSize(hdl, iSize)
End Function

Public Function EnumPrinterFonts(ByRef lsFonts As String) As Long

    Dim ret As Long
    
    lsFonts = String(1500, 0)
    
    ret = dwEnumPrinterFonts(hdl, lsFonts)
    
    If ret < 0 Then
        lsFonts = "Could NOT enumerate printer fonts !"
    End If
    
    EnumPrinterFonts = ret
End Function

Public Function SetPrinterFont(ByVal pDC As Long, ByVal szFontName As String, iPoint, iBold, iItalic, iUnderline, iStrike As Integer)

    SetPrinterFont = dwSetPrinterFont(hdl, pDC, szFontName, iPoint, iBold, iItalic, iUnderline, iStrike)
    
End Function

Public Function GetExtendedErrorCode() As Long

    GetExtendedErrorCode = dwGetExtendedErrorCode(hdl)
    
End Function



Public Function GetExtendedErrorMessage() As String
    Dim sMsg As String
    
    sMsg = String(500, 0)
    dwGetExtendedErrorMessage hdl, sMsg
    
    GetExtendedErrorMessage = sMsg
    
    
End Function

Public Function SetPrinterAccess(PrinterAccess As Long) As Long

    SetPrinterAccess = dwSetPrinterAccess(hdl, PrinterAccess)
    
End Function

Public Function GetPrinterAccess() As Long

    GetPrinterAccess = dwGetPrinterAccess(hdl)

End Function

Public Function AddPrinterConnection(ServerName, PrnShareName As String) As Long

    Screen.MousePointer = 11
    AddPrinterConnection = dwAddPrinterConnection(hdl, ServerName, PrnShareName)
    Screen.MousePointer = 0
    
End Function

Public Function DeletePrinterConnection(ServerName, PrnShareName As String) As Long
    Screen.MousePointer = 11
    DeletePrinterConnection = dwDeletePrinterConnection(hdl, ServerName, PrnShareName)
    Screen.MousePointer = 0
End Function

Public Function AddPrinter(ServerName, PrinterName, PortName, DriverName, PrintProcessor As String) As Long

    Screen.MousePointer = 11
    AddPrinter = dwAddPrinter(hdl, ServerName, PrinterName, PortName, DriverName, PrintProcessor)
    Screen.MousePointer = 0
    
End Function

Public Function DeletePrinter(PrinterName As String) As Long

    Screen.MousePointer = 11
    DeletePrinter = dwDeletePrinter(hdl, PrinterName)
    Screen.MousePointer = 0
    
End Function

Public Function AddPrinterDriver(ServerName As String, PrinterName As String, Environment As String, DriverPath As String, DataFile As String, ConfigFile As String, dVersion As Long) As Long

    AddPrinterDriver = dwAddPrinterDriver(hdl, ServerName, PrinterName, Environment, DriverPath, DataFile, ConfigFile, dVersion)

End Function

Public Function DeletePrinterDriver(ServerName As String, Environment As String, DriverName As String) As Long

    DeletePrinterDriver = dwDeletePrinterDriver(hdl, ServerName, Environment, DriverName)
    
End Function

Public Function GetPrinterDriver(PrinterName As String, ByRef DriverName As String, ByRef ServerName As String, ByRef Environment As String, ByRef DriverPath As String, ByRef DataFile As String, ByRef ConfigFile As String, ByRef dVersion As String) As Long

    Dim DriverInfo As DRIVER_INFO_2
    Dim lRet As Long
    
     DriverInfo.pName = String(100, 0)
     DriverInfo.pEnvironment = String(100, 0)
     DriverInfo.pDriverPath = String(100, 0)
     DriverInfo.pDataFile = String(100, 0)
     DriverInfo.pConfigFile = String(100, 0)
     
     ' make the call
     lRet = dwGetPrinterDriver(hdl, PrinterName, DriverInfo)
     
     If lRet > 0 Then
     
          DriverName = DriverInfo.pName
          dVersion = Str(DriverInfo.cVersion)
          Environment = DriverInfo.pEnvironment
          DriverPath = DriverInfo.pDriverPath
          DataFile = DriverInfo.pDataFile
          ConfigFile = DriverInfo.pConfigFile
     End If
 
    GetPrinterDriver = lRet
    
End Function

Public Function EnumPrinterJobs(PrinterName As String, ByRef lb As ListBox)

    Dim JobInfo(10) As JOB_INFO_1
    Dim lRet, MaxJobs As Long, Jobs As Long
    Dim i As Integer
    Dim s As String

    s = Space(200)  ' String(200, 0)
    MaxJobs = 10
     
    'initialize
     For i = 1 To MaxJobs
         JobInfo(i).pPrinterName = s
         JobInfo(i).pMachineName = s
         JobInfo(i).pUserName = s
         JobInfo(i).pDocument = s
         JobInfo(i).pDatatype = s
         JobInfo(i).pStatus = s
     Next
   
    lRet = dwEnumPrinterJobs(hdl, PrinterName, MaxJobs, JobInfo(1), Jobs)
    
    If lRet > 0 Then
        For i = 1 To Jobs
            lb.AddItem JobInfo(i).pPrinterName
        Next
    End If
    
    EnumPrinterJobs = lRet
    
End Function

Public Function CaptureDesktop() As Long
    Screen.MousePointer = 11
    CaptureDesktop = dwCaptureDesktop(hdl)
    Screen.MousePointer = 0
End Function

Public Function CaptureWindow(hWin As Long, iOPtion As Long) As Long

    ' Option = 1 entire window
    '          2 client area
    Screen.MousePointer = 11
    CaptureWindow = dwCaptureWindow(hdl, hWin, iOPtion)
    Screen.MousePointer = 0
    
End Function

Public Function PrintTheDIB(iPrintOption As Long, JobName As String) As Long

    Screen.MousePointer = 11
    PrintTheDIB = dwPrintTheDIB(hdl, iPrintOption, JobName)
    Screen.MousePointer = 0
    
End Function
