///////////////////////////////////////////////////////////////////////
//
//	GetLastError -- Retrieve the message text for a Windows error code.
//	Copyright 1998 Michael A. Quinlan

#include <windows.h>
#include <ctype.h>

inline bool GetLastError(char* pszBuf, int nBufLen, DWORD dwErr)
{
	DWORD dwLen = FormatMessage(
					FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
					NULL,
					dwErr,
					MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
					pszBuf,
					nBufLen,
					NULL);
	while (dwLen > 0 && isspace((unsigned char)pszBuf[dwLen - 1]))
		--dwLen;
	pszBuf[dwLen] = '\0';

	return dwLen > 0;
}

inline bool GetLastError(char* pszBuf, int nBufLen)
{
	return GetLastError(pszBuf, nBufLen, GetLastError());
}
