package org.phoenix.util;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;

/*
 *  colorTextPane
 *    a simple text area that allows different
 *    colored text to be added
 */

public class colorTextPane extends JTextPane {
	DefaultStyledDocument doc;
	Color current = Color.black;
	JScrollPane scroll;
	/* null constructor */
	public colorTextPane() {
		super();
		setEditable(false);
		doc = new DefaultStyledDocument();
		setDocument(doc);
	}
	/* set method for scroll area */
	public void setScrollPane(JScrollPane scroll) {
		this.scroll = scroll;
	}
	/* set current color */
	public void setColor(Color c) {
		current = c;
	}
	/* get current color */
	public Color getColor() {
		return current;
	}
	/* write text in the current color */
	public void writeText(String text) {
		writeText(text, current);
	}
	/* write text in the specified color */
	public void writeText(String text, Color c) {
		SimpleAttributeSet sas = new SimpleAttributeSet();
		StyleConstants.setForeground(sas, c);
		int t = doc.getLength();
		try {
			doc.insertString(t, text + "\n", sas);
		} catch (BadLocationException e) {
			System.err.println("Error inserting text into colorTextPane object");
		}
		if (scroll != null) {
			JScrollBar bar = scroll.getVerticalScrollBar();
			bar.setValue(bar.getMaximum());
		}
	}
	/* write text in the specified color */
	public void write(String text, Color c) {
		SimpleAttributeSet sas = new SimpleAttributeSet();
		StyleConstants.setForeground(sas, c);
		int t = doc.getLength();
		try {
			doc.insertString(t, text, sas);
		} catch (BadLocationException e) {
			System.err.println("Error inserting text into colorTextPane object");
		}
		if (scroll != null) {
			JScrollBar bar = scroll.getVerticalScrollBar();
			bar.setValue(bar.getMaximum());
		}
	}
}