/*
 * @(#)DumpFormServlet.java 1.0.0 10/11/98
 *
 * Copyright (c) 1997-1998 Servertec. All Rights Reserved.
 *
 * This software is the proprietary and confidential property of Servertec.
 * Use only in accordance with the terms of the license agreement.
 *
 * SERVERTEC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SERVERTEC SHALL NOT BE LIABLE FOR ANY
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.util.Enumeration;
import java.io.IOException;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletConfig;

import stec.lang.DString;

import stec.iws.Request;
import stec.iws.ServletContextImpl;
import stec.iws.Utils;

public class DumpFormServlet extends HttpServlet
{
    public void service(HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException
    {
        _response.setContentType("text/html");

        ServletOutputStream out = _response.getOutputStream();

        out.println("<html>");
        out.println("<head><title>Dump Form</title></head>");
        out.println("<body>");

        ArgsServlet.args(out, _request);
        dumpInitParams(out, _request);
        HeadersServlet.server_variables(out, _request);
        HeadersServlet.headers(out, _request);
        dumpFormData(out, _request);
        dumpCookies(out, _request);
        
        out.println("</body>");
        out.println("</html>");
        out.close();
    }
    
    protected void dumpInitParams(ServletOutputStream out, HttpServletRequest _request) throws IOException
    {
        out.println("<h1>Init Parameters:</h1>");
        
        String key;
        String values[];
        
        ServletContextImpl config = (ServletContextImpl)getServletConfig();
        
        Enumeration e = config.getInitParameterNames();
        while(e.hasMoreElements())
        {
            key = (String)e.nextElement();
            values = config.getInitParameterValues(key);
            for(int i = 0; i < values.length; i++)
            {
                out.println(key + "(" + i + ") = " + values[i] + "<br>");
            }
        }
    }
    
    protected static void dumpFormData(ServletOutputStream out, HttpServletRequest _request) throws IOException
    {
        out.println("<h1>Form Data:</h1>");
        
        out.println("method = " + _request.getMethod() + "<br>");
        out.println("content length = " + _request.getContentLength() + "<br>");

        String key;
        String values[];
        
        Enumeration e = _request.getParameterNames();
        while(e.hasMoreElements())
        {
            key = (String)e.nextElement();
            values = _request.getParameterValues(key);
            for(int i = 0; i < values.length; i++)
            {
                out.println(key + "(" + i + ") = " + values[i] + "<br>");
            }
        }
    }
    
    protected static void dumpCookies(ServletOutputStream out, HttpServletRequest _request) throws IOException
    {
        out.println("<h1>Cookies:</h1>");
        
        Cookie cookies[] = _request.getCookies();
        
        for(int i = 0; i < cookies.length; i++)
        {
            out.println(cookies[i].getName() + " = " + cookies[i].getValue() + "<br>");
        }
    }

    public String getServletInfo()
    {
        return "DumpFormServlet";
    }
}
