/*
 * Decompiled with CFR 0.152.
 */
package stec.sql;

import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import stec.sql.ConnectionPool;

public class Connection {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";
    private java.sql.Connection connection;
    private ConnectionPool pool;
    public static final int TRANSACTION_NONE = 0;
    public static final int TRANSACTION_READ_COMMITTED = 2;
    public static final int TRANSACTION_READ_UNCOMMITTED = 1;
    public static final int TRANSACTION_REPEATABLE_READ = 4;
    public static final int TRANSACTION_SERIALIZABLE = 8;

    protected Connection(ConnectionPool connectionPool, java.sql.Connection connection) {
        this.pool = connectionPool;
        this.connection = connection;
    }

    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    public synchronized void close() throws SQLException {
        if (this.pool.contains(this)) {
            throw new SQLException("Connection is already in pool.");
        }
        this.pool.putConnection(this);
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public Statement createStatement() throws SQLException {
        return this.connection.createStatement();
    }

    public void finalize() throws SQLException {
        if (this.connection != null) {
            this.close();
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    protected void kill() throws SQLException {
        try {
            this.connection.close();
        }
        catch (Exception exception) {}
        this.connection = null;
    }

    public String nativeSQL(String string) throws SQLException {
        return this.connection.nativeSQL(string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.connection.prepareCall(string);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.connection.prepareStatement(string);
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.connection.setAutoCommit(bl);
    }

    public void setCatalog(String string) throws SQLException {
        this.connection.setCatalog(string);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.connection.setReadOnly(bl);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.connection.setTransactionIsolation(n);
    }
}

