/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletException;
import stec.iws.AdminCPanel;
import stec.iws.AdminContext;
import stec.iws.AdminUtils;
import stec.iws.IOManager;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public class AdminSession {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";

    protected static void displaySession(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("session");
        Hashtable hashtable = AdminUtils.getSessionData(adminContext, adminContext.form);
        String string = adminContext.template;
        string = Utils.getItem(IOManager.getHandler(iws.basedir, string));
        string = DString.replace(string, "%error_message%", adminContext.error_message.toString());
        Object object = hashtable.get("timeout");
        if (object == null) {
            object = String.valueOf(30);
        }
        string = DString.replace(string, "%timeout%", (String)object);
        object = hashtable.get("interval");
        if (object == null) {
            object = String.valueOf(5);
        }
        string = DString.replace(string, "%interval%", (String)object);
        object = hashtable.get("source");
        if (object == null) {
            object = "cookie";
        }
        if (((String)object).equalsIgnoreCase("url")) {
            string = DString.replace(string, "%source_cookie%", "");
            string = DString.replace(string, "%source_url%", "CHECKED");
        } else {
            string = DString.replace(string, "%source_url%", "");
            string = DString.replace(string, "%source_cookie%", "CHECKED");
        }
        object = hashtable.get("name");
        if (object == null) {
            object = String.valueOf("iwsSessionID");
        }
        string = DString.replace(string, "%name%", (String)object);
        object = hashtable.get("comment");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%comment%", (String)object);
        object = hashtable.get("domain");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%domain%", (String)object);
        object = hashtable.get("path");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%path%", (String)object);
        object = hashtable.get("max_age");
        if (object == null) {
            object = String.valueOf(-1);
        }
        string = DString.replace(string, "%max_age%", (String)object);
        object = hashtable.get("secure");
        if (object == null) {
            object = "y";
        }
        if (((String)object).equalsIgnoreCase("y")) {
            string = DString.replace(string, "%secure_n%", "");
            string = DString.replace(string, "%secure_y%", "CHECKED");
        } else {
            string = DString.replace(string, "%secure_y%", "");
            string = DString.replace(string, "%secure_n%", "CHECKED");
        }
        AdminUtils.sendItem(adminContext.response, string);
    }

    protected static void doSession(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("session");
        adminContext.action = AdminUtils.getAction(adminContext);
        if (adminContext.action == null) {
            if (AdminSession.verifySession(adminContext)) {
                AdminUtils.updateAll(adminContext);
                AdminUtils.removeAll(adminContext.session);
                AdminCPanel.displayCPanel(adminContext);
                return;
            }
            AdminSession.displaySession(adminContext);
            return;
        }
        if (adminContext.action.equals("help")) {
            AdminUtils.help(adminContext, adminContext.form, "");
            return;
        }
        if (adminContext.action.equals("save")) {
            if (AdminSession.verifySession(adminContext)) {
                AdminUtils.updateAll(adminContext);
                AdminUtils.removeAll(adminContext.session);
                AdminCPanel.displayCPanel(adminContext);
                return;
            }
            AdminSession.displaySession(adminContext);
            return;
        }
        if (adminContext.action.equals("cancel")) {
            AdminUtils.removeAll(adminContext.session);
            AdminCPanel.displayCPanel(adminContext);
            return;
        }
        if (AdminSession.verifySession(adminContext) && AdminUtils.doToolbar(adminContext)) {
            return;
        }
        AdminSession.displaySession(adminContext);
    }

    protected static boolean verifySession(AdminContext adminContext) throws IOException, ServletException {
        String string;
        int n;
        Hashtable hashtable = AdminUtils.getSessionData(adminContext, adminContext.form);
        String string2 = adminContext.request.getParameter("timeout");
        if (string2 == null) {
            adminContext.error_message.append("Timeout is required.<br>");
        } else {
            try {
                n = Integer.parseInt(string2);
                if (n * 60000 < 1000 && n != -1) {
                    adminContext.error_message.append("Timeout is not valid.<br>");
                } else {
                    hashtable.put("timeout", string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                adminContext.error_message.append("Timeout requires a numeric value.<br>");
            }
        }
        string2 = adminContext.request.getParameter("interval");
        if (string2 == null) {
            adminContext.error_message.append("Interval is required.<br>");
        } else {
            try {
                n = Integer.parseInt(string2);
                if (n < 1 && n != -1) {
                    adminContext.error_message.append("Interval is not valid.<br>");
                } else {
                    hashtable.put("interval", string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                adminContext.error_message.append("Interval requires a numeric value.<br>");
            }
        }
        string2 = adminContext.request.getParameter("source");
        if (string2 == null) {
            adminContext.error_message.append("Source is required.<br>");
        } else {
            string = string2;
            if (string.equalsIgnoreCase("url") || string.equalsIgnoreCase("cookie")) {
                hashtable.put("source", string);
            } else {
                adminContext.error_message.append("Source is not valid.<br>");
            }
        }
        string2 = adminContext.request.getParameter("name");
        if (string2 == null) {
            adminContext.error_message.append("Name is required.<br>");
        } else {
            string = string2;
            if (string.length() == 0) {
                adminContext.error_message.append("Name is required.<br>");
            } else {
                hashtable.put("name", string2);
            }
        }
        string2 = adminContext.request.getParameter("comment");
        if (string2 != null) {
            hashtable.put("comment", string2);
        }
        if ((string2 = adminContext.request.getParameter("domain")) != null) {
            hashtable.put("domain", string2);
        }
        if ((string2 = adminContext.request.getParameter("path")) != null) {
            hashtable.put("path", string2);
        }
        if ((string2 = adminContext.request.getParameter("max_age")) == null) {
            adminContext.error_message.append("Maximum Age is required.<br>");
        } else {
            try {
                n = Integer.parseInt(string2);
                hashtable.put("max_age", string2);
            }
            catch (NumberFormatException numberFormatException) {
                adminContext.error_message.append("Maximum Age requires a numeric value.<br>");
            }
        }
        string2 = adminContext.request.getParameter("secure");
        if (string2 == null) {
            adminContext.error_message.append("Secure is required.<br>");
        } else {
            string = string2;
            if (string.equalsIgnoreCase("y")) {
                hashtable.put("secure", "y");
            } else if (string.equalsIgnoreCase("n")) {
                hashtable.put("secure", "n");
            } else {
                adminContext.error_message.append("Secure is not valid.<br>");
            }
        }
        AdminUtils.putSessionData(adminContext, adminContext.form, hashtable);
        return adminContext.error_message.length() <= 0;
    }
}

