/*
 * Decompiled with CFR 0.152.
 */
package bigbrother;

import bigbrother.ADMappings;
import bigbrother.TimeConverter;
import java.net.InetAddress;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;

class ADObject {
    SearchResult data;
    String dn;
    InetAddress ipaddress;
    String resolvedHost;
    String macaddress;
    String username;
    boolean domain;
    boolean valid;

    public ADObject(SearchResult searchResult, String string) {
        this.data = searchResult;
        this.dn = string;
        this.domain = false;
        this.valid = true;
        this.ipaddress = null;
        this.username = "";
        this.macaddress = "";
        String string2 = "" + (int)(Math.random() * 1000.0);
        this.resolvedHost = "";
    }

    public boolean isUser() {
        return this.isExtData("objectclass", "user") && !this.isComputer();
    }

    public boolean isComputer() {
        return this.isExtData("objectclass", "computer");
    }

    public boolean isFolder() {
        return this.isContainer() || this.isOrganizationalUnit() || this.isBuiltin();
    }

    public boolean isDomainController() {
        return this.isComputer() && this.dn.indexOf("ou=Domain Controllers") != -1;
    }

    public boolean isDomain() {
        return this.domain;
    }

    public boolean isGroup() {
        return this.isExtData("objectclass", "group");
    }

    public boolean isOrganizationalUnit() {
        return this.isExtData("objectclass", "organizationalUnit");
    }

    public boolean isContainer() {
        return this.isExtData("objectclass", "container");
    }

    public boolean isBuiltin() {
        return this.isExtData("objectclass", "builtin");
    }

    boolean isExtData(String string, String string2) {
        try {
            if (this.data.getAttributes().get(string) != null) {
                NamingEnumeration<?> namingEnumeration = this.data.getAttributes().get(string).getAll();
                while (namingEnumeration.hasMore()) {
                    if (((String)namingEnumeration.next()).indexOf(string2) == -1) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return false;
    }

    public boolean isChild(String string) {
        return this.dn.equals(string);
    }

    public void setAttributes(Attributes attributes) {
        this.data.setAttributes(attributes);
    }

    public Attributes getAttributes() {
        return this.data.getAttributes();
    }

    public String toString() {
        if (this.getValue("cn").length() != 0) {
            return this.getValue("cn");
        }
        return this.getValue("name");
    }

    public void setValue(String string, String string2) throws Exception {
        if (string.equals("resolvedhost")) {
            this.resolvedHost = string2;
        } else if (this.data.getAttributes().get(string) != null) {
            if (!this.data.getAttributes().get(string).contains(string2)) {
                this.data.getAttributes().get(string).set(0, string2);
            }
        } else {
            this.data.getAttributes().put(string, string2);
        }
    }

    public String getValue(String string) {
        if (string == "dn") {
            return this.getDn();
        }
        if (string == "parentdn") {
            return this.dn;
        }
        if (string == "ipaddress") {
            return this.getIP();
        }
        if (string == "macaddress") {
            return this.validate(this.macaddress);
        }
        if (string == "loggedonto") {
            return this.validate(this.resolvedHost);
        }
        if (string == "logonduration") {
            return this.calculateDuration(this.getValue("lastlogon"));
        }
        if (string == "loggeduser") {
            return this.validate(this.username);
        }
        if (string == "lastlogon") {
            try {
                if (this.data.getAttributes().get(string) != null) {
                    return new Long(TimeConverter.ADtoLong(this.data.getAttributes().get(string).getAll().next().toString())).toString();
                }
                return "";
            }
            catch (Exception exception) {
                return "";
            }
        }
        try {
            if (this.data.getAttributes().get(string) != null) {
                return this.data.getAttributes().get(string).getAll().next().toString();
            }
            if (string == "cn") {
                return this.getValue("ou");
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    String getDn() {
        if (this.isOrganizationalUnit()) {
            return "ou=" + this.getValue("ou") + ", " + this.dn;
        }
        if (this.isDomain()) {
            return this.dn;
        }
        return "cn=" + this.getValue("cn") + ", " + this.dn;
    }

    String getIP() {
        if (this.ipaddress != null) {
            String string = this.ipaddress.toString();
            int n2 = string.indexOf("/") + 1;
            String string2 = string.substring(0, n2 - 1);
            if (this.valid) {
                return string.substring(n2, string.length());
            }
            return "BAD IP ADDRESS";
        }
        return "";
    }

    String validate(String string) {
        if (this.valid) {
            return string;
        }
        return "";
    }

    String calculateDuration(String string) {
        if (this.getValue("loggedonto") != "" && !string.equals("0")) {
            try {
                return TimeConverter.longToString(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public void updateNetworkData() {
    }

    public boolean searchValue(String string) {
        String[] stringArray = ADMappings.getAllMappings();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (this.getValue(stringArray[n2]).toLowerCase().indexOf(string) != -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isDisabled() {
        return this.getValue("userAccountControl").equals("514");
    }

    public void getNetworkInfo() {
    }
}

