/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.controls.BooleanControl;
import com.sun.media.ui.AtomicComponent;
import com.sun.media.ui.BooleanComponent;
import java.awt.Graphics;
import java.awt.Image;

public class BiFloatButton
extends BooleanComponent {
    Image[] imageNormal = new Image[2];
    Image[] imageActive = new Image[2];
    Image[] imageDown = new Image[2];
    Image[] imageDisabled = new Image[2];

    public BiFloatButton(String imgNormal0, String imgActive0, String imgDown0, String imgDisabled0, String imgNormal1, String imgActive1, String imgDown1, String imgDisabled1, String tip) {
        super(tip);
        this.imageNormal[0] = AtomicComponent.fetchImage(imgNormal0);
        this.imageNormal[1] = AtomicComponent.fetchImage(imgNormal1);
        this.imageActive[0] = AtomicComponent.fetchImage(imgActive0);
        this.imageActive[1] = AtomicComponent.fetchImage(imgActive1);
        this.imageDown[0] = AtomicComponent.fetchImage(imgDown0);
        this.imageDown[1] = AtomicComponent.fetchImage(imgDown1);
        this.imageDisabled[0] = AtomicComponent.fetchImage(imgDisabled0);
        this.imageDisabled[1] = AtomicComponent.fetchImage(imgDisabled1);
        this.width = this.imageNormal[0].getWidth(this);
        this.height = this.imageNormal[0].getHeight(this);
        this.visualState = 1;
        this.setSize(this.width, this.height);
        this.setVisible(true);
    }

    public void mouseActivity() {
        if (this.isEnabled()) {
            if (this.mouseIn) {
                if (this.mouseDown) {
                    this.visualState = 4;
                    if (this.mouseUp) {
                        this.action();
                        this.visualState = 2;
                    }
                } else {
                    this.visualState = 2;
                }
            } else {
                this.visualState = 1;
            }
        } else {
            this.visualState = 8;
        }
        this.repaint();
    }

    public void action() {
        boolean bl = this.state = !this.state;
        if (this.control != null) {
            ((BooleanControl)this.control).setValue(this.state);
        }
    }

    public void paint(Graphics g2) {
        int index = this.state ? 1 : 0;
        Image image = null;
        switch (this.visualState) {
            case 1: {
                image = this.imageNormal[index];
                break;
            }
            case 2: {
                image = this.imageActive[index];
                break;
            }
            case 4: {
                image = this.imageDown[index];
                break;
            }
            case 8: {
                image = this.imageDisabled[index];
                break;
            }
        }
        if (image != null) {
            g2.drawImage(image, 0, 0, this);
        }
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.visualState = !value ? 8 : (this.mouseIn ? 2 : 1);
        this.repaint();
    }
}

