/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.protocol.rtp.DataSource;
import com.sun.media.rtp.BufferControlImpl;
import com.sun.media.rtp.RTPControlImpl;
import com.sun.media.rtp.RTPDemultiplexer;
import com.sun.media.rtp.RTPRawReceiver;
import com.sun.media.rtp.RTPSourceStream;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.SourceRTPPacket;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketFilter;
import com.sun.media.rtp.util.PacketSource;
import com.sun.media.rtp.util.RTPPacket;
import com.sun.media.rtp.util.Signed;
import com.sun.media.rtp.util.UDPPacket;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.media.Format;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.ActiveReceiveStreamEvent;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.RemotePayloadChangeEvent;

public class RTPReceiver
extends PacketFilter {
    SSRCCache cache;
    RTPDemultiplexer rtpdemultiplexer;
    int lastseqnum = -1;
    private boolean rtcpstarted = false;
    private boolean setpriority = false;
    private boolean mismatchprinted = false;
    private String content = "";
    static final int MAX_DROPOUT = 3000;
    static final int MAX_MISORDER = 100;
    static final int SEQ_MOD = 65536;
    static final int MIN_SEQUENTIAL = 2;
    private boolean initBC = false;
    public String controlstr = "javax.media.rtp.RTPControl";

    public String filtername() {
        return "RTP Packet Receiver";
    }

    public RTPReceiver(SSRCCache cache, RTPDemultiplexer rtpdemux) {
        this.cache = cache;
        this.rtpdemultiplexer = rtpdemux;
        this.setConsumer(null);
    }

    public RTPReceiver(SSRCCache cache, RTPDemultiplexer rtpdemux, PacketSource source) {
        this(cache, rtpdemux);
        this.setSource(source);
    }

    public RTPReceiver(SSRCCache cache, RTPDemultiplexer rtpdemux, DatagramSocket sock) {
        this(cache, rtpdemux, new RTPRawReceiver(sock, cache.sm.defaultstats));
    }

    public RTPReceiver(SSRCCache cache, RTPDemultiplexer rtpdemux, int port, String address) throws UnknownHostException, IOException {
        this(cache, rtpdemux, new RTPRawReceiver(port & 0xFFFFFFFE, address, cache.sm.defaultstats));
    }

    public Packet handlePacket(Packet p2) {
        return this.handlePacket((RTPPacket)p2);
    }

    public Packet handlePacket(Packet p2, int index) {
        return null;
    }

    public Packet handlePacket(Packet p2, SessionAddress a2, boolean b2) {
        return null;
    }

    public Packet handlePacket(RTPPacket p2) {
        RTPControlImpl control;
        SSRCInfo info = null;
        if (p2.base instanceof UDPPacket) {
            InetAddress remoteAddress = ((UDPPacket)p2.base).remoteAddress;
            if (this.cache.sm.bindtome && !this.cache.sm.isBroadcast(this.cache.sm.dataaddress) && !remoteAddress.equals(this.cache.sm.dataaddress)) {
                return null;
            }
        } else if (p2.base instanceof Packet) {
            p2.base.toString();
        }
        if (info == null) {
            info = p2.base instanceof UDPPacket ? this.cache.get(p2.ssrc, ((UDPPacket)p2.base).remoteAddress, ((UDPPacket)p2.base).remotePort, 1) : this.cache.get(p2.ssrc, null, 0, 1);
        }
        if (info == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < p2.csrc.length) {
            SSRCInfo cinfo = null;
            cinfo = p2.base instanceof UDPPacket ? this.cache.get(p2.csrc[i2], ((UDPPacket)p2.base).remoteAddress, ((UDPPacket)p2.base).remotePort, 1) : this.cache.get(p2.csrc[i2], null, 0, 1);
            if (cinfo != null) {
                cinfo.lastHeardFrom = p2.receiptTime;
            }
            ++i2;
        }
        if (info.lastPayloadType != -1 && info.lastPayloadType == p2.payloadType && this.mismatchprinted) {
            return null;
        }
        if (!info.sender) {
            info.initsource(p2.seqnum);
            info.payloadType = p2.payloadType;
        }
        int deltaseq = p2.seqnum - info.maxseq;
        if (info.maxseq + 1 != p2.seqnum && deltaseq > 0) {
            info.stats.update(0, deltaseq - 1);
        }
        if (info.wrapped) {
            info.wrapped = false;
        }
        if (info.probation > 0) {
            if (p2.seqnum == info.maxseq + 1) {
                --info.probation;
                info.maxseq = p2.seqnum;
            } else {
                info.probation = 1;
                info.maxseq = p2.seqnum;
                info.stats.update(2);
            }
        } else if (deltaseq < 3000) {
            if (p2.seqnum < info.baseseq) {
                info.cycles += 65536;
                info.wrapped = true;
            }
            info.maxseq = p2.seqnum;
        } else if (deltaseq <= 65436) {
            info.stats.update(3);
            if (p2.seqnum == info.lastbadseq) {
                info.initsource(p2.seqnum);
            } else {
                info.lastbadseq = p2.seqnum + 1 & 0xFFFF;
            }
        } else {
            info.stats.update(4);
        }
        boolean unicast = this.cache.sm.isUnicast();
        if (unicast) {
            if (!this.rtcpstarted) {
                this.cache.sm.startRTCPReports(((UDPPacket)p2.base).remoteAddress);
                this.rtcpstarted = true;
                byte[] lsb = this.cache.sm.controladdress.getAddress();
                int address = lsb[3] & 0xFF;
                if ((address & 0xFF) == 255) {
                    this.cache.sm.addUnicastAddr(this.cache.sm.controladdress);
                } else {
                    InetAddress localaddr = null;
                    boolean localfound = true;
                    try {
                        localaddr = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException unknownHostException) {
                        localfound = false;
                    }
                    if (localfound) {
                        this.cache.sm.addUnicastAddr(localaddr);
                    }
                }
            } else if (!this.cache.sm.isSenderDefaultAddr(((UDPPacket)p2.base).remoteAddress)) {
                this.cache.sm.addUnicastAddr(((UDPPacket)p2.base).remoteAddress);
            }
        }
        ++info.received;
        info.stats.update(1);
        if (info.probation > 0) {
            long ssrcu = 0L;
            ssrcu = info.ssrc < 0 ? Signed.UnsignedInt(info.ssrc) : (long)info.ssrc;
            return null;
        }
        info.maxseq = p2.seqnum;
        if (info.lastPayloadType != -1 && info.lastPayloadType != p2.payloadType) {
            info.currentformat = null;
            if (info.dsource != null && (control = (RTPControlImpl)info.dsource.getControl(this.controlstr)) != null) {
                control.currentformat = null;
                control.payload = -1;
            }
            info.lastPayloadType = p2.payloadType;
            if (info.dsource != null) {
                try {
                    info.dsource.stop();
                }
                catch (IOException e2) {
                    System.err.println("Stopping DataSource after PCE " + e2.getMessage());
                }
            }
            RemotePayloadChangeEvent event = new RemotePayloadChangeEvent(this.cache.sm, (ReceiveStream)((Object)info), info.lastPayloadType, p2.payloadType);
            this.cache.eventhandler.postEvent(event);
        }
        if (info.currentformat == null) {
            info.currentformat = this.cache.sm.formatinfo.get(p2.payloadType);
            if (info.currentformat == null) {
                System.err.println("No Format has been registered for payload type " + p2.payloadType);
                return p2;
            }
            if (info.dstream != null) {
                info.dstream.setFormat(info.currentformat);
            }
        }
        if (info.currentformat == null) {
            System.err.println("No Format for PT= " + p2.payloadType);
            return p2;
        }
        if (info.dsource != null && (control = (RTPControlImpl)info.dsource.getControl(this.controlstr)) != null) {
            Format fmt;
            control.currentformat = fmt = this.cache.sm.formatinfo.get(p2.payloadType);
        }
        if (!this.initBC) {
            ((BufferControlImpl)this.cache.sm.buffercontrol).initBufferControl(info.currentformat);
            this.initBC = true;
        }
        if (!info.streamconnect) {
            DataSource source = (DataSource)this.cache.sm.dslist.get(new Integer(info.ssrc));
            if (source == null) {
                DataSource defaultsource = this.cache.sm.getDataSource(null);
                if (defaultsource == null) {
                    source = this.cache.sm.createNewDS(null);
                    this.cache.sm.setDefaultDSassigned(info.ssrc);
                } else if (!this.cache.sm.isDefaultDSassigned()) {
                    source = defaultsource;
                    this.cache.sm.setDefaultDSassigned(info.ssrc);
                } else {
                    source = this.cache.sm.createNewDS(info.ssrc);
                }
            }
            PushBufferStream[] streams = source.getStreams();
            info.dsource = source;
            info.dstream = (RTPSourceStream)streams[0];
            info.dstream.setContentDescriptor(this.content);
            info.dstream.setFormat(info.currentformat);
            RTPControlImpl control2 = (RTPControlImpl)info.dsource.getControl(this.controlstr);
            if (control2 != null) {
                Format fmt;
                control2.currentformat = fmt = this.cache.sm.formatinfo.get(p2.payloadType);
                control2.stream = info;
            }
            info.streamconnect = true;
        }
        if (info.probation <= 0 && info.dsource != null) {
            info.active = true;
        }
        if (!info.newrecvstream) {
            NewReceiveStreamEvent evt = new NewReceiveStreamEvent(this.cache.sm, (ReceiveStream)((Object)info));
            info.newrecvstream = true;
            this.cache.eventhandler.postEvent(evt);
        }
        if (info.lastRTPReceiptTime != 0L && info.lastPayloadType == p2.payloadType) {
            long abstimediff = p2.receiptTime - info.lastRTPReceiptTime;
            long rtptimediff = p2.timestamp - info.lasttimestamp;
            double timediff = (abstimediff = abstimediff * (long)this.cache.clockrate[info.payloadType] / 1000L) - rtptimediff;
            if (timediff < 0.0) {
                timediff = -timediff;
            }
            info.jitter += 0.0625 * (timediff - info.jitter);
        }
        info.lastRTPReceiptTime = p2.receiptTime;
        info.lasttimestamp = p2.timestamp;
        info.payloadType = p2.payloadType;
        info.lastPayloadType = p2.payloadType;
        info.bytesreceived += p2.payloadlength;
        info.lastHeardFrom = p2.receiptTime;
        if (info.quiet) {
            info.quiet = false;
            ActiveReceiveStreamEvent event = null;
            event = info instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, info.sourceInfo, (ReceiveStream)((Object)info)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, info.sourceInfo, null);
            this.cache.eventhandler.postEvent(event);
        }
        SourceRTPPacket sp = new SourceRTPPacket(p2, info);
        if (info.dsource != null && info.probation <= 0 && info.dsource.isStarted()) {
            if (this.mismatchprinted) {
                this.mismatchprinted = false;
            }
            this.rtpdemultiplexer.demuxpayload(sp);
        }
        return p2;
    }
}

