/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.bean.multiplayer;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ImageLabel
extends Canvas {
    protected Image image;
    protected static String defaultImageString = null;
    private String imageString = "<Existing Image>";
    private boolean debug = false;
    protected int border;
    protected Color borderColor;
    protected int width = 80;
    protected int height = 60;
    protected boolean explicitSize = false;
    private int explicitWidth;
    private int explicitHeight;
    private MediaTracker tracker;
    private static int lastTrackerID;
    private int currentTrackerID;
    protected boolean doneLoading = false;
    private Container parentContainer;
    boolean newEventsOnly = false;

    public ImageLabel() {
    }

    public ImageLabel(String imageURLString) {
        this(ImageLabel.makeURL(imageURLString));
    }

    public ImageLabel(URL imageURL) {
        this(ImageLabel.loadImage(imageURL));
        this.imageString = imageURL.toExternalForm();
    }

    public ImageLabel(URL imageDirectory, String file) {
        this(ImageLabel.makeURL(imageDirectory, file));
        this.imageString = file;
    }

    public ImageLabel(Image image) {
        this.image = image;
        this.tracker = new MediaTracker(this);
        this.currentTrackerID = lastTrackerID++;
        this.tracker.addImage(image, this.currentTrackerID);
    }

    public void waitForImage(boolean doLayout) {
        if (!this.doneLoading) {
            this.debug("[waitForImage] - Resizing and waiting for " + this.imageString);
            try {
                this.tracker.waitForID(this.currentTrackerID);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e2) {
                System.out.println("Error loading " + this.imageString + ": " + e2.getMessage());
                e2.printStackTrace();
            }
            if (this.tracker.isErrorID(0)) {
                new Throwable("Error loading image " + this.imageString).printStackTrace();
            }
            this.doneLoading = true;
            this.width = this.explicitWidth != 0 ? this.explicitWidth : this.image.getWidth(this) + 2 * this.border;
            this.height = this.explicitHeight != 0 ? this.explicitHeight : this.image.getHeight(this) + 2 * this.border;
            this.resize(this.width, this.height);
            this.debug("[waitForImage] - " + this.imageString + " is " + this.width + "x" + this.height + ".");
            this.parentContainer = this.getParent();
            if (this.parentContainer != null && doLayout) {
                this.setBackground(this.parentContainer.getBackground());
                this.parentContainer.layout();
            }
        }
    }

    public void centerAt(int x, int y) {
        this.debug("Placing center of " + this.imageString + " at (" + x + "," + y + ")");
        this.move(x - this.width / 2, y - this.height / 2);
    }

    public synchronized boolean inside(int x, int y) {
        return x >= 0 && x <= this.width && y >= 0 && y <= this.height;
    }

    public void paint(Graphics g2) {
        if (!this.doneLoading) {
            this.waitForImage(true);
        } else {
            if (this.explicitSize) {
                g2.drawImage(this.image, this.border, this.border, this.width - 2 * this.border, this.height - 2 * this.border, this);
            } else {
                g2.drawImage(this.image, this.border, this.border, this);
            }
            this.drawRect(g2, 0, 0, this.width - 1, this.height - 1, this.border, this.borderColor);
        }
    }

    public Dimension preferredSize() {
        if (!this.doneLoading) {
            this.waitForImage(false);
        }
        return super.preferredSize();
    }

    public Dimension minimumSize() {
        if (!this.doneLoading) {
            this.waitForImage(false);
        }
        return super.minimumSize();
    }

    public void resize(int width, int height) {
        if (!this.doneLoading) {
            this.explicitSize = true;
            if (width > 0) {
                this.explicitWidth = width;
            }
            if (height > 0) {
                this.explicitHeight = height;
            }
        }
        super.resize(width, height);
    }

    public void reshape(int x, int y, int width, int height) {
        if (!this.doneLoading) {
            this.explicitSize = true;
            if (width > 0) {
                this.explicitWidth = width;
            }
            if (height > 0) {
                this.explicitHeight = height;
            }
        }
        super.reshape(x, y, width, height);
    }

    protected void drawRect(Graphics g2, int left, int top, int width, int height, int lineThickness, Color rectangleColor) {
        g2.setColor(rectangleColor);
        int i2 = 0;
        while (i2 < lineThickness) {
            g2.drawRect(left, top, width, height);
            if (i2 < lineThickness - 1) {
                ++left;
                ++top;
                width -= 2;
                height -= 2;
            }
            ++i2;
        }
    }

    protected void debug(String message) {
        if (this.debug) {
            System.out.println(message);
        }
    }

    private static URL makeURL(String s) {
        URL u = null;
        try {
            u = new URL(s);
        }
        catch (MalformedURLException mue) {
            System.out.println("Bad URL " + s + ": " + mue);
            mue.printStackTrace();
        }
        return u;
    }

    private static URL makeURL(URL directory, String file) {
        URL u = null;
        try {
            u = new URL(directory, file);
        }
        catch (MalformedURLException mue) {
            System.out.println("Bad URL " + directory.toExternalForm() + ", " + file + ": " + mue);
            mue.printStackTrace();
        }
        return u;
    }

    private static Image loadImage(URL url) {
        Image original = null;
        if (url.getProtocol().equals("file")) {
            try {
                InputStream imageStream = url.openStream();
                if (imageStream == null) {
                    System.out.println("null button image stream");
                    return null;
                }
                int available = 0;
                while (imageStream.available() == 0) {
                }
                available = imageStream.available();
                byte[] imageBytes = new byte[available];
                imageStream.read(imageBytes);
                original = Toolkit.getDefaultToolkit().createImage(imageBytes);
            }
            catch (IOException iOException) {
                System.out.println("Cannot read button image.");
                return null;
            }
        } else {
            original = Toolkit.getDefaultToolkit().getImage(url);
        }
        return original;
    }

    public Image getImage() {
        return this.image;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected boolean hasExplicitSize() {
        return this.explicitSize;
    }

    public static String getDefaultImageString() {
        return defaultImageString;
    }

    public static void setDefaultImageString(String file) {
        defaultImageString = file;
    }

    protected String getImageString() {
        return this.imageString;
    }

    public boolean isDebugging() {
        return this.debug;
    }

    public void setIsDebugging(boolean debug) {
        this.debug = debug;
    }
}

