/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;

public class PlayList
implements Cloneable {
    public static final int MAX_TRACKS = 25;
    private int TrackCounter;
    private int TotalTracks;
    public Vector TrackList = new Vector(25);
    public String HomeDir = "";
    public static final int SORT_FILE = 0;
    public static final int SORT_TRACK = 1;
    public static final int SORT_ARTISTE = 2;
    public static final int SORT_GENRE = 3;
    public static final int SORT_ASCENDING = -1;
    public static final int SORT_DESCENDING = 1;
    private File f;

    PlayList() {
    }

    PlayList(String string) {
        this.HomeDir = new File(string).getParent();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            this.loadPlayList(dataInputStream);
            return;
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.toString());
            return;
        }
    }

    PlayList(DataInputStream dataInputStream) {
        this.loadPlayList(dataInputStream);
    }

    public void addTrack(String string) {
        if (string.indexOf("http://") < 0 && !new File(string).exists()) {
            this.f = new File(this.HomeDir, string);
            if (this.f.exists()) {
                string = this.f.getAbsolutePath();
            }
        }
        PlayListStruc playListStruc = new PlayListStruc(string);
        this.TrackList.addElement(playListStruc);
        this.TrackCounter = this.TrackList.size() - 1;
    }

    public void setID3TrackInfo(ID3Tag iD3Tag) {
        PlayListStruc cfr_ignored_0 = (PlayListStruc)this.TrackList.elementAt(this.TrackCounter);
    }

    public ID3Tag getID3TrackInfo() {
        PlayListStruc playListStruc = (PlayListStruc)this.TrackList.elementAt(this.TrackCounter);
        if (playListStruc.TrackName.indexOf("http://") >= 0) {
            return null;
        }
        return playListStruc.ID3TagInfo;
    }

    public double getTrackDuration() {
        PlayListStruc playListStruc = (PlayListStruc)this.TrackList.elementAt(this.TrackCounter);
        return playListStruc.duration;
    }

    public boolean isTrackanUrl() {
        return this.CurrentTrack().indexOf("http://") >= 0;
    }

    public void setTrackBitrate(String string) {
        PlayListStruc playListStruc = (PlayListStruc)this.TrackList.elementAt(this.TrackCounter);
        playListStruc.bitrate = string;
    }

    public void setTrackGenre(String string) {
        PlayListStruc playListStruc = (PlayListStruc)this.TrackList.elementAt(this.TrackCounter);
        playListStruc.TrackGenre = string;
    }

    public String getTrackBitrate() {
        PlayListStruc playListStruc = (PlayListStruc)this.TrackList.elementAt(this.TrackCounter);
        return playListStruc.bitrate;
    }

    public String getTrackGenre() {
        PlayListStruc playListStruc = (PlayListStruc)this.TrackList.elementAt(this.TrackCounter);
        return playListStruc.TrackGenre;
    }

    public ID3Tag getID3TrackInfoAt(int n) {
        PlayListStruc playListStruc = (PlayListStruc)this.TrackList.elementAt(n);
        if (playListStruc.TrackName.indexOf("http://") >= 0) {
            return null;
        }
        return playListStruc.ID3TagInfo;
    }

    public void deleteTrack(int n) {
        this.TrackList.removeElementAt(n);
        this.TrackCounter = this.TrackList.size();
    }

    public boolean isURL() {
        return this.CurrentTrack().indexOf("http://") >= 0;
    }

    public boolean isURL(int n) {
        PlayListStruc playListStruc = (PlayListStruc)this.TrackList.elementAt(n);
        return playListStruc.TrackName.indexOf("http://") >= 0;
    }

    public void clearTracks() {
        this.TrackList.removeAllElements();
        this.TrackCounter = 0;
    }

    public void nextTrack() {
        ++this.TrackCounter;
    }

    public void previousTrack() {
        --this.TrackCounter;
    }

    public void startingTrack() {
        this.TrackCounter = 0;
    }

    public void endingTrack() {
        this.TrackCounter = this.TrackList.size();
    }

    public String CurrentTrack() {
        PlayListStruc playListStruc = (PlayListStruc)this.TrackList.elementAt(this.TrackCounter);
        return playListStruc.TrackName;
    }

    public String getTrackDescription() {
        PlayListStruc playListStruc = (PlayListStruc)this.TrackList.elementAt(this.TrackCounter);
        return playListStruc.TrackDescription;
    }

    public void setTrackDescription(String string) {
        PlayListStruc playListStruc = (PlayListStruc)this.TrackList.elementAt(this.TrackCounter);
        playListStruc.TrackDescription = string;
    }

    public int NumberOfTracks() {
        return this.TrackList.size();
    }

    public String RandomTrack() {
        this.TrackCounter = (int)((double)this.NumberOfTracks() * Math.random());
        return this.CurrentTrack();
    }

    public String SelectedTrack(int n) {
        if (n > this.NumberOfTracks()) {
            n = this.NumberOfTracks();
        } else if (n <= 0) {
            n = 0;
        }
        this.TrackCounter = n;
        return this.CurrentTrack();
    }

    public void sort(int n, int n2) {
        int n3 = this.TrackList.size();
        PlayListStruc playListStruc = null;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string = "";
        String string2 = "";
        while (!bl2) {
            bl2 = true;
            n4 = 0;
            while (n4 < n3 - 1) {
                PlayListStruc playListStruc2;
                block14: {
                    playListStruc2 = (PlayListStruc)this.TrackList.elementAt(n4);
                    playListStruc = (PlayListStruc)this.TrackList.elementAt(n4 + 1);
                    ID3Tag iD3Tag = this.getID3TrackInfoAt(n4);
                    ID3Tag iD3Tag2 = this.getID3TrackInfoAt(n4 + 1);
                    try {
                        switch (n) {
                            case 0: {
                                string = playListStruc2.TrackName;
                                string2 = playListStruc.TrackName;
                                break;
                            }
                            case 1: {
                                string = iD3Tag.Track_name;
                                string2 = iD3Tag2.Track_name;
                                break;
                            }
                            case 2: {
                                string = iD3Tag.Artist_name;
                                string2 = iD3Tag2.Artist_name;
                                break;
                            }
                            case 3: {
                                string = iD3Tag.Genre;
                                string2 = iD3Tag2.Genre;
                                break;
                            }
                            default: {
                                string = playListStruc2.TrackName;
                                string2 = playListStruc.TrackName;
                                break;
                            }
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        if (iD3Tag == null) {
                            string = "";
                        }
                        if (iD3Tag2 != null) break block14;
                        string2 = "";
                    }
                }
                string = string.trim();
                string2 = string2.trim();
                if (n2 == -1) {
                    bl = string.compareTo(string2) > 0;
                } else {
                    boolean bl3 = bl = string.compareTo(string2) < 0;
                }
                if (bl) {
                    this.TrackList.removeElementAt(n4);
                    this.TrackList.insertElementAt(playListStruc2, n4 + 1);
                    bl2 = false;
                }
                ++n4;
            }
        }
    }

    public void randomize() {
        int n = this.TrackList.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 = (int)((double)n * Math.random());
            PlayListStruc playListStruc = (PlayListStruc)this.TrackList.elementAt(n2);
            this.TrackList.removeElementAt(n2);
            this.TrackList.addElement(playListStruc);
            ++n3;
        }
    }

    public int moveCurrentTrack(int n) {
        int n2 = this.TrackCounter;
        PlayListStruc playListStruc = (PlayListStruc)this.TrackList.elementAt(n2);
        if (n >= this.TrackList.size() || n <= 0) {
            n = n < 0 ? this.TrackList.size() - 1 : 0;
            this.TrackList.removeElementAt(n2);
            this.TrackList.insertElementAt(playListStruc, n);
        } else {
            this.TrackList.removeElementAt(n2);
            this.TrackList.insertElementAt(playListStruc, n);
        }
        return n;
    }

    public void setID3HeaderInfo(ID3Tag iD3Tag) {
        PlayListStruc playListStruc = (PlayListStruc)this.TrackList.elementAt(this.TrackCounter);
        playListStruc.ID3TagInfo = iD3Tag;
    }

    public void savePlayList(DataOutputStream dataOutputStream) {
        int n = 0;
        int n2 = this.TrackCounter;
        try {
            dataOutputStream.flush();
            while (n < this.NumberOfTracks()) {
                String string = this.SelectedTrack(n);
                dataOutputStream.writeBytes(String.valueOf(string) + '\n');
                ++n;
            }
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.toString());
        }
        this.TrackCounter = n2;
    }

    public void loadPlayList(DataInputStream dataInputStream) {
        try {
            while (dataInputStream.available() > 0) {
                String string = dataInputStream.readLine();
                this.addTrack(string);
            }
            return;
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.toString());
            return;
        }
    }
}

