/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class BlockView
extends BoxView {
    private AttributeSet attr;
    private StyleSheet.BoxPainter painter;

    public BlockView(Element element, int n) {
        super(element, n);
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        this.painter = styleSheet.getBoxPainter(this.attr);
        this.setPropertiesFromAttributes();
    }

    void adjustSizeForCSS(int n, SizeRequirements sizeRequirements) {
        if (n == 0) {
            Object object = this.attr.getAttribute(CSS.Attribute.WIDTH);
            if (object != null) {
                int n2;
                sizeRequirements.minimum = sizeRequirements.preferred = (n2 = (int)((CSS.LengthValue)object).getValue());
                sizeRequirements.maximum = Math.max(sizeRequirements.maximum, n2);
            }
        } else {
            Object object = this.attr.getAttribute(CSS.Attribute.HEIGHT);
            if (object != null) {
                int n3;
                sizeRequirements.minimum = sizeRequirements.preferred = (n3 = (int)((CSS.LengthValue)object).getValue());
                sizeRequirements.maximum = Math.max(sizeRequirements.maximum, n3);
            }
        }
    }

    protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        SizeRequirements sizeRequirements2 = super.calculateMajorAxisRequirements(n, sizeRequirements);
        this.adjustSizeForCSS(n, sizeRequirements2);
        return sizeRequirements2;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        SizeRequirements sizeRequirements2 = super.calculateMinorAxisRequirements(n, sizeRequirements);
        this.adjustSizeForCSS(n, sizeRequirements2);
        return sizeRequirements2;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, viewFactory);
        int n = documentEvent.getOffset();
        if (n <= this.getStartOffset() && n + documentEvent.getLength() >= this.getEndOffset()) {
            this.setPropertiesFromAttributes();
        }
    }

    public float getAlignment(int n) {
        switch (n) {
            case 0: {
                return 0.0f;
            }
            case 1: {
                float f = this.getPreferredSpan(1);
                View view = this.getView(0);
                float f2 = view.getPreferredSpan(1);
                float f3 = (int)f != 0 ? f2 * view.getAlignment(1) / f : 0.0f;
                return f3;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public AttributeSet getAttributes() {
        return this.attr;
    }

    public int getResizeWeight(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = (Rectangle)shape;
        this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        super.paint(graphics, rectangle);
    }

    protected void setPropertiesFromAttributes() {
        this.attr = this.getStyleSheet().getViewAttributes(this);
        if (this.attr != null) {
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
        }
    }
}

