/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalButtonUI;
import javax.swing.plaf.metal.MetalUtils;

public class MetalToolBarUI
extends BasicToolBarUI {
    private static Border rolloverBorder = new CompoundBorder(new MetalBorders.RolloverButtonBorder(), new BasicBorders.MarginBorder());
    private static Border nonRolloverBorder = new CompoundBorder(new MetalBorders.ButtonBorder(), new BasicBorders.MarginBorder());
    protected ContainerListener contListener;
    protected PropertyChangeListener rolloverListener;
    private Hashtable borderTable = new Hashtable();
    private Hashtable marginTable = new Hashtable();
    private boolean rolloverBorders = false;
    private static String IS_ROLLOVER = "JToolBar.isRollover";
    private static final Insets insets0 = new Insets(0, 0, 0, 0);

    protected ContainerListener createContainerListener() {
        return new MetalContainerListener();
    }

    protected MouseInputListener createDockingListener() {
        return new MetalDockingListener(this.toolBar);
    }

    protected PropertyChangeListener createRolloverListener() {
        return new MetalRolloverListener();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalToolBarUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.contListener = this.createContainerListener();
        if (this.contListener != null) {
            this.toolBar.addContainerListener(this.contListener);
        }
        this.rolloverListener = this.createRolloverListener();
        if (this.rolloverListener != null) {
            this.toolBar.addPropertyChangeListener(this.rolloverListener);
        }
    }

    protected void installNonRolloverBorders(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JComponent) {
                ((JComponent)componentArray[n]).updateUI();
                this.setBorderToNonRollover(componentArray[n]);
            }
            ++n;
        }
    }

    protected void installNormalBorders(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            this.setBorderToNormal(componentArray[n]);
            ++n;
        }
    }

    protected void installRolloverBorders(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JComponent) {
                ((JComponent)componentArray[n]).updateUI();
                this.setBorderToRollover(componentArray[n]);
            }
            ++n;
        }
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        Object object = jComponent.getClientProperty(IS_ROLLOVER);
        this.rolloverBorders = object != null ? (Boolean)object : false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MetalToolBarUI.this.setRolloverBorders(MetalToolBarUI.this.isRolloverBorders());
            }
        });
    }

    public boolean isRolloverBorders() {
        return this.rolloverBorders;
    }

    protected void setBorderToNonRollover(Component component) {
        JButton jButton;
        if (component instanceof JButton && (jButton = (JButton)component).getUI() instanceof MetalButtonUI) {
            if (jButton.getBorder() instanceof UIResource) {
                this.borderTable.put(jButton, jButton.getBorder());
            }
            if (jButton.getBorder() instanceof UIResource || jButton.getBorder() == rolloverBorder) {
                jButton.setBorder(nonRolloverBorder);
            }
            if (jButton.getMargin() == null || jButton.getMargin() instanceof UIResource) {
                this.marginTable.put(jButton, jButton.getMargin());
                jButton.setMargin(insets0);
            }
            jButton.setRolloverEnabled(false);
        }
    }

    protected void setBorderToNormal(Component component) {
        JButton jButton;
        if (component instanceof JButton && (jButton = (JButton)component).getUI() instanceof MetalButtonUI) {
            if (jButton.getBorder() == rolloverBorder || jButton.getBorder() == nonRolloverBorder) {
                jButton.setBorder((Border)this.borderTable.remove(jButton));
            }
            if (jButton.getMargin() == insets0) {
                jButton.setMargin((Insets)this.marginTable.remove(jButton));
            }
            jButton.setRolloverEnabled(false);
        }
    }

    protected void setBorderToRollover(Component component) {
        JButton jButton;
        if (component instanceof JButton && (jButton = (JButton)component).getUI() instanceof MetalButtonUI) {
            if (jButton.getBorder() instanceof UIResource) {
                this.borderTable.put(jButton, jButton.getBorder());
            }
            if (jButton.getBorder() instanceof UIResource || jButton.getBorder() == nonRolloverBorder) {
                jButton.setBorder(rolloverBorder);
            }
            if (jButton.getMargin() == null || jButton.getMargin() instanceof UIResource) {
                this.marginTable.put(jButton, jButton.getMargin());
                jButton.setMargin(insets0);
            }
            jButton.setRolloverEnabled(true);
        }
    }

    protected void setDragOffset(Point point) {
        if (this.dragWindow == null) {
            this.dragWindow = this.createDragWindow(this.toolBar);
        }
        this.dragWindow.setOffset(point);
    }

    public void setRolloverBorders(boolean bl) {
        this.rolloverBorders = bl;
        if (this.rolloverBorders) {
            this.installRolloverBorders(this.toolBar);
        } else {
            this.installNonRolloverBorders(this.toolBar);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.contListener != null) {
            this.toolBar.removeContainerListener(this.contListener);
        }
        this.contListener = null;
        if (this.rolloverListener != null) {
            this.toolBar.removePropertyChangeListener(this.rolloverListener);
        }
        this.rolloverListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.installNormalBorders(jComponent);
    }

    protected class MetalContainerListener
    implements ContainerListener {
        protected MetalContainerListener() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (MetalToolBarUI.this.rolloverBorders) {
                MetalToolBarUI.this.setBorderToRollover(component);
            } else {
                MetalToolBarUI.this.setBorderToNonRollover(component);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            MetalToolBarUI.this.setBorderToNormal(component);
        }
    }

    protected class MetalRolloverListener
    implements PropertyChangeListener {
        protected MetalRolloverListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals(IS_ROLLOVER)) {
                if (propertyChangeEvent.getNewValue() != null) {
                    MetalToolBarUI.this.setRolloverBorders((Boolean)propertyChangeEvent.getNewValue());
                } else {
                    MetalToolBarUI.this.setRolloverBorders(false);
                }
            }
        }
    }

    protected class MetalDockingListener
    extends BasicToolBarUI.DockingListener {
        private boolean pressedInBumps = false;

        public MetalDockingListener(JToolBar jToolBar) {
            super(jToolBar);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.pressedInBumps) {
                super.mouseDragged(mouseEvent);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (!this.toolBar.isEnabled()) {
                return;
            }
            this.pressedInBumps = false;
            Rectangle rectangle = new Rectangle();
            if (this.toolBar.getSize().height <= this.toolBar.getSize().width) {
                if (MetalUtils.isLeftToRight(this.toolBar)) {
                    rectangle.setBounds(0, 0, 14, this.toolBar.getSize().height);
                } else {
                    rectangle.setBounds(this.toolBar.getSize().width - 14, 0, 14, this.toolBar.getSize().height);
                }
            } else {
                rectangle.setBounds(0, 0, this.toolBar.getSize().width, 14);
            }
            if (rectangle.contains(mouseEvent.getPoint())) {
                this.pressedInBumps = true;
                Point point = mouseEvent.getPoint();
                if (!MetalUtils.isLeftToRight(this.toolBar)) {
                    point.x -= this.toolBar.getSize().width - this.toolBar.getPreferredSize().width;
                }
                MetalToolBarUI.this.setDragOffset(point);
            }
        }
    }
}

