/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.StringReader;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

class BasicHTML {
    public static final String propertyKey = "html";
    private static HTMLEditorKit basicHTMLFactory;
    private static StyleSheet sharedStyles;
    private static final String styleChanges = "p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }";

    BasicHTML() {
    }

    public static View createHTMLView(JComponent jComponent, String string) {
        HTMLEditorKit hTMLEditorKit = BasicHTML.getFactory();
        Document document = hTMLEditorKit.createDefaultDocument();
        StringReader stringReader = new StringReader(string);
        try {
            hTMLEditorKit.read(stringReader, document, 0);
        }
        catch (Throwable throwable) {}
        ViewFactory viewFactory = hTMLEditorKit.getViewFactory();
        View view = viewFactory.create(document.getDefaultRootElement());
        Renderer renderer = new Renderer(jComponent, viewFactory, view);
        return renderer;
    }

    static HTMLEditorKit getFactory() {
        block2: {
            if (basicHTMLFactory != null) break block2;
            basicHTMLFactory = new BasicEditorKit();
            HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
            HTMLDocument hTMLDocument = (HTMLDocument)((EditorKit)hTMLEditorKit).createDefaultDocument();
            sharedStyles = hTMLDocument.getStyleSheet();
            try {
                StringReader stringReader = new StringReader(styleChanges);
                sharedStyles.loadRules(stringReader, null);
            }
            catch (Throwable throwable) {}
        }
        return basicHTMLFactory;
    }

    public static boolean isHTMLString(String string) {
        if (string != null) {
            return string.startsWith("<html>");
        }
        return false;
    }

    public static void updateRenderer(JComponent jComponent, String string) {
        View view = null;
        Object var3_3 = null;
        if (BasicHTML.isHTMLString(string)) {
            view = BasicHTML.createHTMLView(jComponent, string);
        }
        jComponent.putClientProperty(propertyKey, view);
    }

    static class BasicEditorKit
    extends HTMLEditorKit {
        BasicEditorKit() {
        }

        public Document createDefaultDocument() {
            BasicDocument basicDocument = new BasicDocument(sharedStyles);
            return basicDocument;
        }
    }

    static class BasicDocument
    extends HTMLDocument {
        BasicDocument(StyleSheet styleSheet) {
            super(styleSheet);
        }

        public HTMLEditorKit.ParserCallback getReader(int n) {
            BasicReader basicReader = new BasicReader(n);
            return basicReader;
        }

        class BasicReader
        extends HTMLDocument.HTMLReader {
            public BasicReader(int n) {
                super(BasicDocument.this, n);
                HTMLDocument.HTMLReader.TagAction tagAction = new HTMLDocument.HTMLReader.TagAction(this);
                this.registerTag(HTML.Tag.HEAD, tagAction);
            }
        }
    }

    static class Renderer
    extends View {
        private int width;
        private View view;
        private ViewFactory factory;
        private JComponent host;

        Renderer(JComponent jComponent, ViewFactory viewFactory, View view) {
            super(null);
            this.host = jComponent;
            this.factory = viewFactory;
            this.view = view;
            this.view.setParent(this);
            this.setSize(this.view.getPreferredSpan(0), this.view.getPreferredSpan(1));
        }

        public float getAlignment(int n) {
            return this.view.getAlignment(n);
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public Container getContainer() {
            return this.host;
        }

        public Document getDocument() {
            return this.view.getDocument();
        }

        public Element getElement() {
            return this.view.getElement();
        }

        public int getEndOffset() {
            return this.view.getEndOffset();
        }

        public float getMaximumSpan(int n) {
            return 2.1474836E9f;
        }

        public float getMinimumSpan(int n) {
            return this.view.getMinimumSpan(n);
        }

        public float getPreferredSpan(int n) {
            if (n == 0) {
                return this.width;
            }
            return this.view.getPreferredSpan(n);
        }

        public int getStartOffset() {
            return this.view.getStartOffset();
        }

        public View getView(int n) {
            return this.view;
        }

        public int getViewCount() {
            return 1;
        }

        public ViewFactory getViewFactory() {
            return this.factory;
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            return this.view.modelToView(n, shape, bias);
        }

        public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
            return this.view.modelToView(n, bias, n2, bias2, shape);
        }

        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = shape.getBounds();
            this.view.setSize(rectangle.width, rectangle.height);
            this.view.paint(graphics, shape);
        }

        public void preferenceChanged(View view, boolean bl, boolean bl2) {
            this.host.revalidate();
        }

        public void setParent(View view) {
            throw new Error("Can't set parent on root view");
        }

        public void setSize(float f, float f2) {
            this.width = (int)f;
            this.view.setSize(f, f2);
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            return this.view.viewToModel(f, f2, shape, biasArray);
        }
    }
}

