/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.OverallStats;
import com.sun.media.rtp.RTCPAPPPacket;
import com.sun.media.rtp.RTCPBYEPacket;
import com.sun.media.rtp.RTCPCompoundPacket;
import com.sun.media.rtp.RTCPPacket;
import com.sun.media.rtp.RTCPRRPacket;
import com.sun.media.rtp.RTCPReportBlock;
import com.sun.media.rtp.RTCPSDES;
import com.sun.media.rtp.RTCPSDESItem;
import com.sun.media.rtp.RTCPSDESPacket;
import com.sun.media.rtp.RTCPSRPacket;
import com.sun.media.rtp.util.BadFormatException;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketFilter;
import com.sun.media.rtp.util.RTPPacketReceiver;
import com.sun.media.rtp.util.UDPPacketReceiver;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.media.rtp.RTPPushDataSource;
import javax.media.rtp.SessionAddress;

public class RTCPRawReceiver
extends PacketFilter {
    private OverallStats stats;

    public String filtername() {
        return "RTCP Raw Packet Receiver";
    }

    public RTCPRawReceiver() {
    }

    public RTCPRawReceiver(DatagramSocket sock, OverallStats stats) {
        this.setSource(new UDPPacketReceiver(sock, 1000));
        this.stats = stats;
    }

    public RTCPRawReceiver(int remoteport, String remoteaddress, OverallStats stats) throws UnknownHostException, IOException, SocketException {
        this.setSource(new UDPPacketReceiver(remoteport | 1, remoteaddress, 1000));
        this.stats = stats;
    }

    public RTCPRawReceiver(RTPPushDataSource networkdatasource, OverallStats stats) {
        this.setSource(new RTPPacketReceiver(networkdatasource));
        this.stats = stats;
    }

    public Packet handlePacket(Packet p2, int i2) {
        return null;
    }

    public Packet handlePacket(Packet p2, SessionAddress a2, boolean control) {
        return null;
    }

    public Packet handlePacket(Packet p2) {
        RTCPPacket result;
        this.stats.update(0, 1);
        this.stats.update(11, 1);
        this.stats.update(1, p2.length);
        try {
            result = this.parse(p2);
        }
        catch (BadFormatException badFormatException) {
            this.stats.update(13, 1);
            return null;
        }
        return result;
    }

    public RTCPPacket parse(Packet packet) throws BadFormatException {
        RTCPCompoundPacket base = new RTCPCompoundPacket(packet);
        Vector<RTCPSDESPacket> subpackets = new Vector<RTCPSDESPacket>(2);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(base.data, base.offset, base.length));
        try {
            int offset = 0;
            while (offset < base.length) {
                RTCPPacket p2;
                int firstbyte = in.readUnsignedByte();
                if ((firstbyte & 0xC0) != 128) {
                    throw new BadFormatException();
                }
                int type = in.readUnsignedByte();
                int length = in.readUnsignedShort();
                length = length + 1 << 2;
                int padlen = 0;
                if (offset + length > base.length) {
                    throw new BadFormatException();
                }
                if (offset + length == base.length ? (firstbyte & 0x20) != 0 && (padlen = base.data[base.offset + base.length - 1] & 0xFF) == 0 : (firstbyte & 0x20) != 0) {
                    throw new BadFormatException();
                }
                int inlength = length - padlen;
                firstbyte &= 0x1F;
                switch (type) {
                    case 200: {
                        this.stats.update(12, 1);
                        if (inlength != 28 + 24 * firstbyte) {
                            this.stats.update(18, 1);
                            throw new BadFormatException();
                        }
                        RTCPSRPacket srp = new RTCPSRPacket(base);
                        p2 = srp;
                        srp.ssrc = in.readInt();
                        srp.ntptimestampmsw = (long)in.readInt() & 0xFFFFFFFFL;
                        srp.ntptimestamplsw = (long)in.readInt() & 0xFFFFFFFFL;
                        srp.rtptimestamp = (long)in.readInt() & 0xFFFFFFFFL;
                        srp.packetcount = (long)in.readInt() & 0xFFFFFFFFL;
                        srp.octetcount = (long)in.readInt() & 0xFFFFFFFFL;
                        srp.reports = new RTCPReportBlock[firstbyte];
                        int i2 = 0;
                        while (i2 < srp.reports.length) {
                            RTCPReportBlock report;
                            srp.reports[i2] = report = new RTCPReportBlock();
                            report.ssrc = in.readInt();
                            report.packetslost = in.readInt();
                            report.fractionlost = report.packetslost >> 24 & 0xFF;
                            report.packetslost &= 0xFFFFFF;
                            report.lastseq = (long)in.readInt() & 0xFFFFFFFFL;
                            report.jitter = in.readInt();
                            report.lsr = (long)in.readInt() & 0xFFFFFFFFL;
                            report.dlsr = (long)in.readInt() & 0xFFFFFFFFL;
                            ++i2;
                        }
                        break;
                    }
                    case 201: {
                        if (inlength != 8 + 24 * firstbyte) {
                            this.stats.update(15, 1);
                            throw new BadFormatException();
                        }
                        RTCPRRPacket rrp = new RTCPRRPacket(base);
                        p2 = rrp;
                        rrp.ssrc = in.readInt();
                        rrp.reports = new RTCPReportBlock[firstbyte];
                        int i3 = 0;
                        while (i3 < rrp.reports.length) {
                            RTCPReportBlock report;
                            rrp.reports[i3] = report = new RTCPReportBlock();
                            report.ssrc = in.readInt();
                            report.packetslost = in.readInt();
                            report.fractionlost = report.packetslost >> 24 & 0xFF;
                            report.packetslost &= 0xFFFFFF;
                            report.lastseq = (long)in.readInt() & 0xFFFFFFFFL;
                            report.jitter = in.readInt();
                            report.lsr = (long)in.readInt() & 0xFFFFFFFFL;
                            report.dlsr = (long)in.readInt() & 0xFFFFFFFFL;
                            ++i3;
                        }
                        break;
                    }
                    case 202: {
                        RTCPSDESPacket sdesp;
                        p2 = sdesp = new RTCPSDESPacket(base);
                        sdesp.sdes = new RTCPSDES[firstbyte];
                        int sdesoff = 4;
                        int i4 = 0;
                        while (i4 < sdesp.sdes.length) {
                            int sdestype;
                            RTCPSDES chunk;
                            sdesp.sdes[i4] = chunk = new RTCPSDES();
                            chunk.ssrc = in.readInt();
                            sdesoff += 5;
                            Vector<RTCPSDESItem> items = new Vector<RTCPSDESItem>();
                            boolean gotcname = false;
                            while ((sdestype = in.readUnsignedByte()) != 0) {
                                if (sdestype < 1 || sdestype > 8) {
                                    this.stats.update(16, 1);
                                    throw new BadFormatException();
                                }
                                if (sdestype == 1) {
                                    gotcname = true;
                                }
                                RTCPSDESItem item = new RTCPSDESItem();
                                items.addElement(item);
                                item.type = sdestype;
                                int sdeslen = in.readUnsignedByte();
                                item.data = new byte[sdeslen];
                                in.readFully(item.data);
                                sdesoff += 2 + sdeslen;
                            }
                            if (!gotcname) {
                                this.stats.update(16, 1);
                                throw new BadFormatException();
                            }
                            chunk.items = new RTCPSDESItem[items.size()];
                            items.copyInto(chunk.items);
                            if ((sdesoff & 3) != 0) {
                                in.skip(4 - (sdesoff & 3));
                                sdesoff = sdesoff + 3 & 0xFFFFFFFC;
                            }
                            ++i4;
                        }
                        if (inlength == sdesoff) break;
                        this.stats.update(16, 1);
                        throw new BadFormatException();
                    }
                    case 203: {
                        int reasonlen;
                        RTCPBYEPacket byep = new RTCPBYEPacket(base);
                        p2 = byep;
                        byep.ssrc = new int[firstbyte];
                        int i5 = 0;
                        while (i5 < byep.ssrc.length) {
                            byep.ssrc[i5] = in.readInt();
                            ++i5;
                        }
                        if (inlength > 4 + 4 * firstbyte) {
                            reasonlen = in.readUnsignedByte();
                            byep.reason = new byte[reasonlen];
                            ++reasonlen;
                        } else {
                            reasonlen = 0;
                            byep.reason = new byte[0];
                        }
                        reasonlen = reasonlen + 3 & 0xFFFFFFFC;
                        if (inlength != 4 + 4 * firstbyte + reasonlen) {
                            this.stats.update(17, 1);
                            throw new BadFormatException();
                        }
                        in.readFully(byep.reason);
                        in.skip(reasonlen - byep.reason.length);
                        break;
                    }
                    case 204: {
                        if (inlength < 12) {
                            throw new BadFormatException();
                        }
                        RTCPAPPPacket appp = new RTCPAPPPacket(base);
                        p2 = appp;
                        appp.ssrc = in.readInt();
                        appp.name = in.readInt();
                        appp.subtype = firstbyte;
                        appp.data = new byte[inlength - 12];
                        in.readFully(appp.data);
                        in.skip(inlength - 12 - appp.data.length);
                        break;
                    }
                    default: {
                        this.stats.update(14, 1);
                        throw new BadFormatException();
                    }
                }
                p2.offset = offset;
                p2.length = length;
                subpackets.addElement((RTCPSDESPacket)p2);
                in.skipBytes(padlen);
                offset += length;
            }
        }
        catch (EOFException eOFException) {
            throw new BadFormatException("Unexpected end of RTCP packet");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Impossible Exception");
        }
        base.packets = new RTCPPacket[subpackets.size()];
        subpackets.copyInto(base.packets);
        return base;
    }
}

