/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.video.h263;

import com.ibm.media.codec.video.VideoCodec;
import com.ibm.media.codec.video.h263.BitRateAdapter;
import com.ibm.media.codec.video.h263.FrameProcessingAdapter;
import com.ibm.media.codec.video.h263.FrameRateAdapter;
import com.ibm.media.codec.video.h263.KeyFrameAdapter;
import com.ibm.media.codec.video.h263.PacketSizeAdapter;
import com.ibm.media.codec.video.h263.QualityAdapter;
import com.sun.media.controls.H263Adapter;
import com.sun.media.controls.VFlowLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class NativeEncoder
extends VideoCodec {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997, 1999.";
    static final int[] widths;
    static final int[] heights;
    private int videoWidth = 176;
    private int videoHeight = 144;
    int nativeFormat;
    static final int DEFAULT_RTP_MTU = 576;
    static final int DEFAULT_MAX_OUTPUT_LENGTH = 40960;
    public int maxOutputLength;
    long timeStamp;
    long sequenceNumber;
    long deltaFrames = 33366L;
    boolean useRtp = false;
    Control[] controls;
    float sourceFrameRate;
    float targetFrameRate;
    int minBitRate = 5000;
    int maxBitRate = 1000000;
    int useBitRate = 20000;
    int iFramePeriod = 15;
    int frameDecimation = 1;
    int frame2skip;
    boolean initCompleted = false;
    private Frame controlFrame;
    public int nativeData;
    int prevTr;
    int tr;
    public boolean frameDone = true;
    int outputLength;

    private native boolean initNativeEncoder(int var1, int var2, float var3, float var4, int var5, int var6);

    private native boolean setFramesBehind(int var1);

    private native boolean setQuality(float var1);

    private native boolean encodeFrameNative(Buffer var1, Buffer var2);

    private native boolean closeNativeEncoder();

    public NativeEncoder() {
        this.supportedInputFormats = new VideoFormat[]{new YUVFormat(2)};
        this.defaultOutputFormats = new VideoFormat[]{new VideoFormat("h263"), new VideoFormat("h263/rtp")};
        this.PLUGIN_NAME = "H.263 Encoder";
    }

    public Format setInputFormat(Format format) {
        VideoFormat ivf = (VideoFormat)super.setInputFormat(format);
        if (ivf == null) {
            return null;
        }
        Dimension inSize = ivf.getSize();
        if (inSize == null) {
            return null;
        }
        this.videoWidth = inSize.width;
        this.videoHeight = inSize.height;
        if (this.videoWidth == 128 && this.videoHeight == 96) {
            this.nativeFormat = 0;
        } else if (this.videoWidth == 176 && this.videoHeight == 144) {
            this.nativeFormat = 1;
        } else if (this.videoWidth == 352 && this.videoHeight == 288) {
            this.nativeFormat = 2;
        } else {
            return null;
        }
        this.sourceFrameRate = ivf.getFrameRate();
        this.deltaFrames = (long)(1000000.0 / (double)ivf.getFrameRate());
        return format;
    }

    public Format setOutputFormat(Format format) {
        VideoFormat f2 = (VideoFormat)super.setOutputFormat(format);
        if (f2.getMaxDataLength() == -1) {
            if (f2.getEncoding().equals("h263/rtp")) {
                this.useRtp = true;
                this.maxOutputLength = 576;
            } else {
                this.useRtp = false;
                this.maxOutputLength = 40960;
            }
            f2 = new VideoFormat(f2.getEncoding(), f2.getSize(), this.maxOutputLength, Format.byteArray, f2.getFrameRate());
            this.targetFrameRate = f2.getFrameRate();
            this.frameDecimation = (int)(this.sourceFrameRate / this.targetFrameRate);
            f2 = (VideoFormat)super.setOutputFormat(f2);
        }
        return f2;
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        VideoFormat ivf = (VideoFormat)in;
        Dimension inSize = ivf.getSize();
        if (inSize == null) {
            return null;
        }
        this.videoWidth = inSize.width;
        this.videoHeight = inSize.height;
        this.supportedOutputFormats = new VideoFormat[2];
        int i2 = 0;
        while (i2 < 2) {
            float useFrameRate = ivf.getFrameRate();
            if (i2 == 2) {
                useFrameRate /= 2.0f;
            }
            if (i2 == 4) {
                useFrameRate /= 3.0f;
            }
            this.supportedOutputFormats[i2++] = new VideoFormat("h263", new Dimension(inSize), -1, Format.byteArray, useFrameRate);
            this.supportedOutputFormats[i2++] = new VideoFormat("h263/rtp", new Dimension(inSize), -1, Format.byteArray, useFrameRate);
        }
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
        try {
            System.loadLibrary("jmh263enc");
            this.initFrame();
            return;
        }
        catch (Throwable e2) {
            System.out.println(e2);
            throw new ResourceUnavailableException("could not load jmvh263");
        }
    }

    public synchronized void close() {
        if (this.controlFrame != null) {
            this.controlFrame.dispose();
            this.controlFrame = null;
        }
        this.closeNativeEncoder();
    }

    public synchronized void closeNative() {
        this.closeNativeEncoder();
    }

    public synchronized void reset() {
        this.initEncoder();
    }

    protected void videoResized() {
        this.initEncoder();
    }

    protected void initEncoder() {
        if (this.maxOutputLength != this.outputFormat.getMaxDataLength()) {
            VideoFormat f2 = this.outputFormat;
            this.outputFormat = new VideoFormat(f2.getEncoding(), f2.getSize(), this.maxOutputLength, Format.byteArray, f2.getFrameRate());
        }
        this.closeNative();
        if (this.useRtp) {
            this.initNativeEncoder(this.nativeFormat, this.maxOutputLength, this.sourceFrameRate, this.targetFrameRate, this.useBitRate, this.iFramePeriod);
        } else {
            this.initNativeEncoder(this.nativeFormat, 0, this.sourceFrameRate, this.targetFrameRate, this.useBitRate, this.iFramePeriod);
        }
    }

    public synchronized int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.initCompleted) {
            this.initCompleted = true;
            this.initEncoder();
        }
        if (this.frameDone) {
            ++this.frame2skip;
            if (this.frame2skip != this.frameDecimation) {
                this.updateOutput(outputBuffer, this.outputFormat, 0, 0);
                return 4;
            }
            this.frame2skip = 0;
            if (!this.checkInputBuffer(inputBuffer)) {
                return 1;
            }
            if (this.isEOM(inputBuffer)) {
                this.propagateEOM(outputBuffer);
                return 0;
            }
        }
        VideoFormat ivf = (VideoFormat)inputBuffer.getFormat();
        int inLength = inputBuffer.getLength();
        int inMaxLength = ivf.getMaxDataLength();
        int outMaxLength = this.outputFormat.getMaxDataLength();
        int inputOffset = inputBuffer.getOffset();
        byte[] inData = (byte[])inputBuffer.getData();
        byte[] outData = this.validateByteArraySize(outputBuffer, outMaxLength);
        outputBuffer.setTimeStamp(0L);
        boolean ret = this.encodeFrameNative(inputBuffer, outputBuffer);
        if (this.outputLength >= 0) {
            outputBuffer.setLength(this.outputLength);
        }
        if (this.useRtp) {
            outputBuffer.setSequenceNumber(this.sequenceNumber);
            ++this.sequenceNumber;
            if (this.frameDone) {
                this.timeStamp = inputBuffer.getTimeStamp();
                this.prevTr = this.tr;
                int flags = outputBuffer.getFlags();
                outputBuffer.setFlags(flags |= 0x400);
            }
            outputBuffer.setTimeStamp(this.timeStamp);
        }
        this.updateOutput(outputBuffer, this.outputFormat, outputBuffer.getLength(), 0);
        if (this.frameDone) {
            if (this.outputLength != -1) {
                return 0;
            }
            return 4;
        }
        if (this.outputLength == -1) {
            return 6;
        }
        return 2;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[7];
            this.controls[0] = new H263Adapter(this, false, false, false, false, false, 0, 1000, false);
            this.controls[1] = new BitRateAdapter(this, this.useBitRate, this.minBitRate, this.maxBitRate, true);
            this.controls[2] = new KeyFrameAdapter(this, this.iFramePeriod, true);
            this.controls[3] = new QualityAdapter(this, 1.0f, 0.0f, 1.0f, false, true);
            this.controls[4] = new FrameRateAdapter(this, this.targetFrameRate, this.sourceFrameRate / 3.0f, this.sourceFrameRate, true);
            this.controls[5] = new FrameProcessingAdapter(this);
            this.controls[6] = new PacketSizeAdapter(this, this.maxOutputLength, true);
        }
        return this.controls;
    }

    public void initFrame() {
        this.controlFrame = new Frame(String.valueOf(this.getName()) + "  Control");
        this.controlFrame.setLayout(new VFlowLayout(1));
        this.controlFrame.add(new Label(String.valueOf(this.getName()) + "  Control", 1));
        this.controlFrame.add(new Label(" "));
        Control[] c2 = (Control[])this.getControls();
        int i2 = 0;
        while (i2 < c2.length) {
            this.controlFrame.add(c2[i2].getControlComponent());
            ++i2;
        }
        this.controlFrame.pack();
        this.controlFrame.show();
        this.controlFrame.addWindowListener(new 1());
    }

    static {
        int[] nArray = new int[8];
        nArray[1] = 128;
        nArray[2] = 176;
        nArray[3] = 352;
        nArray[4] = 704;
        nArray[5] = 1408;
        widths = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 96;
        nArray2[2] = 144;
        nArray2[3] = 288;
        nArray2[4] = 576;
        nArray2[5] = 1152;
        heights = nArray2;
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent we) {
            NativeEncoder.this.controlFrame.dispose();
        }

        /* synthetic */ 1() {
        }
    }
}

