/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.ID3IllegalFormatException;
import de.vdheide.mp3.NoID3TagException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class ID3
implements Serializable {
    public static final String ISO_8859_1 = "iso-8859-1";
    protected String encoding = "iso-8859-1";
    private File mp3_file = null;
    private String title = null;
    private String artist = null;
    private String album = null;
    private String year = null;
    private Byte genre = null;
    private String comment = null;
    private Byte track = null;

    public ID3(File file) {
        this(file, null);
    }

    public ID3(File file, String string) {
        this.mp3_file = file;
        if (string != null) {
            this.encoding = string;
        }
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getTitle() throws NoID3TagException {
        try {
            this.checkIfRead(this.title);
        }
        catch (IOException iOException) {
            throw new NoID3TagException();
        }
        return this.title;
    }

    public String getArtist() throws NoID3TagException {
        try {
            this.checkIfRead(this.artist);
        }
        catch (IOException iOException) {
            throw new NoID3TagException();
        }
        return this.artist;
    }

    public String getAlbum() throws NoID3TagException {
        try {
            this.checkIfRead(this.album);
        }
        catch (IOException iOException) {
            throw new NoID3TagException();
        }
        return this.album;
    }

    public String getYear() throws NoID3TagException {
        try {
            this.checkIfRead(this.year);
        }
        catch (IOException iOException) {
            throw new NoID3TagException();
        }
        return this.year;
    }

    public int getGenre() throws NoID3TagException {
        if (this.genre == null) {
            try {
                this.readTag();
            }
            catch (IOException iOException) {
                throw new NoID3TagException();
            }
        }
        return this.genre.byteValue();
    }

    public String getComment() throws NoID3TagException {
        try {
            this.checkIfRead(this.comment);
            return this.comment;
        }
        catch (IOException iOException) {
            throw new NoID3TagException();
        }
    }

    public int getTrack() throws NoID3TagException {
        if (this.track == null) {
            try {
                this.readTag();
            }
            catch (IOException iOException) {
                throw new NoID3TagException();
            }
        }
        return this.track.byteValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readTag() throws NoID3TagException, IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.mp3_file, "r");
        try {
            if (!this.checkForTag()) {
                throw new NoID3TagException();
            }
            randomAccessFile.seek(randomAccessFile.length() - 125L);
            byte[] byArray = new byte[125];
            if (randomAccessFile.read(byArray, 0, 125) != 125) {
                // empty if block
            }
            String string = new String(byArray, 0, 125, this.encoding);
            this.title = string.substring(0, 30).trim();
            this.artist = string.substring(30, 60).trim();
            this.album = string.substring(60, 90).trim();
            this.year = string.substring(90, 94).trim();
            this.comment = string.substring(94, 123).trim();
            this.track = new Byte((byte)string.charAt(123));
            this.genre = new Byte((byte)string.charAt(124));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            randomAccessFile.close();
            throw throwable;
        }
        randomAccessFile.close();
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setArtist(String string) {
        this.artist = string;
    }

    public void setAlbum(String string) {
        this.album = string;
    }

    public void setYear(String string) {
        this.year = string;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setTrack(int n) throws ID3IllegalFormatException {
        if (n < 0 || n > 255) {
            throw new ID3IllegalFormatException();
        }
        this.track = new Byte((byte)n);
    }

    public void setGenre(int n) throws ID3IllegalFormatException {
        this.genre = new Byte((byte)n);
    }

    public void writeTag() throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.mp3_file, "rw");
        if (!this.checkForTag()) {
            randomAccessFile.seek(randomAccessFile.length());
        } else {
            randomAccessFile.seek(randomAccessFile.length() - 128L);
        }
        randomAccessFile.write(new String("TAG").getBytes(this.encoding));
        randomAccessFile.write(this.fillWithNills(this.title, 30).getBytes(this.encoding));
        randomAccessFile.write(this.fillWithNills(this.artist, 30).getBytes(this.encoding));
        randomAccessFile.write(this.fillWithNills(this.album, 30).getBytes(this.encoding));
        randomAccessFile.write(this.fillWithNills(this.year, 4).getBytes(this.encoding));
        randomAccessFile.write(this.fillWithNills(this.comment, 29).getBytes(this.encoding));
        if (this.track == null) {
            randomAccessFile.writeByte(0);
        } else {
            randomAccessFile.writeByte(this.track.byteValue());
        }
        if (this.genre == null) {
            randomAccessFile.writeByte(0);
        } else {
            randomAccessFile.writeByte(this.genre.byteValue());
        }
        randomAccessFile.close();
    }

    private void checkIfRead(String string) throws NoID3TagException, IOException {
        if (string == null) {
            this.readTag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForTag() throws IOException {
        RandomAccessFile randomAccessFile;
        block6: {
            block5: {
                boolean bl;
                randomAccessFile = new RandomAccessFile(this.mp3_file, "r");
                try {
                    if (randomAccessFile.length() >= 129L) break block5;
                    bl = false;
                    Object var8_4 = null;
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    randomAccessFile.close();
                    throw throwable;
                }
                randomAccessFile.close();
                return bl;
            }
            long l = randomAccessFile.length() - 128L;
            randomAccessFile.seek(l);
            byte[] byArray = new byte[3];
            if (randomAccessFile.read(byArray, 0, 3) != 3) {
                throw new IOException("Read beyond end of file");
            }
            String string = new String(byArray, 0, 3, this.encoding);
            if (string.equals("TAG")) break block6;
            boolean bl = false;
            Object var8_5 = null;
            randomAccessFile.close();
            return bl;
        }
        boolean bl = true;
        Object var8_6 = null;
        randomAccessFile.close();
        return bl;
    }

    private String fillWithNills(String string, int n) {
        if (string == null) {
            string = new String("");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = string.length() + 1;
        while (n2 <= n) {
            stringBuffer.append('\u0000');
            ++n2;
        }
        return stringBuffer.toString();
    }
}

