/* PhotoOrganizer - $RCSfile: Id3TagEditor.java,v $                           
 * Copyright (C) 2001 Dmitriy Rogatkin.  All rights reserved.                    
 * Redistribution and use in source and binary forms, with or without            
 * modification, are permitted provided that the following conditions            
 * are met:                                                                      
 * 1. Redistributions of source code must retain the above copyright             
 *    notice, this list of conditions and the following disclaimer.              
 * 2. Redistributions in binary form must reproduce the above copyright          
 *    notice, this list of conditions and the following disclaimer in the        
 *    documentation and/or other materials provided with the distribution.       
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND       
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE        
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE   
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR   
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR   
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER   
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT           
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF       
 *  SUCH DAMAGE.                                                                 
 *                                                                               
 *  Visit http://drogatkin.openestate.net to get the latest infromation          
 *  about Rogatkin's products.                                                   
 *  $Id: Id3TagEditor.java,v 1.3 2001/06/27 20:22:46 rogatkin Exp $            
 */                                                                              

package photoorganizer.renderer;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;

import rogatkin.*;      
import photoorganizer.*;
import photoorganizer.formats.*;
import photoorganizer.media.*;

import de.vdheide.mp3.*;

public final class Id3TagEditor extends JPanel implements ActionListener { 
	static final String[] TAG_FIELDS = {
		AbstractInfo.ARTIST, AbstractInfo.ALBUM,
		AbstractInfo.TITLE, AbstractInfo.COMMENTS,
		AbstractInfo.COMPOSER, AbstractInfo.CONDUCTOR,
		AbstractInfo.LYRICIST, AbstractInfo.FILEOWNER,
		AbstractInfo.ARTISTWEBPAGE, AbstractInfo.AUDIOFILEWEBPAGE,
		AbstractInfo.AUDIOSOURCEWEBPAGE, AbstractInfo.BAND,
		AbstractInfo.REMIXER, AbstractInfo.SUBTITLE,
		AbstractInfo.TRACK, AbstractInfo.YEAR};
	
	public Id3TagEditor(Controller controller, AbstractFormat format) {
		this.controller = controller;
		this.format = format;
		AbstractInfo info = format.getInfo(); // TODO: check for MP3 and rise exception
		setLayout(new GranulatedLayout(3, TAG_FIELDS.length+4, Resources.CTRL_VERT_SIZE, Resources.CTRL_VERT_GAP, Resources.CTRL_HORIS_INSET, Resources.CTRL_HORIZ_GAP));
		tf_tagFields =  new JTextField[TAG_FIELDS.length];
		for (int i=0; i<TAG_FIELDS.length; i++) {
			add(new JLabel(TAG_FIELDS[i]), "0,"+i);
			add(tf_tagFields[i] = new JTextField(), "1,"+i+",2");
			try {
				tf_tagFields[i].setText(info.getAttribute(TAG_FIELDS[i]).toString());
			} catch(Exception e) {
				//e.printStackTrace();
				System.err.println(TAG_FIELDS[i]+" has not been set, "+e);
			}
		}
		add(new JLabel(AbstractInfo.GENRE), "0,"+TAG_FIELDS.length);
		add(cb_genre = new JComboBox(MP3.GENRES), "1,"+TAG_FIELDS.length+",2");
		try {
			cb_genre.setSelectedItem(MP3.GENRES[info.getIntAttribute(AbstractInfo.GENRE)]);
		} catch(Exception e) {
			try {
				cb_genre.setSelectedItem(info.getAttribute(AbstractInfo.GENRE).toString());
			} catch(Exception e2) {
				System.err.println(AbstractInfo.GENRE+" has not been set, "+e2+'/'+e);
			}
		}
		add(cb_id3v2 = new JCheckBox(Resources.LABEL_ID3V2TAG), "0,"+(TAG_FIELDS.length+1)+",2");
		cb_id3v2.setBorderPaintedFlat(true);
		add(controller.createButtonPanel(this, controller.BTN_MSK_OK+controller.BTN_MSK_CANCEL+controller.BTN_MSK_HELP, FlowLayout.RIGHT), "0,"+(TAG_FIELDS.length+2)+",3,2");
	}
	
	public void actionPerformed(ActionEvent e) {
		if (e.getActionCommand().equals(Resources.CMD_OK)) {
			AbstractInfo info = format.getInfo();
			for (int i=0; i<TAG_FIELDS.length; i++) {
				try {
					if (AbstractInfo.COMMENTS.equals(TAG_FIELDS[i])) {
						// TODO: make it more smarter for v2
						// adding description and type
						TagContent comment = new TagContent();
						comment.setContent(tf_tagFields[i].getText());
						comment.setType("Eng");
						comment.setDescription(TAG_FIELDS[i]);
						info.setAttribute(TAG_FIELDS[i], comment);
					} else
						info.setAttribute(TAG_FIELDS[i], tf_tagFields[i].getText());
				} catch(Exception ex) {
					System.err.println("Attribute "+TAG_FIELDS[i]+" could not be set because "+ex);
				}
			}
			boolean id3v2 = cb_id3v2.isSelected();
			((MP3File)info).setWriteID3v2(id3v2);
			// set genre
			if (id3v2)
				info.setAttribute(AbstractInfo.GENRE, cb_genre.getSelectedItem());
			else
				info.setAttribute(AbstractInfo.GENRE, "("+cb_genre.getSelectedIndex()+')');
			try {
				((MP3File)info).update();
			} catch(Exception ex) {
				// TODO: report to user
				ex.printStackTrace();
			}
		}
		((Window)getTopLevelAncestor()).dispose();
	}
		
	synchronized public static void editTag(Controller controller, AbstractFormat format) {
		 Id3TagEditor editor = new Id3TagEditor(controller, format);
		 JDialog dialog = new JDialog(controller.getMainFrame(), Resources.TITLE_ID3EDITOR, true);
		 dialog.setContentPane(editor);
		 dialog.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
		 dialog.addWindowListener(new Connector(editor, dialog));
		 dialog.pack();
		 dialog.setVisible(true);
	}
		
	protected Controller controller;
	protected AbstractFormat format;
	protected JTextField[] tf_tagFields;
	protected JComboBox cb_genre;
	protected JCheckBox cb_id3v2;
}

final class Connector extends WindowAdapter {
	private Window window;
	Connector(Id3TagEditor editor, Window window) {
		this.window = window;	
		
	}
	
	public void windowClosing(WindowEvent e) {
		window.dispose();
	}
}

