/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.BinaryFrame;
import de.vdheide.mp3.ByteBuilder;
import de.vdheide.mp3.Frame;
import de.vdheide.mp3.FrameDamagedException;
import de.vdheide.mp3.ID3;
import de.vdheide.mp3.ID3Exception;
import de.vdheide.mp3.ID3IllegalFormatException;
import de.vdheide.mp3.ID3v2;
import de.vdheide.mp3.ID3v2DecompressionException;
import de.vdheide.mp3.ID3v2Exception;
import de.vdheide.mp3.ID3v2Frame;
import de.vdheide.mp3.ID3v2IllegalVersionException;
import de.vdheide.mp3.ID3v2WrongCRCException;
import de.vdheide.mp3.MP3Properties;
import de.vdheide.mp3.NoID3TagException;
import de.vdheide.mp3.NoMP3FrameException;
import de.vdheide.mp3.ParseException;
import de.vdheide.mp3.Parser;
import de.vdheide.mp3.TagContent;
import de.vdheide.mp3.TagFormatException;
import de.vdheide.mp3.TextFrameEncoding;
import de.vdheide.mp3.TextFrameNoEncoding;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class MP3File
extends File {
    public static final String DEF_ASCII_ENCODING = "ISO8859_1";
    public static final String UNICODE_ENCODING = "UNICODE";
    protected boolean write_id3 = true;
    protected boolean write_id3v2 = true;
    protected boolean use_compression = true;
    protected boolean use_crc = true;
    protected boolean use_padding = true;
    protected boolean use_unsynchronization = true;
    protected ID3 id3 = null;
    protected ID3v2 id3v2 = null;
    protected MP3Properties prop = null;
    protected String encoding;

    public MP3File(String string) throws IOException, NoMP3FrameException, ID3v2WrongCRCException, ID3v2DecompressionException, ID3v2IllegalVersionException {
        super(string);
        this.reset(null);
    }

    public MP3File(File file, String string) throws IOException, NoMP3FrameException, ID3v2WrongCRCException, ID3v2DecompressionException, ID3v2IllegalVersionException {
        super(file, string);
        this.reset(null);
    }

    public MP3File(File file, String string, String string2) throws IOException, NoMP3FrameException, ID3v2WrongCRCException, ID3v2DecompressionException, ID3v2IllegalVersionException {
        super(file, string);
        this.reset(string2);
    }

    public MP3File(String string, String string2) throws IOException, NoMP3FrameException, ID3v2WrongCRCException, ID3v2DecompressionException, ID3v2IllegalVersionException {
        super(string, string2);
        this.reset(null);
    }

    public MP3File(String string, String string2, String string3) throws IOException, NoMP3FrameException, ID3v2WrongCRCException, ID3v2DecompressionException, ID3v2IllegalVersionException {
        super(string, string2);
        this.reset(string3);
    }

    public void setTagsEncoding(String string) {
        this.encoding = string;
        this.id3.setEncoding(string);
    }

    public String getTagsEncoding() {
        return this.encoding;
    }

    public void update() throws ID3Exception, ID3v2Exception {
        if (this.write_id3) {
            try {
                this.id3.writeTag();
            }
            catch (IOException iOException) {
                throw new ID3Exception();
            }
        }
        if (this.write_id3v2) {
            try {
                this.id3v2.update();
            }
            catch (IOException iOException) {
                throw new ID3v2Exception(iOException.getMessage());
            }
        }
    }

    public void setWriteID3(boolean bl) {
        this.write_id3 = bl;
    }

    public boolean getWriteID3() {
        return this.write_id3;
    }

    public void setWriteID3v2(boolean bl) {
        this.write_id3v2 = bl;
    }

    public boolean getWriteID3v2() {
        return this.write_id3v2;
    }

    public void setUseCompression(boolean bl) {
        this.use_compression = bl;
    }

    public boolean getUseCompression() {
        return this.use_compression;
    }

    public void setUseCRC(boolean bl) {
        this.use_crc = bl;
        if (this.id3v2 != null) {
            this.id3v2.setUseCRC(bl);
        }
    }

    public boolean getUseCRC() {
        return this.use_crc;
    }

    public void setUsePadding(boolean bl) {
        this.use_padding = bl;
        if (this.id3v2 != null) {
            this.id3v2.setUsePadding(bl);
        }
    }

    public boolean getUsePadding() {
        return this.use_padding;
    }

    public void setUseUnsynchronization(boolean bl) {
        this.use_unsynchronization = bl;
        if (this.id3v2 != null) {
            this.id3v2.setUseUnsynchronization(bl);
        }
    }

    public boolean getUseUnsynchronization() {
        return this.use_unsynchronization;
    }

    public int getMPEGLevel() {
        return this.prop.getMPEGLevel();
    }

    public int getLayer() {
        return this.prop.getLayer();
    }

    public int getBitrate() {
        return this.prop.getBitrate();
    }

    public int getSamplerate() {
        return this.prop.getSamplerate();
    }

    public int getMode() {
        return this.prop.getMode();
    }

    public int getEmphasis() {
        return this.prop.getEmphasis();
    }

    public boolean getProtection() {
        return this.prop.getProtection();
    }

    public boolean getPrivate() {
        return this.prop.getPrivate();
    }

    public boolean getPadding() {
        return this.prop.getPadding();
    }

    public boolean getCopyright() {
        return this.prop.getCopyright();
    }

    public boolean getOriginal() {
        return this.prop.getOriginal();
    }

    public long getLength() {
        return this.prop.getLength();
    }

    public TagContent getAlbum() throws FrameDamagedException {
        TagContent tagContent = TextFrameEncoding.read(this.id3v2, "TALB");
        if (tagContent.getTextContent() == null) {
            try {
                tagContent.setContent(this.id3.getAlbum());
            }
            catch (NoID3TagException noID3TagException) {
                // empty catch block
            }
        }
        return tagContent;
    }

    public void setAlbum(TagContent tagContent) throws TagFormatException {
        if (tagContent.getTextContent() == null) {
            throw new TagFormatException();
        }
        this.id3.setAlbum(tagContent.getTextContent());
        new TextFrameEncoding(this.id3v2, "TALB", tagContent, this.use_compression).write();
    }

    public TagContent getBPM() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TBPM");
    }

    public void setBPM(TagContent tagContent) throws TagFormatException {
        if (tagContent.getTextContent() == null || !this.checkNumeric(tagContent.getTextContent())) {
            throw new TagFormatException();
        }
        new TextFrameEncoding(this.id3v2, "TBPM", tagContent, this.use_compression).write();
    }

    public TagContent getComposer() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TCOM");
    }

    public void setComposer(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TCOM", tagContent, this.use_compression).write();
    }

    public TagContent getGenre() throws FrameDamagedException {
        TagContent tagContent = new TagContent();
        byte[] byArray = null;
        try {
            byArray = ((ID3v2Frame)this.id3v2.getFrame("TCON").elementAt(0)).getContent();
        }
        catch (ID3v2Exception iD3v2Exception) {
            // empty catch block
        }
        if (byArray == null) {
            try {
                int n = this.id3.getGenre();
                tagContent.setContent(String.valueOf(n));
            }
            catch (ID3Exception iD3Exception) {}
        } else {
            Parser parser = new Parser(byArray, true, this.encoding);
            try {
                tagContent.setContent(parser.parseText());
            }
            catch (ParseException parseException) {
                throw new FrameDamagedException();
            }
        }
        return tagContent;
    }

    public void setGenre(TagContent tagContent) throws TagFormatException {
        Object object;
        if (tagContent.getTextContent() == null) {
            throw new TagFormatException();
        }
        boolean bl = false;
        int n = 0;
        while (n != -1 && !bl) {
            int n2;
            n = tagContent.getTextContent().indexOf(40, n);
            if (n == -1 || !Character.isDigit(tagContent.getTextContent().charAt(n + 1)) || (n2 = tagContent.getTextContent().indexOf(41, n)) == -1) continue;
            try {
                object = new Integer(tagContent.getTextContent().substring(n + 1, n2));
                try {
                    this.id3.setGenre((Integer)object);
                }
                catch (ID3IllegalFormatException iD3IllegalFormatException) {
                    // empty catch block
                }
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!bl) {
            try {
                this.id3.setGenre(12);
            }
            catch (ID3IllegalFormatException iD3IllegalFormatException) {
                // empty catch block
            }
        }
        ByteBuilder byteBuilder = new ByteBuilder(1);
        byteBuilder.put(tagContent.getTextContent());
        object = byteBuilder.getBytes();
        try {
            this.id3v2.removeFrame("TCON");
        }
        catch (ID3v2Exception iD3v2Exception) {
            // empty catch block
        }
        try {
            ID3v2Frame iD3v2Frame = new ID3v2Frame("TCON", (byte[])object, false, false, false, this.use_compression ? (byte)2 : 0, 0, 0);
            this.id3v2.addFrame(iD3v2Frame);
        }
        catch (ID3v2DecompressionException iD3v2DecompressionException) {
            // empty catch block
        }
    }

    public TagContent getCopyrightText() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TCOP");
    }

    public void setCopyrightText(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TCOP", tagContent, this.use_compression).write();
    }

    public TagContent getDate() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TDAT");
    }

    public void setDate(TagContent tagContent) throws TagFormatException {
        if (tagContent.getTextContent() == null || !this.checkExactLength(tagContent.getTextContent(), 4) || !this.checkNumeric(tagContent.getTextContent())) {
            throw new TagFormatException();
        }
        new TextFrameEncoding(this.id3v2, "TDAT", tagContent, this.use_compression).write();
    }

    public TagContent getPlaylistDelay() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TDLY");
    }

    public void setPlaylistDelay(TagContent tagContent) throws TagFormatException {
        if (tagContent.getTextContent() == null || !this.checkNumeric(tagContent.getTextContent())) {
            throw new TagFormatException();
        }
        new TextFrameEncoding(this.id3v2, "TDLY", tagContent, this.use_compression).write();
    }

    public TagContent getEncodedBy() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TENC");
    }

    public void setEncodedBy(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TENC", tagContent, this.use_compression).write();
    }

    public TagContent getLyricist() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TEXT");
    }

    public void setLyricist(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TEXT", tagContent, this.use_compression).write();
    }

    public TagContent getFileType() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TFLT");
    }

    public void setFileType(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TFLT", tagContent, this.use_compression).write();
    }

    public TagContent getTime() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TIME");
    }

    public void setTime(TagContent tagContent) throws TagFormatException {
        if (tagContent.getTextContent() == null || !this.checkExactLength(tagContent.getTextContent(), 4) || !this.checkNumeric(tagContent.getTextContent())) {
            throw new TagFormatException();
        }
        new TextFrameEncoding(this.id3v2, "TIME", tagContent, this.use_compression).write();
    }

    public TagContent getContentGroup() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TIT1");
    }

    public void setContentGroup(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TIT1", tagContent, this.use_compression).write();
    }

    public TagContent getTitle() throws FrameDamagedException {
        TagContent tagContent = TextFrameEncoding.read(this.id3v2, "TIT2");
        if (tagContent.getTextContent() == null) {
            try {
                tagContent.setContent(this.id3.getTitle());
            }
            catch (NoID3TagException noID3TagException) {
                // empty catch block
            }
        }
        return tagContent;
    }

    public void setTitle(TagContent tagContent) throws TagFormatException {
        if (tagContent.getTextContent() == null) {
            throw new TagFormatException();
        }
        this.id3.setTitle(tagContent.getTextContent());
        new TextFrameEncoding(this.id3v2, "TIT2", tagContent, this.use_compression).write();
    }

    public TagContent getSubtitle() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TIT3");
    }

    public void setSubtitle(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TIT3", tagContent, this.use_compression).write();
    }

    public TagContent getInitialKey() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TKEY");
    }

    public void setInitialKey(TagContent tagContent) throws TagFormatException {
        if (tagContent.getTextContent() == null || !this.checkMaxLength(tagContent.getTextContent(), 3)) {
            throw new TagFormatException();
        }
        new TextFrameEncoding(this.id3v2, "TKEY", tagContent, this.use_compression).write();
    }

    public TagContent getLanguage() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TLAN");
    }

    public void setLanguage(TagContent tagContent) throws TagFormatException {
        if (tagContent.getTextContent() == null || !this.checkExactLength(tagContent.getTextContent(), 3)) {
            throw new TagFormatException();
        }
        new TextFrameEncoding(this.id3v2, "TLAN", tagContent, this.use_compression).write();
    }

    public TagContent getLengthInTag() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TLEN");
    }

    public void setLengthInTag(TagContent tagContent) throws TagFormatException {
        if (tagContent.getTextContent() == null || !this.checkNumeric(tagContent.getTextContent())) {
            throw new TagFormatException();
        }
        new TextFrameEncoding(this.id3v2, "TLEN", tagContent, this.use_compression).write();
    }

    public TagContent getMediaType() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TMED");
    }

    public void setMediaType(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TMED", tagContent, this.use_compression).write();
    }

    public TagContent getOriginalTitle() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TOAL");
    }

    public void setOriginalTitle(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TOAL", tagContent, this.use_compression).write();
    }

    public TagContent getOriginalFilename() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TOFN");
    }

    public void setOriginalFilename(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TOFN", tagContent, this.use_compression).write();
    }

    public TagContent getOriginalLyricist() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TOLY");
    }

    public void setOriginalLyricist(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TOLY", tagContent, this.use_compression).write();
    }

    public TagContent getOriginalArtist() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TOPE");
    }

    public void setOriginalArtist(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TOPE", tagContent, this.use_compression).write();
    }

    public TagContent getOriginalYear() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TORY");
    }

    public void setOriginalYear(TagContent tagContent) throws TagFormatException {
        if (tagContent.getTextContent() == null || !this.checkExactLength(tagContent.getTextContent(), 4) || !this.checkNumeric(tagContent.getTextContent())) {
            throw new TagFormatException();
        }
        new TextFrameEncoding(this.id3v2, "TORY", tagContent, this.use_compression).write();
    }

    public TagContent getFileOwner() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TOWN");
    }

    public void setFileOwner(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TOWN", tagContent, this.use_compression).write();
    }

    public TagContent getArtist() throws FrameDamagedException {
        TagContent tagContent = TextFrameEncoding.read(this.id3v2, "TPE1");
        if (tagContent.getTextContent() == null) {
            try {
                tagContent.setContent(this.id3.getArtist());
            }
            catch (NoID3TagException noID3TagException) {
                // empty catch block
            }
        }
        return tagContent;
    }

    public void setArtist(TagContent tagContent) throws TagFormatException {
        this.id3.setArtist(tagContent.getTextContent());
        new TextFrameEncoding(this.id3v2, "TPE1", tagContent, this.use_compression).write();
    }

    public TagContent getBand() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TPE2");
    }

    public void setBand(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TPE2", tagContent, this.use_compression).write();
    }

    public TagContent getConductor() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TPE3");
    }

    public void setConductor(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TPE3", tagContent, this.use_compression).write();
    }

    public TagContent getRemixer() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TPE4");
    }

    public void setRemixer(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TPE4", tagContent, this.use_compression).write();
    }

    public TagContent getPartOfSet() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TPOS");
    }

    public void setPartOfSet(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TPOS", tagContent, this.use_compression).write();
    }

    public TagContent getPublisher() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TPUB");
    }

    public void setPublisher(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TPUB", tagContent, this.use_compression).write();
    }

    public TagContent getTrack() throws FrameDamagedException {
        TagContent tagContent = new TagContent();
        byte[] byArray = null;
        try {
            byArray = ((ID3v2Frame)this.id3v2.getFrame("TRCK").elementAt(0)).getContent();
        }
        catch (ID3v2Exception iD3v2Exception) {
            // empty catch block
        }
        if (byArray == null) {
            try {
                String string = String.valueOf(this.id3.getTrack());
                tagContent.setContent(string);
            }
            catch (ID3Exception iD3Exception) {}
        } else {
            Parser parser = new Parser(byArray, true, this.encoding);
            try {
                tagContent.setContent(parser.parseText());
            }
            catch (ParseException parseException) {
                throw new FrameDamagedException();
            }
        }
        return tagContent;
    }

    public void setTrack(TagContent tagContent) throws TagFormatException {
        Object object;
        if (tagContent.getTextContent() == null) {
            throw new TagFormatException();
        }
        boolean bl = false;
        int n = tagContent.getTextContent().indexOf(47);
        String string = n != -1 ? tagContent.getTextContent().substring(0, n) : tagContent.getTextContent();
        try {
            object = new Integer(string);
            try {
                this.id3.setGenre((Integer)object);
            }
            catch (Exception exception) {}
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        object = new ByteBuilder(1);
        ((ByteBuilder)object).put(tagContent.getTextContent());
        byte[] byArray = ((ByteBuilder)object).getBytes();
        try {
            this.id3v2.removeFrame("TRCK");
        }
        catch (ID3v2Exception iD3v2Exception) {
            // empty catch block
        }
        try {
            ID3v2Frame iD3v2Frame = new ID3v2Frame("TRCK", byArray, false, false, false, this.use_compression ? (byte)2 : 0, 0, 0);
            this.id3v2.addFrame(iD3v2Frame);
        }
        catch (ID3v2DecompressionException iD3v2DecompressionException) {
            // empty catch block
        }
    }

    public TagContent getRecordingDates() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TRDA");
    }

    public void setRecordingDate(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TRDA", tagContent, this.use_compression).write();
    }

    public TagContent getInternetRadioStationName() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TRSN");
    }

    public void setInternetRadioStationName(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TRSO", tagContent, this.use_compression).write();
    }

    public TagContent getInternetRadioStationOwner() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TRSO");
    }

    public void setInternetRadioStationOwner(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TRSO", tagContent, this.use_compression).write();
    }

    public TagContent getFilesize() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TSIZ");
    }

    public void setFilesize(TagContent tagContent) throws TagFormatException {
        if (tagContent.getTextContent() == null || !this.checkNumeric(tagContent.getTextContent())) {
            throw new TagFormatException();
        }
        new TextFrameEncoding(this.id3v2, "TSIZ", tagContent, this.use_compression).write();
    }

    public TagContent getISRC() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TSRC");
    }

    public void setISRC(TagContent tagContent) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TSRC", tagContent, this.use_compression).write();
    }

    public TagContent getYear() throws FrameDamagedException {
        TagContent tagContent = TextFrameEncoding.read(this.id3v2, "TYER");
        if (tagContent.getTextContent() == null) {
            try {
                tagContent.setContent(this.id3.getYear());
            }
            catch (NoID3TagException noID3TagException) {
                // empty catch block
            }
        }
        return tagContent;
    }

    public void setYear(TagContent tagContent) throws TagFormatException {
        if (tagContent.getTextContent() == null || !this.checkNumeric(tagContent.getTextContent()) || !this.checkMaxLength(tagContent.getTextContent(), 4) && !this.checkMaxLength(tagContent.getTextContent(), 5)) {
            throw new TagFormatException();
        }
        this.id3.setYear(tagContent.getTextContent());
        new TextFrameEncoding(this.id3v2, "TYER", tagContent, this.use_compression).write();
    }

    public TagContent getCommercialInformation() throws FrameDamagedException {
        return TextFrameNoEncoding.read(this.id3v2, "WCOM");
    }

    public void setCommercialInformation(TagContent tagContent) throws TagFormatException {
        new TextFrameNoEncoding(this.id3v2, "WCOM", tagContent, this.use_compression).write();
    }

    public TagContent getCopyrightWebpage() throws FrameDamagedException {
        return TextFrameNoEncoding.read(this.id3v2, "WCOP");
    }

    public void setCopyrightWebpage(TagContent tagContent) throws TagFormatException {
        new TextFrameNoEncoding(this.id3v2, "WCOP", tagContent, this.use_compression).write();
    }

    public TagContent getAudioFileWebpage() throws FrameDamagedException {
        return TextFrameNoEncoding.read(this.id3v2, "WOAF");
    }

    public void setAudioFileWebpage(TagContent tagContent) throws TagFormatException {
        new TextFrameNoEncoding(this.id3v2, "WOAF", tagContent, this.use_compression).write();
    }

    public TagContent getArtistWebpage() throws FrameDamagedException {
        return TextFrameNoEncoding.read(this.id3v2, "WOAR");
    }

    public void setArtistWebpage(TagContent tagContent) throws TagFormatException {
        new TextFrameNoEncoding(this.id3v2, "WOAR", tagContent, this.use_compression).write();
    }

    public TagContent getAudioSourceWebpage() throws FrameDamagedException {
        return TextFrameNoEncoding.read(this.id3v2, "WOAS");
    }

    public void setAudioSourceWebpage(TagContent tagContent) throws TagFormatException {
        new TextFrameNoEncoding(this.id3v2, "WOAS", tagContent, this.use_compression).write();
    }

    public TagContent getInternetRadioStationWebpage() throws FrameDamagedException {
        return TextFrameNoEncoding.read(this.id3v2, "WORS");
    }

    public void setInternetRadioStationWebpage(TagContent tagContent) throws TagFormatException {
        new TextFrameNoEncoding(this.id3v2, "WORS", tagContent, this.use_compression).write();
    }

    public TagContent getPaymentWebpage() throws FrameDamagedException {
        return TextFrameNoEncoding.read(this.id3v2, "WPAY");
    }

    public void setPaymentWebpage(TagContent tagContent) throws TagFormatException {
        new TextFrameNoEncoding(this.id3v2, "WPAY", tagContent, this.use_compression).write();
    }

    public TagContent getPublishersWebpage() throws FrameDamagedException {
        return TextFrameNoEncoding.read(this.id3v2, "WPUB");
    }

    public void setPublishersWebpage(TagContent tagContent) throws TagFormatException {
        new TextFrameNoEncoding(this.id3v2, "WPUB", tagContent, this.use_compression).write();
    }

    public TagContent getEventTimingCodes() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "ETCO");
    }

    public void setEventTimingCodes(TagContent tagContent) throws TagFormatException {
        new BinaryFrame(this.id3v2, "ETCO", tagContent, this.use_compression).write();
    }

    public TagContent getLookupTable() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "MLLT");
    }

    public void setLookupTable(TagContent tagContent) throws TagFormatException {
        new BinaryFrame(this.id3v2, "MLLT", tagContent, this.use_compression).write();
    }

    public TagContent getSynchronizedTempoCodes() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "SYTC");
    }

    public void setSynchronizedTempoCodes(TagContent tagContent) throws TagFormatException {
        new BinaryFrame(this.id3v2, "SYTC", tagContent, this.use_compression).write();
    }

    public TagContent getSynchronizedLyrics() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "SYLT");
    }

    public void setSynchronizedLyrics(TagContent tagContent) throws TagFormatException {
        new BinaryFrame(this.id3v2, "SYLT", tagContent, this.use_compression).write();
    }

    public TagContent getRelativeVolumenAdjustment() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "RVAD");
    }

    public void setRelativeVolumeAdjustment(TagContent tagContent) throws TagFormatException {
        new BinaryFrame(this.id3v2, "RVAD", tagContent, this.use_compression).write();
    }

    public TagContent getEqualisation() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "EQUA");
    }

    public void setEqualisation(TagContent tagContent) throws TagFormatException {
        new BinaryFrame(this.id3v2, "EQUA", tagContent, this.use_compression).write();
    }

    public TagContent getReverb() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "RVRB");
    }

    public void setReverb(TagContent tagContent) throws TagFormatException {
        new BinaryFrame(this.id3v2, "RVRB", tagContent, this.use_compression).write();
    }

    public TagContent getPlayCounter() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "PCNT");
    }

    public void setPlayCounter(TagContent tagContent) throws TagFormatException {
        new BinaryFrame(this.id3v2, "PCNT", tagContent, this.use_compression).write();
    }

    public TagContent getPopularimeter() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "POPM");
    }

    public void setPopularimeter(TagContent tagContent) throws TagFormatException {
        new BinaryFrame(this.id3v2, "POPM", tagContent, this.use_compression).write();
    }

    public TagContent getRecommendedBufferSize() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "RBUF");
    }

    public void setRecommendedBufferSize(TagContent tagContent) throws TagFormatException {
        new BinaryFrame(this.id3v2, "RBUF", tagContent, this.use_compression).write();
    }

    public TagContent getPositionSynchronization() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "POSS");
    }

    public void setPositionSynchronization(TagContent tagContent) throws TagFormatException {
        new BinaryFrame(this.id3v2, "POSS", tagContent, this.use_compression).write();
    }

    public TagContent getOwnership() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "OWNE");
    }

    public void setOwnership(TagContent tagContent) throws TagFormatException {
        new BinaryFrame(this.id3v2, "OWNE", tagContent, this.use_compression).write();
    }

    public TagContent getCommercial() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "COMR");
    }

    public void setCommercial(TagContent tagContent) throws TagFormatException {
        new BinaryFrame(this.id3v2, "COMR", tagContent, this.use_compression).write();
    }

    public TagContent getCDIdentifier() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "MCDI");
    }

    public void setCDIdentifier(TagContent tagContent) throws TagFormatException {
        new BinaryFrame(this.id3v2, "MCDI", tagContent, this.use_compression).write();
    }

    public TagContent getUniqueFileIdentifier() throws FrameDamagedException {
        byte[] byArray = Frame.read(this.id3v2, "UFID");
        if (byArray == null) {
            return new TagContent();
        }
        TagContent tagContent = new TagContent();
        Parser parser = new Parser(byArray, false);
        try {
            tagContent.setDescription(parser.parseText());
            tagContent.setContent(parser.parseBinary());
            return tagContent;
        }
        catch (ParseException parseException) {
            throw new FrameDamagedException();
        }
    }

    public void setUniqueFileIdentifier(TagContent tagContent) throws TagFormatException {
        if (tagContent.getDescription() == null || tagContent.getBinaryContent() == null || !this.checkMaxLength(tagContent.getBinaryContent(), 64)) {
            throw new TagFormatException();
        }
        ByteBuilder byteBuilder = new ByteBuilder(-1, tagContent.getDescription().length() + 2 + tagContent.getBinaryContent().length);
        byteBuilder.put(tagContent.getDescription());
        byteBuilder.put((byte)0);
        byteBuilder.put(tagContent.getBinaryContent());
        new Frame(this.id3v2, "UFID", byteBuilder.getBytes(), true, true, this.use_compression).write();
    }

    public TagContent getUserDefinedText() throws FrameDamagedException {
        byte[] byArray = Frame.read(this.id3v2, "TXXX");
        if (byArray == null) {
            return new TagContent();
        }
        TagContent tagContent = new TagContent();
        Parser parser = new Parser(byArray, true, this.encoding);
        try {
            tagContent.setDescription(parser.parseText());
            tagContent.setContent(parser.parseText());
            return tagContent;
        }
        catch (ParseException parseException) {
            throw new FrameDamagedException();
        }
    }

    public void setUserDefinedText(TagContent tagContent) throws TagFormatException {
        if (tagContent.getDescription() == null || tagContent.getTextContent() == null) {
            throw new TagFormatException();
        }
        ByteBuilder byteBuilder = new ByteBuilder(1, tagContent.getDescription().length() * 2 + 3 + tagContent.getTextContent().length() * 2);
        byteBuilder.put(tagContent.getDescription());
        byteBuilder.put((byte)0);
        byteBuilder.put((byte)0);
        byteBuilder.put(tagContent.getTextContent());
        new Frame(this.id3v2, "TXXX", byteBuilder.getBytes(), true, true, this.use_compression).write();
    }

    public TagContent getUserDefinedURL() throws FrameDamagedException {
        byte[] byArray = Frame.read(this.id3v2, "WXXX");
        if (byArray == null) {
            return new TagContent();
        }
        TagContent tagContent = new TagContent();
        Parser parser = new Parser(byArray, true, this.encoding);
        try {
            tagContent.setDescription(parser.parseText());
            tagContent.setContent(parser.parseText((byte)0));
            return tagContent;
        }
        catch (ParseException parseException) {
            throw new FrameDamagedException();
        }
    }

    public void setUserDefinedURL(TagContent tagContent) throws TagFormatException {
        if (tagContent.getDescription() == null || tagContent.getTextContent() == null) {
            throw new TagFormatException();
        }
        ByteBuilder byteBuilder = new ByteBuilder(1, tagContent.getDescription().length() * 2 + 3 + tagContent.getTextContent().length());
        byteBuilder.put(tagContent.getDescription());
        byteBuilder.put((byte)0);
        byteBuilder.put((byte)0);
        try {
            byteBuilder.put(tagContent.getTextContent().getBytes(DEF_ASCII_ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        new Frame(this.id3v2, "WXXX", byteBuilder.getBytes(), true, true, this.use_compression).write();
    }

    public TagContent getUnsynchronizedLyrics() throws FrameDamagedException {
        byte[] byArray = Frame.read(this.id3v2, "USLT");
        if (byArray == null) {
            return new TagContent();
        }
        TagContent tagContent = new TagContent();
        Parser parser = new Parser(byArray, true, this.encoding);
        try {
            byte[] byArray2 = parser.parseBinary(3);
            try {
                tagContent.setType(new String(byArray2, DEF_ASCII_ENCODING));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            tagContent.setDescription(parser.parseText());
            tagContent.setContent(parser.parseText());
            return tagContent;
        }
        catch (ParseException parseException) {
            throw new FrameDamagedException();
        }
    }

    public void setUnsynchronizedLyrics(TagContent tagContent) throws TagFormatException {
        if (tagContent.getType() == null || tagContent.getDescription() == null || tagContent.getTextContent() == null || !this.checkExactLength(tagContent.getType(), 3)) {
            throw new TagFormatException();
        }
        ByteBuilder byteBuilder = new ByteBuilder(1, 6 + tagContent.getDescription().length() * 2 + tagContent.getTextContent().length() * 2);
        try {
            byteBuilder.put(tagContent.getType().getBytes(DEF_ASCII_ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byteBuilder.put(tagContent.getDescription());
        byteBuilder.put((byte)0);
        byteBuilder.put((byte)0);
        byteBuilder.put(tagContent.getTextContent());
        new Frame(this.id3v2, "USLT", byteBuilder.getBytes(), true, true, this.use_compression).write();
    }

    public TagContent getComments() throws FrameDamagedException {
        TagContent tagContent = new TagContent();
        byte[] byArray = Frame.read(this.id3v2, "COMM");
        if (byArray == null) {
            try {
                tagContent.setContent(this.id3.getComment());
            }
            catch (Exception exception) {}
        } else {
            Parser parser = new Parser(byArray, true, this.encoding);
            try {
                byte[] byArray2 = parser.parseBinary(3);
                try {
                    tagContent.setType(new String(byArray2, DEF_ASCII_ENCODING));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                tagContent.setDescription(parser.parseText());
                tagContent.setContent(parser.parseText());
                return tagContent;
            }
            catch (ParseException parseException) {
                throw new FrameDamagedException();
            }
        }
        return tagContent;
    }

    public void setComments(TagContent tagContent) throws TagFormatException {
        if (tagContent.getType() == null || tagContent.getDescription() == null || tagContent.getTextContent() == null || !this.checkExactLength(tagContent.getType(), 3)) {
            throw new TagFormatException();
        }
        ByteBuilder byteBuilder = new ByteBuilder(1, 4 + tagContent.getDescription().length() * 2 + tagContent.getTextContent().length() * 2);
        try {
            byteBuilder.put(tagContent.getType().getBytes(DEF_ASCII_ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byteBuilder.put(tagContent.getDescription());
        byteBuilder.put((byte)0);
        byteBuilder.put((byte)0);
        byteBuilder.put(tagContent.getTextContent());
        new Frame(this.id3v2, "COMM", byteBuilder.getBytes(), true, true, this.use_compression).write();
        this.id3.setComment(tagContent.getTextContent());
    }

    public TagContent getPicture() throws FrameDamagedException {
        byte[] byArray = Frame.read(this.id3v2, "APIC");
        if (byArray == null) {
            return new TagContent();
        }
        TagContent tagContent = new TagContent();
        Parser parser = new Parser(byArray, true, this.encoding);
        try {
            tagContent.setType(parser.parseText((byte)0));
            tagContent.setSubtype(parser.parseBinary(1));
            tagContent.setDescription(parser.parseText());
            tagContent.setContent(parser.parseBinary());
            return tagContent;
        }
        catch (ParseException parseException) {
            throw new FrameDamagedException();
        }
    }

    public void setPicture(TagContent tagContent) throws TagFormatException {
        if (tagContent.getType() == null || tagContent.getBinarySubtype() == null || tagContent.getDescription() == null || tagContent.getBinaryContent() == null) {
            throw new TagFormatException();
        }
        ByteBuilder byteBuilder = new ByteBuilder(1, 6 + tagContent.getType().length() + 1 + tagContent.getDescription().length() * 2 + tagContent.getBinaryContent().length);
        try {
            byteBuilder.put(tagContent.getType().getBytes(DEF_ASCII_ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byteBuilder.put((byte)0);
        byteBuilder.put(tagContent.getBinarySubtype()[0]);
        byteBuilder.put(tagContent.getDescription());
        byteBuilder.put((byte)0);
        byteBuilder.put((byte)0);
        byteBuilder.put(tagContent.getBinaryContent());
        new Frame(this.id3v2, "APIC", byteBuilder.getBytes(), true, true, this.use_compression).write();
    }

    public TagContent getEncapsulatedObject() throws FrameDamagedException {
        byte[] byArray = Frame.read(this.id3v2, "GEOB");
        if (byArray == null) {
            return new TagContent();
        }
        TagContent tagContent = new TagContent();
        Parser parser = new Parser(byArray, true, this.encoding);
        try {
            tagContent.setType(parser.parseText((byte)0));
            tagContent.setSubtype(parser.parseText());
            tagContent.setDescription(parser.parseText());
            tagContent.setContent(parser.parseBinary());
            return tagContent;
        }
        catch (ParseException parseException) {
            throw new FrameDamagedException();
        }
    }

    public void setEncapsulatedObject(TagContent tagContent) throws TagFormatException {
        if (tagContent.getType() == null || tagContent.getTextSubtype() == null || tagContent.getDescription() == null || tagContent.getBinaryContent() == null) {
            throw new TagFormatException();
        }
        ByteBuilder byteBuilder = new ByteBuilder(1, 6 + tagContent.getType().length() + tagContent.getTextSubtype().length() * 2 + tagContent.getDescription().length() * 2 + tagContent.getBinaryContent().length);
        try {
            byteBuilder.put(tagContent.getType().getBytes(DEF_ASCII_ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byteBuilder.put((byte)0);
        byteBuilder.put(tagContent.getTextSubtype());
        byteBuilder.put((byte)0);
        byteBuilder.put((byte)0);
        byteBuilder.put(tagContent.getDescription());
        byteBuilder.put((byte)0);
        byteBuilder.put((byte)0);
        byteBuilder.put(tagContent.getBinaryContent());
        new Frame(this.id3v2, "GEOB", byteBuilder.getBytes(), true, true, this.use_compression).write();
    }

    public TagContent getTermsOfUse() throws FrameDamagedException {
        byte[] byArray = Frame.read(this.id3v2, "USER");
        if (byArray == null) {
            return new TagContent();
        }
        TagContent tagContent = new TagContent();
        Parser parser = new Parser(byArray, true, this.encoding);
        try {
            byte[] byArray2 = parser.parseBinary(3);
            try {
                tagContent.setType(new String(byArray2, DEF_ASCII_ENCODING));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            tagContent.setContent(parser.parseText());
            return tagContent;
        }
        catch (ParseException parseException) {
            throw new FrameDamagedException();
        }
    }

    public void setTermsOfUse(TagContent tagContent) throws TagFormatException {
        if (tagContent.getType() == null || tagContent.getTextContent() == null || !this.checkExactLength(tagContent.getType(), 3)) {
            throw new TagFormatException();
        }
        ByteBuilder byteBuilder = new ByteBuilder(1, 3 + tagContent.getTextContent().length() * 2);
        try {
            byteBuilder.put(tagContent.getType().getBytes(DEF_ASCII_ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byteBuilder.put(tagContent.getTextContent());
        new Frame(this.id3v2, "USER", byteBuilder.getBytes(), true, true, this.use_compression).write();
    }

    public TagContent getEncryptionMethodRegistration() throws FrameDamagedException {
        byte[] byArray = Frame.read(this.id3v2, "ENCR");
        if (byArray == null) {
            return new TagContent();
        }
        TagContent tagContent = new TagContent();
        Parser parser = new Parser(byArray, false);
        try {
            tagContent.setType(parser.parseText());
            tagContent.setSubtype(parser.parseBinary(1));
            tagContent.setContent(parser.parseBinary());
            return tagContent;
        }
        catch (ParseException parseException) {
            throw new FrameDamagedException();
        }
    }

    public void setEncryptionMethodRegistration(TagContent tagContent) throws TagFormatException {
        if (tagContent.getType() == null || tagContent.getBinarySubtype() == null || tagContent.getBinaryContent() == null || !this.checkExactLength(tagContent.getBinarySubtype(), 1)) {
            throw new TagFormatException();
        }
        ByteBuilder byteBuilder = new ByteBuilder(-1, 2 + tagContent.getType().length() + tagContent.getBinaryContent().length);
        byteBuilder.put(tagContent.getType());
        byteBuilder.put((byte)0);
        byteBuilder.put(tagContent.getBinarySubtype()[0]);
        byteBuilder.put(tagContent.getBinaryContent());
        new Frame(this.id3v2, "ENCR", byteBuilder.getBytes(), true, true, this.use_compression).write();
    }

    public TagContent getGroupIdentificationRegistration() throws FrameDamagedException {
        byte[] byArray = Frame.read(this.id3v2, "GRID");
        if (byArray == null) {
            return new TagContent();
        }
        TagContent tagContent = new TagContent();
        Parser parser = new Parser(byArray, false);
        try {
            tagContent.setType(parser.parseText());
            tagContent.setSubtype(parser.parseBinary(1));
            tagContent.setContent(parser.parseBinary());
            return tagContent;
        }
        catch (ParseException parseException) {
            throw new FrameDamagedException();
        }
    }

    public void setGroupIdentificationRegistration(TagContent tagContent) throws TagFormatException {
        if (tagContent.getType() == null || tagContent.getBinarySubtype() == null || tagContent.getBinaryContent() == null || !this.checkExactLength(tagContent.getBinarySubtype(), 1)) {
            throw new TagFormatException();
        }
        ByteBuilder byteBuilder = new ByteBuilder(-1, 2 + tagContent.getType().length() + tagContent.getBinaryContent().length);
        byteBuilder.put(tagContent.getType());
        byteBuilder.put((byte)0);
        byteBuilder.put(tagContent.getBinarySubtype()[0]);
        byteBuilder.put(tagContent.getBinaryContent());
        new Frame(this.id3v2, "GRID", byteBuilder.getBytes(), true, true, this.use_compression).write();
    }

    public TagContent getPrivateData() throws FrameDamagedException {
        byte[] byArray = Frame.read(this.id3v2, "PRIV");
        if (byArray == null) {
            return new TagContent();
        }
        TagContent tagContent = new TagContent();
        Parser parser = new Parser(byArray, false);
        try {
            tagContent.setType(parser.parseText());
            tagContent.setContent(parser.parseBinary());
            return tagContent;
        }
        catch (ParseException parseException) {
            throw new FrameDamagedException();
        }
    }

    public void setPrivateData(TagContent tagContent) throws TagFormatException {
        if (tagContent.getType() == null || tagContent.getBinaryContent() == null) {
            throw new TagFormatException();
        }
        ByteBuilder byteBuilder = new ByteBuilder(-1, 1 + tagContent.getType().length() + tagContent.getBinaryContent().length);
        byteBuilder.put(tagContent.getType());
        byteBuilder.put((byte)0);
        byteBuilder.put(tagContent.getBinaryContent());
        new Frame(this.id3v2, "PRIV", byteBuilder.getBytes(), true, true, this.use_compression).write();
    }

    protected void reset(String string) throws IOException, NoMP3FrameException, ID3v2WrongCRCException, ID3v2DecompressionException, ID3v2IllegalVersionException {
        this.prop = new MP3Properties(this);
        this.id3 = new ID3(this, string);
        this.id3v2 = new ID3v2(this, string);
    }

    protected boolean checkExactLength(String string, int n) {
        return string.length() == n;
    }

    protected boolean checkMaxLength(String string, int n) {
        return string.length() <= n;
    }

    protected boolean checkExactLength(byte[] byArray, int n) {
        return byArray.length == n;
    }

    protected boolean checkMaxLength(byte[] byArray, int n) {
        return byArray.length <= n;
    }

    protected boolean checkNumeric(String string) {
        try {
            Integer n = new Integer(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

