/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.jai;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import javax.swing.JPanel;

public class DisplayJAI
extends JPanel {
    protected RenderedImage source = null;
    protected int originX = 0;
    protected int originY = 0;

    public DisplayJAI() {
        this.setLayout(null);
    }

    public DisplayJAI(RenderedImage renderedImage) {
        this.setLayout(null);
        this.source = renderedImage;
        this.setPreferredSize(new Dimension(this.source.getWidth(), this.source.getHeight()));
    }

    public void setOrigin(int n, int n2) {
        this.originX = n;
        this.originY = n2;
        this.repaint();
    }

    public Point getOrigin() {
        return new Point(this.originX, this.originY);
    }

    public void set(RenderedImage renderedImage) {
        this.source = renderedImage;
        this.setPreferredSize(new Dimension(this.source.getWidth(), this.source.getHeight()));
        this.revalidate();
        this.repaint();
    }

    public synchronized void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.source == null) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        Insets insets = this.getInsets();
        int n = insets.left + this.originX;
        int n2 = insets.top + this.originY;
        Rectangle rectangle = graphics2D.getClipBounds();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        try {
            graphics2D.drawRenderedImage(this.source, AffineTransform.getTranslateInstance(n, n2));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }
}

