/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class BasicIo {
    static final byte M_SOF0 = -64;
    static final byte M_SOF1 = -63;
    static final byte M_SOF2 = -62;
    static final byte M_SOF3 = -61;
    public final byte M_DHT = (byte)-60;
    static final byte M_SOF5 = -59;
    static final byte M_SOF6 = -58;
    static final byte M_SOF7 = -57;
    static final byte M_JPG = -56;
    static final byte M_SOF9 = -55;
    static final byte M_SOF10 = -54;
    static final byte M_SOF11 = -53;
    static final byte M_SOF13 = -51;
    static final byte M_SOF14 = -50;
    static final byte M_SOF15 = -49;
    static final byte M_RST0 = -48;
    static final byte M_RST1 = -47;
    static final byte M_RST2 = -46;
    static final byte M_RST3 = -45;
    static final byte M_RST4 = -44;
    static final byte M_RST5 = -43;
    static final byte M_RST6 = -42;
    static final byte M_RST7 = -41;
    static final byte M_SOI = -40;
    static final byte M_EOI = -39;
    static final byte M_SOS = -38;
    public final byte M_DQT = (byte)-37;
    public final byte M_DNL = (byte)-36;
    public final byte M_DRI = (byte)-35;
    public final byte M_DHP = (byte)-34;
    public final byte M_EXP = (byte)-33;
    static final byte M_APP0 = -32;
    static final byte M_APP12 = -20;
    static final byte M_COM = -2;
    static final byte M_PRX = -1;
    boolean intel;
    boolean motorola;
    byte[] data;

    int i2bsI(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            this.data[n + n4] = (byte)(n2 >> n5);
            ++n4;
            n5 += 8;
        }
        return n + n3;
    }

    int bs2i(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = (n3 << 8) + (this.data[n + n4] & 0xFF);
            ++n4;
        }
        return n3;
    }

    int s2n(int n, int n2) {
        return this.s2n(n, n2, false);
    }

    int s2n(int n, int n2, boolean bl) {
        int n3;
        int n4 = 0;
        if (this.intel) {
            n3 = 0;
            int n5 = n;
            while (n5 < n2 + n && n5 < this.data.length) {
                n4 += (this.data[n5] & 0xFF) << n3;
                n3 += 8;
                ++n5;
            }
        } else if (this.motorola) {
            n3 = 0;
            while (n3 < n2) {
                n4 = (n4 << 8) + (this.data[n + n3] & 0xFF);
                ++n3;
            }
        }
        if (bl && (n4 & (n3 = 1 << 8 * n2 - 1)) > 0) {
            n4 -= n3 << 1;
        }
        return n4;
    }

    String s2a(int n, int n2) {
        String string = null;
        try {
            string = new String(this.data, n, n2, "Default");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    boolean isSignature(int n, String string) {
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) != (this.data[n + n2] & 0xFF)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static void skip(InputStream inputStream, long l) throws IOException {
        if (l == 0L) {
            return;
        }
        long l2 = l;
        while ((l2 -= inputStream.skip(l2)) > 0L) {
        }
    }

    public static void read(InputStream inputStream, byte[] byArray) throws IOException {
        int n = byArray.length;
        while (n > 0 && n <= byArray.length) {
            n -= inputStream.read(byArray, byArray.length - n, n);
        }
    }

    public static String convertLength(long l) {
        if (l / 1024L / 1024L > 0L) {
            return "" + l / 1024L / 1024L + "MB";
        }
        if (l / 1024L > 0L) {
            return "" + l / 1024L + "KB";
        }
        return "" + l;
    }
}

