      PROGRAM  MNDLZOOM
      USE      MSFLIB
      USE      DIALOGM
      IMPLICIT NONE
C                 
C  Computes a portion of the Mandelbrot set, and displays on an SVGA color
C     monitor with resolution from 640x480 up to 1280x1024, and 16 or 236
C     colors.  Color 0 (black) is used for values of the complex number c
C     for which z <== z**2 + c does not diverge within some maximum number of
C     iterations starting from z = 0 + 0 i.  For values of c which do lead to
C     divergence, colors 1-14 (or 1-234) are assigned either as a function of
C     number of iterations to reach a radius of 1000, or the computed "escape
C     time," or the azimuth of the last computed point.  Points closer than
C     some limit to the boundary of the set may be set to color 15 (or 235),
C     which is white.
C
C  P. A. Seeger, Los Alamos National Laboratory, April 18, 1988.
C    26 Dec 1988: cardioid formula for main body.
C    25 Mar 1989: distribution version, added user dialog.
C    04 Dec 1989: report execution time & number of iterations
C    30 Mar 1991: 480-line VGA mode; bitmap output
C    11 Apr 1991: increased max iteration number
C    08 Jan 1992: compute escape time, distance to set, and azimuth
C    23 Jan 1992: rotate VGA color palette when picture complete
C    19 Feb 1992: save full image in memory instead or reading video
C    07 Mar 1992: replace cursor with box, adjust both position & size;
C                 file output as post-option instead of setup option
C    08 Apr 1994: always generate .BMP file
C    19 Apr 1996: Conversion to Windows95, MS Powerstation Fortran 4.0;
C                 Dialog Box; "State" menu; Mouse
C    30 Apr 1996: new MANDELAZ calling sequence, OUTFLAG
C    01 Jun 1996: more entries in Dialog Box; no PRINT statements
C    12 Jun 1996: change RETRY flag to character, override with "ACCEPT"
C    08 Feb 1997: fix errors in .BMP output file for colors > 127
C    12 Feb 1997: added black/white option and max iterations to dialog
C
C  Externals:
C     DISTMNDL    MANDELAZ    MNDLDBOX    MNDLHELP     MNDLMENU      
C     MNDLMENU_2  MNDLMENU_3  MNDLMENU_4  MNDLMOUSE    M_SUB
C
      EXTERNAL  MNDLMOUSE
C
      INCLUDE   'RESOURCE.FD'
      TYPE (dialog)       DBOX
      TYPE (windowconfig) WCFG
      TYPE (xycoord)      XY
      REAL*8    MINDELX, UNITWIDTH
      PARAMETER (MINDELX=2.22044604925D-16, UNITWIDTH=2.50D0)
C
      REAL*8    ACENT,BCENT,DELX,DELY,A,B,DTEST,TOTALIT
      REAL*4    MAGNIFY,MAXMAG,OLDMAG,BORDER,SECONDS,ASPECT
      INTEGER*2 ROW(0:1279)
      INTEGER*2 IX,BUFFER(640),HH1,MM1,SS1,HD1,HH2,MM2,SS2,HD2,         &
     &          IX0,IY0,IY1,IY2
      INTEGER   ICWHITE,KMAX,I,II,HOURS,MINUTES,IREC,IC,RECORD,         &
     &          HDRLNTH,NHDRREC,ILEFT,IRIGHT,ITOP,IBOTTOM,IH,IW,        &
     &          IWMIN,IYZERO,KTEST,NIT,IBLK,IWHT,CFLAG,ISIZE,           & 
     &          IXMOUSE,IYMOUSE,KEYSTATE,IXNEW,IYNEW
      INTEGER*2 BMPHDR(28),PLANES,BITS
      INTEGER*4 FILESIZE,OFFSET,HDRSIZE,WIDTH,LINES,MAPSIZE,USED,       &
     &          IMPORTANT,RGBQ236(0:235),RGB16(0:15),RGBQ16(0:15),      &
     &          RGBTEMP,ISTAT,INEXT
      LOGICAL   LL,TEST,LBW,L236,OLDFILE,SAVEFILE,LBORDER,LMOUSE,       &
     &          RMOUSE,STOP,ROTATE,NEW,ACCEPT
      CHARACTER FNAME*12,FSAVE*12,OPTION*2,ALGORITHM*2,TEXT*128,        &
     &          DIRECT*($MAXPATH),RETRY*1
C
      COMMON /MOUSEINPUT/ LMOUSE,RMOUSE,IXMOUSE,IYMOUSE,KEYSTATE
      COMMON /MENUFLAGS/  STOP,ROTATE,NEW
C
      EQUIVALENCE (BMPHDR(2),FILESIZE),(BMPHDR(6),OFFSET),              &
     & (BMPHDR(8),HDRSIZE),(BMPHDR(10),WIDTH),(BMPHDR(12),LINES),       &
     & (BMPHDR(14),PLANES),(BMPHDR(15),BITS),(BMPHDR(18),MAPSIZE),      &
     & (BMPHDR(24),USED),(BMPHDR(26),IMPORTANT),                        &
     & (BMPHDR(28),RGBQ236(0),RGBQ16(0))
C
      DATA BMPHDR(1),HDRSIZE,PLANES,BITS/2hBM,40,1,4/
      DATA OPTION,ALGORITHM,ROTATE,BORDER,OLDFILE/                      &
     &      'S2',   'E ',   .TRUE., 0.15, .FALSE./
      DATA RGB16/0,#88FF00,#03FF03,#00FF88,#00FFFF,#03B8FF,#0370FF,     &
     &     #0303FF,#8800FF,#FF00FF,#FF0088,#FF0303,#FF7003,#FFB803,     &
     &     #FFFF00,#FFFFFF/
C
      DATA ACENT,BCENT,MAGNIFY/-0.74542989940D0,0.11300779474D0,0.9/
      DATA FNAME/'MNDLBRT0.BMP'/
C
      ISTAT = ABOUTBOXQQ('M N D L Z O O M\r\rHigh-precision rendition of&
     & the Mandelbrot set\r\rBeta: 12 February, 1997\rComments to: PASee&
     &ger@aol.com'C)
C
C     Open 'help' window for first time
      WCFG.numxpixels = 640
      WCFG.numypixels = 480
      WCFG.numtextcols = -1
      WCFG.numtextrows = -1
      WCFG.numcolors = 16
      WCFG.title = 'MndlZoom HELP'C
      WCFG.fontsize = -1
      TEST = SETWINDOWCONFIG(WCFG)
      IF (.NOT.TEST) TEST = SETWINDOWCONFIG(WCFG)
C
      CALL MNDLMENU(4)
	CALL MNDLHELP(XY)
C
C     Initialize Dialog Box parameters (may change for each picture)
      OPTION    = 'S2'
      ALGORITHM = 'E '
      CFLAG     = 0
      BORDER    = 0.15
      RETRY     = ' '
C
C     Repeat here for new picture
100   CONTINUE
C     Place current Zoom parameters in dialog box, and activate it
      FSAVE = RETRY
      IF (OLDFILE) FSAVE = FNAME
      CALL MNDLDBOX(DBOX, OPTION, ALGORITHM, CFLAG, BORDER,             &
     &              ACENT, BCENT, MAGNIFY, FSAVE, TEXT)
      IF (TEXT .NE. 'OK') THEN
         PRINT *, ' **** FATAL ERROR - '//TEXT
         STOP
      END IF
      INEXT = DLGMODAL(DBOX)
C
C     Return with new parameters from dialog box
      IF (INEXT .NE. IDCANCEL) THEN
C        Interpret checkmark in "Save File" box
         ACCEPT = .FALSE.
         IF (OLDFILE) THEN
            TEST = DLGGET(DBOX, IDC_Save_File, SAVEFILE, DLG_STATE)
            IF (SAVEFILE) THEN
               CLOSE(2, STATUS='KEEP')
            ELSE
               CLOSE(2, STATUS='DELETE')
            END IF
            OLDFILE = .FALSE.
	   ELSE IF (RETRY .NE. ' ') THEN
            TEST = DLGGET(DBOX, IDC_Save_File, ACCEPT, DLG_STATE)
	   END IF
C
         IF (INEXT .EQ. IDC_EXIT) STOP
C
C        Determine what has changed
         RETRY = ' '
         TEST = DLGGET(DBOX, IDC_Directory_Name, DIRECT)
         IF (.NOT. CHANGEDIRQQ(DIRECT)) RETRY = 'D'
         TEST = DLGGET(DBOX, IDC_2_Colors,   LBW,   DLG_STATE)
         TEST = DLGGET(DBOX, IDC_236_Colors, L236,  DLG_STATE)
         ICWHITE = 15
         IF (L236) ICWHITE = 235
         TEST = DLGGET(DBOX, IDC_Size_List, ISIZE, DLG_STATE)
         IF (ISIZE .EQ. 1) THEN
            OPTION(1:1) = 'V'
            WIDTH = 640
            LINES = 480
         ELSE IF (ISIZE .EQ. 3) THEN
            OPTION(1:1) = 'X'
            WIDTH = 1024
            LINES = 768
         ELSE IF (ISIZE .EQ. 4) THEN
            OPTION(1:1) = 'Z'
            WIDTH = 1280
            LINES = 1024
         ELSE
            OPTION(1:1) = 'S'
            WIDTH = 800
            LINES = 600
         END IF
C
C        Try to configure window to find out if this mode is supported
         WCFG.numxpixels = WIDTH
         WCFG.numypixels = LINES
         WCFG.numtextcols = -1
         WCFG.numtextrows = -1
         WCFG.numcolors = ICWHITE+1
         WCFG.fontsize = -1
         TEST = SETWINDOWCONFIG(WCFG)
         IF (.NOT.TEST) THEN
            RETRY = 'S'
            TEST  = SETWINDOWCONFIG(WCFG)
            WIDTH = WCFG.numxpixels
            LINES = WCFG.numypixels
            IF (WIDTH.GT.1024 .OR. LINES.GT.768) THEN
               ISIZE = 4
               OPTION(1:1) = 'Z'
            ELSE IF (WIDTH.GT.800 .OR. LINES.GT.600) THEN
               ISIZE = 3
               OPTION(1:1) = 'X'
            ELSE IF (WIDTH.GT.640 .OR. LINES.GT.480) THEN
               ISIZE = 2
               OPTION(1:1) = 'S'
            ELSE
               ISIZE = 1
               OPTION(1:1) = 'V'
            END IF
            ICWHITE = MIN(235, WCFG.numcolors - 1)
            L236 = ICWHITE .GE. 235
            IF (.NOT.L236) ICWHITE = 15
         END IF
	   IF (L236) THEN
	      OPTION(2:2) = '2'
	   ELSE IF (LBW) THEN
	      OPTION(2:2) = '0'
	   ELSE
	      OPTION(2:2) = '1'
	   END IF
         MAXMAG = UNITWIDTH/WIDTH/MINDELX
C
C        Read and test bounds of Zoom parameters
         TEST = DLGGET(DBOX, IDC_X_Center,   TEXT, DLG_STATE)
         READ (TEXT,*) ACENT
         TEST = DLGGET(DBOX, IDC_Y_Center,   TEXT, DLG_STATE)
         READ (TEXT,*) BCENT
         TEST = DLGGET(DBOX, IDC_Magnify,    TEXT, DLG_STATE)
         READ (TEXT,*) MAGNIFY
         TEST = DLGGET(DBOX, IDC_Iterations, TEXT, DLG_STATE)
	   IF (TEXT .EQ. 'default') THEN
	      KMAX = 0
	   ELSE
	      READ (TEXT,*) KMAX
	      KMAX = MAX(2,MIN(65534,KMAX))
	   END IF	  	  	
         IF (ACENT.LT.-2.D0) THEN
            RETRY = 'X'
            ACENT = -2.D0
         ELSE IF (ACENT.GT.0.75D0) THEN
            RETRY = 'X'
            ACENT = 0.75D0
         END IF
         IF (BCENT.LT.-1.5D0) THEN
            RETRY = 'Y'
            BCENT = -1.5D0
         ELSE IF (BCENT.GT.1.5D0) THEN
            RETRY = 'Y'
            BCENT = 1.5D0
         END IF
         IF (MAGNIFY.LT.0.125) THEN
            RETRY = 'M'
            MAGNIFY = 0.125
         ELSE IF (MAGNIFY .GT. MAXMAG) THEN
            RETRY = 'M'
            MAGNIFY = MAXMAG
         END IF
C
C        Check the "Algorithm" buttons from the Dialog Box
         TEST = DLGGET(DBOX, IDC_Border_, LBORDER)
	   IF (LBW) LBORDER = .FALSE.
         IF (LBORDER) THEN
C           White border
            TEST = DLGGET(DBOX, IDC_Border_Width, TEXT, DLG_STATE)
            READ (TEXT,*) BORDER
            IF (BORDER .GT. 1.5) THEN
               RETRY = 'B'
               BORDER = 1.5
            END IF
         END IF
         TEST = DLGGET(DBOX, IDC_Escape_, LL, DLG_STATE)
         IF (LL) THEN
C           "Escape time" button is pushed, set flag to zero
            ALGORITHM = 'E'
            CFLAG = 0
         ELSE
            TEST = DLGGET(DBOX, IDC_Integer_, LL, DLG_STATE)
            IF (LL) THEN
C              "Integer" button is pushed, set flag negative
               ALGORITHM = 'I'
               CFLAG = -1
            ELSE
               TEST = DLGGET(DBOX, IDC_Azimuthal_, LL, DLG_STATE)
               IF (LL) THEN
C                 "Azimuthal" button is pushed, find angle
                  ALGORITHM = 'A'
                  TEST = DLGGET(DBOX, IDC_Reference_Angle, TEXT,        &
     &                          DLG_STATE)
                  READ (TEXT,*) CFLAG
C                 Must be in range 1 - 360 (inclusive)
                  CFLAG = MOD(CFLAG,360)
                  DO WHILE (CFLAG .LE. 0)
                     CFLAG = CFLAG + 360   
                  END DO
               END IF
            END IF
         END IF
         IF (LBORDER) ALGORITHM(2:2) = 'B'
      END IF
C
      IF (INEXT .EQ. IDC_HELP) THEN
C        Display the 'help' screen, wait for keystroke
         CALL MNDLHELP(XY)
      END IF
C
      IF ((RETRY.NE.' ' .AND. .NOT.ACCEPT) .OR. INEXT.NE.IDOK) GO TO 100
C
C ****READY TO PROCEED WITH NEXT PICTURE****
C
C     Need to find new name for output .BMP file
      DO II=0,9
C        Look for unused file name of form "MNDLBRTn.BMP"
         FNAME(8:8) = CHAR(II+ICHAR('0'))
         INQUIRE (FILE=FNAME,EXIST=TEST)
         IF (.NOT.TEST) GO TO 220
      END DO
      DO II=0,25
C        Look for unused file name of form "MNDLBRTx.BMP"
         FNAME(8:8) = CHAR(II+ICHAR('A'))
         INQUIRE (FILE=FNAME,EXIST=TEST)
         IF (.NOT.TEST) GO TO 220
      END DO
      FNAME(8:8) = '_'
220   CONTINUE
C
C     Compute RGB values for 16 or 236 colors
      IF (.NOT.L236) THEN
         BITS = 4
         DO IC=0,15
            RGBQ236(IC) = RGB16(IC)
         END DO
         ICWHITE = 15
      ELSE
         BITS = 8
C        Compute 236-color palette of RGB values
C        Cyan (Green + Blue)
         RGBQ236( 78) = #00FFFF
C        Magenta (Blue + Red)
         RGBQ236(156) = #FF00FF
C        Yellow (Red + Green)
         RGBQ236(234) = #FFFF00
         RGBQ236(  0) = #FFFF00
         DO IC=0,19
C           Shades from Cyan toward Green, decrease B component
            RGBQ236( 77-IC) = RGBQ236( 78-IC) - #000004
C           Shades from Cyan toward Blue, decrease G component
            RGBQ236( 79+IC) = RGBQ236( 78+IC) - #000400
C           Shades from Magenta toward Blue, decrease R component
            RGBQ236(155-IC) = RGBQ236(156-IC) - #040000
C           Shades from Magenta toward Red, decrease B component
            RGBQ236(157+IC) = RGBQ236(156+IC) - #000004
C           Shades from Yellow toward Red, decrease G component
            RGBQ236(233-IC) = RGBQ236(234-IC) - #000400
C           Shades from Yellow toward Green, decrease R component
            RGBQ236(  1+IC) = RGBQ236(    IC) - #040000
         END DO
         DO IC=20,37
C           Take bigger steps when approaching primaries (R, G, B)
            II = 4 + INT((FLOAT(IC)/17.)**3)
C           Shades toward Green from Cyan, decrease B component
            RGBQ236( 77-IC) = RGBQ236( 78-IC) - #000001*II
C           Shades toward Blue from Cyan, decrease G component
            RGBQ236( 79+IC) = RGBQ236( 78+IC) - #000100*II
C           Shades toward Blue from Magenta, decrease R component
            RGBQ236(155-IC) = RGBQ236(156-IC) - #010000*II
C           Shades toward Red from Magenta, decrease B component
            RGBQ236(157+IC) = RGBQ236(156+IC) - #000001*II
C           Shades toward Red from Yellow, decrease G component
            RGBQ236(233-IC) = RGBQ236(234-IC) - #000100*II
C           Shades toward Green from Yellow, decrease R component
            RGBQ236(  1+IC) = RGBQ236(    IC) - #010000*II
         END DO
C        Black
         RGBQ236(  0) = 0
C        Green
         RGBQ236( 39) = #00FF00
C        Blue
         RGBQ236(117) = #0000FF
C        Red
         RGBQ236(195) = #FF0000
C        White (Red + Green + Blue)
         RGBQ236(235) = #FFFFFF
         ICWHITE = 235
      END IF
C
C     Complete the information for the BMP file header
      USED      = ICWHITE+1
      IMPORTANT = ICWHITE+1
      RECORD    = ((BITS*(WIDTH-1)/8)/4+1)*4
      HDRLNTH   = 29 + 2*ICWHITE
      NHDRREC   = (2*HDRLNTH-1)/RECORD+1
      OFFSET    = NHDRREC*RECORD
      FILESIZE  = (NHDRREC+LINES)*RECORD
C
C     Open file and write header record(s)
      OPEN (2,FILE=FNAME,STATUS='UNKNOWN',ACCESS='DIRECT',              &
     &      RECL=RECORD,FORM='UNFORMATTED') 
      IC = 1
      DO IREC=1,NHDRREC-1
         WRITE (2,REC=IREC) (BMPHDR(I),I=IC,IC+RECORD/2-1)
         IC = IC+RECORD/2
      END DO
      IREC = NHDRREC
      WRITE (2,REC=IREC) (BMPHDR(I),I=IC,HDRLNTH)
C
      IF (MAGNIFY.LT.MAXMAG/1024.) THEN
         DELX = UNITWIDTH/WIDTH/MAGNIFY
      ELSE
         DELX = MINDELX*ANINT(MAXMAG/MAGNIFY)
      END IF
      DELY = DELX
C     Choose default maximum iterations by square root of scale
      IF (KMAX .EQ. 0) KMAX = MIN1(65534., 16./SQRT(SNGL(DELX)))
      IF (LBORDER) THEN
C        Doing white border
         KTEST = MAX1(10., -2.*ALOG10(SNGL(DELX)))
         DTEST = BORDER*DELX
      ELSE
         KTEST = 65535
      END IF
C
      IX0 = WIDTH/2
      IY0 = LINES/2
      IYZERO = NINT(BCENT/DELY)
      IF (IYZERO.GE.1 .AND. IYZERO.LT.LINES) THEN
C        Make sure that centerline will be computed
         BCENT = DBLE(IYZERO)*DELY
      END IF
      OPEN (10, FILE='MNDLZOOM.TXT', STATUS='UNKNOWN', ACCESS='APPEND')
      WRITE (10,*) 'Output file is ',FNAME,'.  Screen mode is ',OPTION, &
     &             ', algorithm ',ALGORITHM
      WRITE (10,260) ACENT,BCENT,MAGNIFY,KMAX
260   FORMAT(' Center:',2F17.13/' Magnification ',G14.5,                &
     &   ',   Maximum Iterations per point',I6)
      IF (LBORDER) WRITE (10,265) BORDER
265   FORMAT(' White border if within',F5.2,' pixels')
      OLDFILE = .FALSE.
C
C     Open graphics child window as unit 9
      WRITE (TEXT,270) ACENT,BCENT,MAGNIFY
270   FORMAT('Mandelbrot Set at (',F15.12,',',F15.12,'), x',1PG11.3)
      OPEN (9, FILE='USER', TITLE=TRIM(ADJUSTL(TEXT))//CHAR(0))
C     Load the color registers with computed RGB values
      IF (ICWHITE .EQ. 15) THEN
         ISTAT = REMAPALLPALETTERGB(RGBQ16)
      ELSE
         ISTAT = REMAPALLPALETTERGB(RGBQ236)
      END IF
      ISTAT = SETCOLOR(ICWHITE)
      CALL MOVETO (0, 0, XY)
      ISTAT = LINETO (WIDTH-1, LINES-1)
      CALL MOVETO (0, LINES-1, XY)
      ISTAT = LINETO (WIDTH-1, 0)
C
C     Initialize mouse input values, "new" center and width
      STOP    = .FALSE.
      NEW     = .FALSE.
      LMOUSE  = .FALSE.
      RMOUSE  = .FALSE.
      IXMOUSE = IX0
      IYMOUSE = IY0
      IW      = WIDTH/10
      IWMIN   = MAX1(2.,FLOAT(WIDTH)*SNGL(MINDELX/DELX))
      ASPECT  = FLOAT(WIDTH)/FLOAT(LINES)
      ISTAT = UNREGISTERMOUSEEVENT(9, MOUSE$RBUTTONDOWN)
      ISTAT = REGISTERMOUSEEVENT(9, MOUSE$LBUTTONDOWN, MNDLMOUSE)
      ISTAT = REGISTERMOUSEEVENT(9, MOUSE$LBUTTONUP, MNDLMOUSE)
      RGBTEMP = 0
C
C     Loop over all pixel positions on the screen (WIDTH x LINES),
C     starting from row at center and moving outward
C
C     Start measuring time and iterations
      TOTALIT = 0.D0
      CALL GETTIM(HH1,MM1,SS1,HD1)
      DO IY1=IY0,0,-1
C        Upper row, from left to right
         B = BCENT-DBLE(IY1-IY0)*DELY
         IF (IY1 .EQ. IY0+IYZERO) B = 0.D0
         NIT = 0
         DO IX=0,WIDTH-1
            A = ACENT+DBLE(IX-IX0)*DELX
            CALL M_SUB(A,B,IX,IY1,KMAX,NIT,KTEST,DTEST,IBLK,IWHT,       &
     &                 CFLAG,ICWHITE,LBW,ROW)
         END DO
         TOTALIT = TOTALIT + DBLE(NIT)
C
         IF (BITS.EQ.4) THEN
C           Pack 4 4-bit pixels into each 16-bit word in BUFFER
            DO IX=0,WIDTH-1,4
               IC =        ISHFT(INT4(IAND(ROW(IX  ),#0F)), 4)
               IC = IOR(IC,      INT4(IAND(ROW(IX+1),#0F))    )
               IC = IOR(IC,ISHFT(INT4(IAND(ROW(IX+2),#0F)),12))
               IC = IOR(IC,ISHFT(INT4(IAND(ROW(IX+3),#0F)), 8))
               BUFFER(IX/4+1) = IC
            END DO
         ELSE
C           Pack 2 8-bit pixels into each 16-bit word in BUFFER
            DO IX=0,WIDTH-1,2
               IC =              INT4(ROW(IX  ))     
               IC = IOR(IC,ISHFT(INT4(ROW(IX+1)),8))
               BUFFER(IX/2+1) = IC
            END DO
         END IF
         IREC = NHDRREC+LINES-IY1
         WRITE (2,REC=IREC) (BUFFER(I),I=1,RECORD/2)
C
C        Check for mouse or menu input
         IF (STOP .OR. NEW .OR. LMOUSE) GO TO 450
C
C        Lower row, from left to right
         IY2 = LINES-IY1-1
         B = BCENT-DBLE(IY2-IY0)*DELY
         IF (IY2 .EQ. IY0+IYZERO) B = 0.D0
         NIT = 0
         DO IX=0,WIDTH-1
            A = ACENT+DBLE(IX-IX0)*DELX
            CALL M_SUB(A,B,IX,IY2,KMAX,NIT,KTEST,DTEST,IBLK,IWHT,       &
     &                 CFLAG,ICWHITE,LBW,ROW)
         END DO
         TOTALIT = TOTALIT + DBLE(NIT)
C
         IF (BITS.EQ.4) THEN
C           Pack 4 4-bit pixels into each 16-bit word in BUFFER
            DO IX=0,WIDTH-1,4
               IC =        ISHFT(INT4(IAND(ROW(IX  ),#0F)), 4)
               IC = IOR(IC,      INT4(IAND(ROW(IX+1),#0F))    )
               IC = IOR(IC,ISHFT(INT4(IAND(ROW(IX+2),#0F)),12))
               IC = IOR(IC,ISHFT(INT4(IAND(ROW(IX+3),#0F)), 8))
               BUFFER(IX/4+1) = IC
            END DO
         ELSE
C           Pack 2 8-bit pixels into each 16-bit word in BUFFER
            DO IX=0,WIDTH-1,2
               IC =              INT4(ROW(IX  ))     
               IC = IOR(IC,ISHFT(INT4(ROW(IX+1)),8))
               BUFFER(IX/2+1) = IC
            END DO
         END IF
         IREC = NHDRREC+LINES-IY2
         WRITE (2,REC=IREC) (BUFFER(I),I=1,RECORD/2)
C
C        Check for mouse or menu input
         IF (STOP .OR. NEW .OR. LMOUSE) GO TO 450
C
      END DO
C
C     The picture file is complete
      OLDFILE = .TRUE.
      CALL GETTIM(HH2,MM2,SS2,HD2)
      SECONDS = FLOAT(SS2-SS1)+0.01*FLOAT(HD2-HD1)
      IF (SECONDS.LT.0.) THEN
         SECONDS = SECONDS+60.
         MM2 = MM2-1
      ELSE IF (SECONDS.GE.60.) THEN
         SECONDS = SECONDS-60.
         MM2 = MM2+1
      END IF
      MINUTES = MM2-MM1
      IF (MINUTES.LT.0) THEN
         MINUTES = MINUTES+60
         HH2 = HH2-1
      ELSE IF (MINUTES.GE.60) THEN
         MINUTES = MINUTES-60
         HH2 = HH2+1
      END IF
      HOURS = HH2-HH1
      IF (HOURS.LT.0) HOURS = HOURS+24
      OLDMAG = MAGNIFY
C
      WRITE (10,320) TOTALIT,HOURS,MINUTES,SECONDS
320   FORMAT(' Total iterations =',F13.0,'   Execution time',I4,        &
     &   ':',I2,':',F4.1/)
      CLOSE (10)
C
C     Hold screen, rotate colors
      HD2 = 0
      DO WHILE (.NOT.(STOP .OR. NEW .OR. LMOUSE))
         IF (.NOT.L236) CALL SLEEPQQ(450)
         IF (ROTATE .AND. .NOT.LBW) THEN
            RGBTEMP = RGBQ236(ICWHITE-1)
            DO IC=ICWHITE-1,2,-1
               RGBQ236(IC) = RGBQ236(IC-1)
            END DO
            RGBQ236(1) = RGBTEMP
            IF (ICWHITE .EQ. 15) THEN
               ISTAT = REMAPALLPALETTERGB(RGBQ16)
            ELSE
               ISTAT = REMAPALLPALETTERGB(RGBQ236)
            END IF
         END IF
      END DO

      IF (RGBTEMP .NE. 0) THEN
C        Rewrite header with rotated R-G-B palette values
         IC = 1
         DO IREC=1,NHDRREC-1
            WRITE (2,REC=IREC) (BMPHDR(I),I=IC,IC+RECORD/2-1)
            IC = IC+RECORD/2
         END DO
         WRITE (2,REC=NHDRREC) (BMPHDR(I),I=IC,HDRLNTH)
         RGBTEMP = 0
      END IF
C
C     Termination: menu "Stop" or "New", or left mouse click
450   CONTINUE
      IXNEW = IXMOUSE
      IYNEW = IYMOUSE
C     Activate Right mouse button
      TEST  = REGISTERMOUSEEVENT(9, MOUSE$RBUTTONDOWN, MNDLMOUSE)
      TEST  = REGISTERMOUSEEVENT(9, MOUSE$RBUTTONUP, MNDLMOUSE)
      ISTAT = SETCOLOR(ICWHITE)
      ISTAT = SETWRITEMODE($GXOR)
C
C     Repeat here for each move or resize of the box
      DO WHILE (.NOT. NEW)
C        Draw a box, using complementary colors
         IW      = MAX0(IWMIN, IW)
         ILEFT   = MAX0(0, IXNEW-IW/2)
         IRIGHT  = MIN0(WIDTH-1, ILEFT+IW)
         ILEFT   = IRIGHT - IW
         IH      = NINT(FLOAT(IW)/ASPECT)
         ITOP    = MAX0(0, IYNEW-IH/2)
         IBOTTOM = MIN0(LINES-1, ITOP+IH)
         ITOP    = IBOTTOM - IH
         ISTAT   = RECTANGLE($GBORDER, ILEFT, ITOP, IRIGHT, IBOTTOM)
C
C        Wait for Mouse or Menu input
520      CONTINUE
         IF (LMOUSE) THEN
            IXNEW = IXMOUSE
            IYNEW = IYMOUSE
         ELSE IF (RMOUSE) THEN
            I = NINT(ASPECT*FLOAT(ABS(IYMOUSE-IYNEW)))
            IW = 2*MAX(1, I, ABS(IXMOUSE-IXNEW))
         ELSE IF (.NOT. NEW) THEN
C           No exit from wait loop yet
            CALL SLEEPQQ(20)
	      GO TO 520
         END IF
C
C        Restore pixels under previously drawn box
         ISTAT = RECTANGLE($GBORDER, ILEFT, ITOP, IRIGHT, IBOTTOM)
      END DO
C
C     Ready for next picture
      TEST = UNREGISTERMOUSEEVENT(9, MOUSE$LBUTTONDOWN)
      TEST = UNREGISTERMOUSEEVENT(9, MOUSE$RBUTTONDOWN)
      TEST = UNREGISTERMOUSEEVENT(9, MOUSE$LBUTTONUP)
      TEST = UNREGISTERMOUSEEVENT(9, MOUSE$RBUTTONUP)
      TEST = UNREGISTERMOUSEEVENT(9, MOUSE$MOVE)
      LMOUSE = .FALSE.
      RMOUSE = .FALSE.
      ACENT   = ACENT + DBLE(IXNEW-IX0)*DELX
      BCENT   = BCENT - DBLE(IYNEW-IY0)*DELX
      MAGNIFY = MAGNIFY * FLOAT(WIDTH)/FLOAT(IW)
      IF (.NOT.OLDFILE) CLOSE(2, STATUS='DELETE')
      CLOSE(9)
      ISTAT = SETWRITEMODE($GPSET)
C
C     Loop back for new case Dialog Box
      GO TO 100
      END
C
C**********
C
      SUBROUTINE M_SUB(A,B,IX,IY,KMAX,NIT,KTEST,DTEST,IBLK,IWHT,CFLAG,  &               
     &                 ICWHITE,LBW,ROW)
      USE MSFLIB
C
C     Dedicated subroutine for MNDLZOOM and its progeny
C
      IMPLICIT NONE
      REAL*8    A,B,R,DTEST,FACTOR(500),ALPHA,AZ
      INTEGER*2 ROW(*)
      INTEGER*2 IX,IY,ICOLOR,ICOLD
      INTEGER   I,KMAX,ICWHITE,K,NIT,KTEST,IBLK,IWHT,CFLAG,OLDCFLAG
      REAL*4    ESCAPE,AZIMUTH,COLOR,FCOLORS
      LOGICAL   LESCAPE,LAZIMTH,LBW
      REAL*8    DISTMNDL
      REAL*8    TWOPI
      PARAMETER (TWOPI=6.2831853072D0)
      SAVE      OLDCFLAG,FACTOR,ICOLD
      DATA      OLDCFLAG,FACTOR,ICOLD/360,500*0.D0,-1/
C
      FCOLORS = FLOAT(ICWHITE-1)
      LESCAPE = CFLAG .EQ. 0
      LAZIMTH = CFLAG .GT. 0
      IF (CFLAG.NE.OLDCFLAG .AND. LAZIMTH) THEN
         ALPHA = FLOAT(MOD(CFLAG,360))/360.*TWOPI
         I = CFLAG
         FACTOR(1) = ALPHA
         DO 10 K=2,500
            IF (I .EQ. 360) THEN
               FACTOR(K) = 0.
            ELSE
               FACTOR(K) = DMOD(2.D0*FACTOR(K-1),TWOPI)
               IF (I .LT. 360) I = I + I
            END IF
10       CONTINUE
         OLDCFLAG = CFLAG
      END IF
C
      R = DSQRT((A-0.25D0)**2 + B**2)
      ICOLOR = 0
      IF (R.EQ.0.D0 .OR. R.LT.0.5D0*(1.D0-(A-0.25D0)/R)) THEN
C        Point is in main body - won't diverge     
         IBLK = IBLK+1
      ELSE IF ((A+1.D0)**2+B**2 .LT. 0.0625D0) THEN
C        Point is in first bud - won't diverge
         IBLK = IBLK+1
      ELSE
C        Count number of iterations till divergence
         CALL MANDELAZ(A, B, KMAX, K, ESCAPE, AZIMUTH, CFLAG)
         NIT = NIT + K
         IF (K .GE. KMAX) THEN
C           Probably not going to diverge - point is in Mandelbrot set
            IBLK = IBLK+1
	   ELSE IF (LBW) THEN
	      ICOLOR = ICWHITE
         ELSE IF (K.GT.KTEST .AND. DISTMNDL(A,B,K).LT.DTEST) THEN
C           Very close to boundary - make color white
            ICOLOR = ICWHITE
            IWHT = IWHT+1
         ELSE IF (LAZIMTH .AND. K.GT.500) THEN
C           All precision of azimuth lost - make color white but don't count it
            ICOLOR = ICWHITE
         ELSE 
            IF (LESCAPE) THEN
C              Assign colors depending on ESCAPE time
               IF (ESCAPE .LE. 0.25) THEN
C                 Diverged very fast - use minimum color value
                  COLOR = 0.
               ELSE IF (ESCAPE .LE. 4.0) THEN
C                 Linear color scale for small numbers
                  COLOR = 0.03125*(ESCAPE-0.25)
               ELSE IF (ESCAPE .LE. 256.0) THEN
C                 Use square-root scale over middle of color range
                  COLOR = 0.125*(SQRT(ESCAPE)-1.0625)
               ELSE
C                 Shift to log scale for large iteration count
                  COLOR = ALOG(ESCAPE)-3.67799
               END IF
            ELSE IF (LAZIMTH) THEN
C              Assign colors depending on AZIMUTH
               AZ = ALPHA + AZIMUTH - FACTOR(K)
               IF (AZ .LT. 0.D0) AZ = AZ + TWOPI
               COLOR = AZ/TWOPI
            ELSE
C              Assign colors depending on number of iterations
               COLOR = (FLOAT(K)-0.5)/FCOLORS
            END IF
C           Limit color numbers to range 1 - (ICWHITE-1)
            ICOLOR = FCOLORS*AMOD(COLOR,1.)+1.
         END IF
      END IF
C
C     Turn pixel on
      IF (ICOLOR .NE. ICOLD) THEN
         ICOLD = ICOLOR
         K = SETCOLOR(ICOLOR)
      END IF
      K = SETPIXEL(IX,IY)
C
C     Save color value in memory image
      ROW(IX) = ICOLOR
      RETURN
      END
