/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Value;

import X10Gimli.Debug;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueIdent;
import X10Gimli.Value.ValueNothing;
import X10Gimli.Value.ValueType;

public final class ValueString
extends Value {
    private static StringBuffer sbuf = new StringBuffer();

    public ValueString() {
    }

    public ValueString(String string) {
        this.setValueString(string);
        this.makeString();
    }

    public String getString() {
        return this.getValueString();
    }

    public Value applyArithmetic(String op, ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        if (cmp instanceof ValueString || cmp instanceof ValueIdent) {
            if (op == "+") {
                sbuf.setLength(0);
                sbuf.append(this.string);
                sbuf.append(cmp.string);
                return new ValueString(sbuf.toString());
            }
        } else if (cmp != null && op == "+") {
            sbuf.setLength(0);
            sbuf.append(this.string);
            sbuf.append(cmp.string);
            return new ValueString(sbuf.toString());
        }
        Debug.error(102, "(Runtime) Incompatible arithmetic operation for STRING type.");
        return ValueNothing.value;
    }

    public int compareTo(ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        if (cmp instanceof ValueString) {
            if (this.getString().compareTo(cmp.getString()) > 0) {
                return 1;
            }
            if (this.getString().compareTo(cmp.getString()) < 0) {
                return -1;
            }
            if (this.getString().compareTo(cmp.getString()) == 0) {
                return 0;
            }
            return 100;
        }
        Debug.error(101, "(WARNING) Incompatible comparison to STRING type : ".concat(String.valueOf(String.valueOf(cmp.string))));
        return 100;
    }

    public void makeString() {
        this.string = this.getValueString().intern();
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("\"").append(this.getValueString()).append("\"")));
    }

    public String toX10GIMLI() {
        String out = "\"";
        String in = this.getValueString();
        block5: for (int i = 0; i < in.length(); ++i) {
            switch (in.charAt(i)) {
                case '\n': {
                    out = String.valueOf(String.valueOf(out)).concat("\\n");
                    continue block5;
                }
                case '\\': {
                    out = String.valueOf(String.valueOf(out)).concat("\\\\");
                    continue block5;
                }
                case '\r': {
                    out = String.valueOf(String.valueOf(out)).concat("\\r");
                    continue block5;
                }
                default: {
                    out = String.valueOf(String.valueOf(out)).concat(String.valueOf(String.valueOf(in.charAt(i))));
                }
            }
        }
        out = String.valueOf(String.valueOf(out)).concat("\"");
        return out;
    }
}

