/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.System;

import X10Gimli.Command.Command;
import X10Gimli.System.AllImports;
import X10Gimli.System.Control;
import X10Gimli.System.Definition;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.System.Function;
import X10Gimli.System.Trigger;
import java.util.AbstractCollection;
import java.util.ArrayList;

public class Environment
extends EnvironmentSmall {
    private ArrayList vImportTitles = new ArrayList();
    private ArrayList vImports = new ArrayList();
    private ArrayList vFunctions;
    private ArrayList vTriggers;
    private ArrayList vControls;
    private Command cStartCommand;
    private Command cFinishCommand;
    private ArrayList vLocalTriggers = new ArrayList();

    public Environment() {
        this.vFunctions = new ArrayList();
        this.vTriggers = new ArrayList();
        this.vControls = new ArrayList();
    }

    public void setImports(ArrayList imports) {
        if (imports != null) {
            this.vImportTitles = imports;
            this.loadImports();
        }
    }

    public void setFunctions(ArrayList functions) {
        if (functions != null) {
            this.vFunctions = functions;
        }
    }

    public void setTriggers(ArrayList events) {
        if (events != null) {
            this.vTriggers = events;
        }
    }

    public void setControls(ArrayList controls) {
        if (controls != null) {
            this.vControls = controls;
        }
    }

    public void setStartCommand(Command command) {
        this.cStartCommand = command;
    }

    public void setFinishCommand(Command command) {
        this.cFinishCommand = command;
    }

    public void setLocalTriggers(ArrayList events) {
        if (events != null) {
            this.vLocalTriggers = events;
        }
    }

    public ArrayList getImports() {
        return this.vImportTitles;
    }

    public ArrayList getFunctions() {
        return this.vFunctions;
    }

    public ArrayList getTriggers() {
        return this.vTriggers;
    }

    public ArrayList getControls() {
        return this.vControls;
    }

    public Command getStartCommand() {
        return this.cStartCommand;
    }

    public Command getFinishCommand() {
        return this.cFinishCommand;
    }

    public ArrayList getLocalTriggers() {
        return this.vLocalTriggers;
    }

    private void loadImports() {
        int size = this.vImportTitles.size();
        this.vImports = new ArrayList();
        for (int i = 0; i < size; ++i) {
            Environment e = AllImports.loadImport((String)this.vImportTitles.get(i));
            if (e == null) continue;
            this.vImports.add(e);
        }
    }

    public ArrayList findControls(ArrayList cid) {
        ArrayList<Control> out;
        block2: {
            int i;
            out = new ArrayList<Control>();
            int size = this.vControls.size();
            for (i = 0; i < size; ++i) {
                Control c = (Control)this.vControls.get(i);
                if (!c.isControl(cid, this)) continue;
                out.add(c);
            }
            size = this.vImports.size();
            for (i = 0; i < size; ++i) {
                ArrayList a = ((Environment)this.vImports.get(i)).findControls(cid);
                out.addAll(a);
            }
            if (!(this.getParent() instanceof Environment)) break block2;
            out.addAll(((Environment)this.getParent()).findControls(cid));
        }
        return out;
    }

    public Definition findDefinition(String name) {
        Definition d;
        int i;
        ArrayList a = this.getDefinitions();
        int size = a.size();
        for (i = 0; i < size; ++i) {
            d = (Definition)a.get(i);
            if (d.getName() != name) continue;
            return d;
        }
        size = this.vImports.size();
        for (i = 0; i < size; ++i) {
            d = ((Environment)this.vImports.get(i)).findDefinition(name);
            if (d == null) continue;
            return d;
        }
        if (this.getParent() != null) {
            return this.getParent().findDefinition(name);
        }
        return null;
    }

    private ArrayList checkTriggers(ArrayList triggers, boolean keep) {
        int i;
        ArrayList<Trigger> out = new ArrayList<Trigger>();
        int size = triggers.size();
        for (i = 0; i < size; ++i) {
            Trigger t = (Trigger)triggers.get(i);
            if (!t.isTriggered(this)) continue;
            out.add(t);
            if (!keep) continue;
            t.reset(this);
        }
        if (!keep) {
            size = out.size();
            for (i = 0; i < size; ++i) {
                ((AbstractCollection)triggers).remove(out.get(i));
            }
        }
        return out;
    }

    public ArrayList checkTriggers() {
        ArrayList out = new ArrayList();
        out.addAll(this.checkTriggers(this.getFullEnvironment().getTriggers(), true));
        out.addAll(this.checkTriggers(this.getFullEnvironment().getLocalTriggers(), false));
        int size = this.vImports.size();
        for (int i = 0; i < size; ++i) {
            out.addAll(((Environment)this.vImports.get(i)).checkTriggers());
        }
        if (this.getFullEnvironment() != this.getSystemModel()) {
            out.addAll(this.checkTriggers(this.getSystemModel().getTriggers(), true));
            out.addAll(this.checkTriggers(this.getSystemModel().getLocalTriggers(), false));
            ArrayList vmImports = this.getSystemModel().getImports();
            size = vmImports.size();
            for (int i = 0; i < size; ++i) {
                out.addAll(((Environment)vmImports.get(i)).checkTriggers());
            }
        }
        return out;
    }

    public void setTrigger(Trigger trig) {
        Trigger findtrig = this.findTrigger(trig.getName());
        if (findtrig != null) {
            findtrig.setCommand(trig.getCommand());
            findtrig.setCase(trig.getCase());
        }
    }

    public void addTrigger(Trigger trig) {
        this.vTriggers.add(trig);
    }

    public void addLocalTrigger(Trigger trig) {
        this.vLocalTriggers.add(trig);
    }

    public Trigger findTrigger(String name) {
        Trigger t;
        int i;
        name = name.intern();
        int size = this.vTriggers.size();
        for (i = 0; i < size; ++i) {
            t = (Trigger)this.vTriggers.get(i);
            if (t.getName() != name) continue;
            return t;
        }
        size = this.vLocalTriggers.size();
        for (i = 0; i < size; ++i) {
            t = (Trigger)this.vLocalTriggers.get(i);
            if (t.getName() != name) continue;
            return t;
        }
        size = this.vImports.size();
        for (i = 0; i < size; ++i) {
            t = ((Environment)this.vImports.get(i)).findTrigger(name);
            if (t == null) continue;
            return t;
        }
        if (this.getParent() instanceof Environment) {
            return ((Environment)this.getParent()).findTrigger(name);
        }
        return null;
    }

    public Function findFunction(String name) {
        int i;
        name = name.intern();
        int size = this.vFunctions.size();
        Function f = null;
        for (i = 0; i < size; ++i) {
            f = (Function)this.vFunctions.get(i);
            if (f.getName() != name) continue;
            return f;
        }
        size = this.vImports.size();
        for (i = 0; i < size; ++i) {
            f = ((Environment)this.vImports.get(i)).findFunction(name);
            if (f == null) continue;
            return f;
        }
        if (this.getParent() != null && this.getParent() instanceof Environment) {
            return ((Environment)this.getParent()).findFunction(name);
        }
        return null;
    }

    public String toX10GIMLI(int depth) {
        StringBuffer sBuf;
        block12: {
            int i;
            char[] sBytes = new char[15];
            for (i = 0; i < 15; ++i) {
                sBytes[i] = 32;
            }
            sBuf = new StringBuffer("");
            int indent = depth * 2;
            if (this.vImportTitles.size() > 0) {
                sBuf.append(sBytes, 0, indent);
                sBuf.append("imports\r\n");
                for (i = 0; i < this.vImportTitles.size(); ++i) {
                    String title = (String)this.vImportTitles.get(i);
                    sBuf.append(sBytes, 0, indent + 2);
                    sBuf.append("\"");
                    sBuf.append(title);
                    sBuf.append("\";\r\n");
                }
                sBuf.append("\r\n");
            }
            if (this.getDefinitions().size() > 0) {
                sBuf.append(sBytes, 0, indent);
                sBuf.append("definitions\r\n");
                for (i = 0; i < this.getDefinitions().size(); ++i) {
                    sBuf.append(((Definition)this.getDefinitions().get(i)).toX10GIMLI(depth + 1));
                }
                sBuf.append("\r\n");
            }
            if (this.vFunctions.size() > 0) {
                sBuf.append(sBytes, 0, indent);
                sBuf.append("functions\r\n");
                for (i = 0; i < this.vFunctions.size(); ++i) {
                    sBuf.append(((Function)this.vFunctions.get(i)).toX10GIMLI(depth + 1));
                }
                sBuf.append("\r\n");
            }
            if (this.vTriggers.size() > 0) {
                sBuf.append(sBytes, 0, indent);
                sBuf.append("triggers\r\n");
                for (i = 0; i < this.vTriggers.size(); ++i) {
                    sBuf.append(((Trigger)this.vTriggers.get(i)).toX10GIMLI(depth + 1));
                }
                sBuf.append("\r\n");
            }
            if (this.cStartCommand != null) {
                sBuf.append(sBytes, 0, indent);
                sBuf.append("start\r\n");
                sBuf.append(this.cStartCommand.toX10GIMLI(depth + 1));
                sBuf.append("\r\n");
            }
            if (this.vControls.size() > 0) {
                for (i = 0; i < this.vControls.size(); ++i) {
                    sBuf.append(((Control)this.vControls.get(i)).toX10GIMLI(depth));
                    sBuf.append("\r\n");
                }
            }
            if (this.cFinishCommand == null) break block12;
            sBuf.append(sBytes, 0, indent);
            sBuf.append("finish\r\n");
            sBuf.append(this.cFinishCommand.toX10GIMLI(depth + 1));
            sBuf.append("\r\n");
        }
        return sBuf.toString();
    }
}

