/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Interface.Gateway;

import X10Gimli.Debug;
import X10Gimli.Interface.InputOutputGateway;
import X10Gimli.Native.WindowsAPI;
import X10Gimli.System.Packet.Packet;
import X10Gimli.System.Packet.WindowsapiPacket;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueNumber;
import java.util.ArrayList;

public class WINAPIGateway
extends InputOutputGateway {
    public WINAPIGateway() {
        this.sSource = "WINAPI";
    }

    public boolean initialize(Value param) {
        if (param == null) {
            Debug.log(1, "\"Successfully activated gateway for Windows API functions.\"");
            return true;
        }
        Debug.error(100, "\"Windows API gateway does not take any parameters.\"");
        return false;
    }

    protected void sendPacket(Packet pack) {
        block31: {
            try {
                Packet packet = pack.getPacketType();
                if (!(packet instanceof WindowsapiPacket)) break block31;
                WindowsapiPacket p = (WindowsapiPacket)packet;
                if (p.getCommand().getValueString().equalsIgnoreCase("FINDWINDOW")) {
                    int hwnd = 0;
                    try {
                        hwnd = WindowsAPI.findWindow(p.getValue("CLASSNAME").getValueString(), p.getValue("WINDOWNAME").getValueString());
                    }
                    catch (UnsatisfiedLinkError e) {
                        Debug.error(300, "Unable to perform native 'FindWindow' function.");
                    }
                    p.setFlags((byte)1);
                    p.setTags(new ArrayList());
                    p.setValues(new ArrayList());
                    p.setSource("");
                    p.setDest("");
                    p.addSegment("RETURN", new ValueNumber(hwnd));
                    this.inputReceived(p);
                    break block31;
                }
                if (p.getCommand().getValueString().equalsIgnoreCase("FINDCHILDWINDOW")) {
                    int hwnd = 0;
                    try {
                        hwnd = WindowsAPI.findChildWindow(p.getValue("PARENT").getNumber(), p.getValue("OLDEST").getNumber(), p.getValue("CLASSNAME").getValueString(), p.getValue("WINDOWNAME").getValueString());
                    }
                    catch (UnsatisfiedLinkError e) {
                        Debug.error(300, "Unable to perform native 'FindChildWindow' function.");
                    }
                    p.setFlags((byte)1);
                    p.setTags(new ArrayList());
                    p.setValues(new ArrayList());
                    p.setSource("");
                    p.setDest("");
                    p.addSegment("RETURN", new ValueNumber(hwnd));
                    this.inputReceived(p);
                    break block31;
                }
                if (p.getCommand().getValueString().equalsIgnoreCase("SIMULATEKEYDOWN")) {
                    try {
                        WindowsAPI.simulateKeyDown(p.getValue("KEY").getNumber());
                    }
                    catch (UnsatisfiedLinkError e) {
                        Debug.error(300, "Unable to perform native 'SimulateKeyDown' function.");
                    }
                } else if (p.getCommand().getValueString().equalsIgnoreCase("SIMULATEKEYUP")) {
                    try {
                        WindowsAPI.simulateKeyUp(p.getValue("KEY").getNumber());
                    }
                    catch (UnsatisfiedLinkError e) {
                        Debug.error(300, "Unable to perform native 'SimulateKeyUp' function.");
                    }
                } else if (p.getCommand().getValueString().equalsIgnoreCase("POSTMESSAGE")) {
                    try {
                        WindowsAPI.postMessage(p.getValue("HWND").getNumber(), p.getValue("MESSAGE").getNumber(), p.getValue("WPARAM").getNumber(), p.getValue("LPARAM").getNumber());
                    }
                    catch (UnsatisfiedLinkError e) {
                        Debug.error(300, "Unable to perform native 'PostMessage' function.");
                    }
                } else if (p.getCommand().getValueString().equalsIgnoreCase("SETFOCUS")) {
                    try {
                        WindowsAPI.setFocus(p.getValue("HWND").getNumber());
                    }
                    catch (UnsatisfiedLinkError e) {
                        Debug.error(300, "Unable to perform native 'SetFocus' function.");
                    }
                } else if (p.getCommand().getValueString().equalsIgnoreCase("RESTOREFOCUS")) {
                    try {
                        WindowsAPI.returnFocus();
                    }
                    catch (UnsatisfiedLinkError e) {
                        Debug.error(300, "Unable to perform native 'RestoreFocus' function.");
                    }
                } else if (p.getCommand().getValueString().equalsIgnoreCase("CREATEPROCESS")) {
                    try {
                        WindowsAPI.createProcess(p.getValue("COMMANDLINE").getValueString());
                    }
                    catch (UnsatisfiedLinkError e) {
                        Debug.error(300, "Unable to perform native 'CreateProcess' function.");
                    }
                }
            }
            catch (Exception e) {
                Debug.printCallStack("Exception performing native API function.", e);
            }
        }
    }
}

