/*
 * Decompiled with CFR 0.152.
 */
package Sav.X;

import Sav.X.Plane;
import Sav.X.X;
import Sav.Z.LineStatus;
import Sav.Z.Status;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

abstract class Planer {
    File folder;
    Vector path;
    Stack planes;
    Plane pl;
    StringBuffer text;
    char c;
    int lnum;
    LineStatus stLine;
    Status stProcess;
    Locator locator;
    String nl = System.getProperty("line.separator");
    String xmlFile = "";
    String root;
    ContentHandler ch;

    Planer() {
    }

    void setContentHandler(ContentHandler contentHandler) {
        this.ch = contentHandler;
    }

    public void parse(File file) throws IOException, ParserConfigurationException, SAXException {
        String string = this.getProcess();
        if (file.isDirectory()) {
            String[] stringArray = file.list(new XmlFilter(this));
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                File file2 = new File(file, stringArray[i2]);
                this.parseCurrent(file2);
            }
        } else {
            this.parseCurrent(file);
        }
        this.clearProcess();
        if (string != null) {
            this.setProcess(string);
        }
    }

    void parseCurrent(File file) throws IOException, ParserConfigurationException, SAXException {
        this.xmlFile = file.getName();
        this.setProcess(String.valueOf(String.valueOf(new StringBuffer("Parsing XML ").append(this.xmlFile).append("..."))));
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        InputSource inputSource = new InputSource(bufferedReader);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        XMLReader xMLReader = sAXParser.getXMLReader();
        xMLReader.setContentHandler(this.ch);
        try {
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            Exception exception;
            if (X.debug) {
                sAXException.printStackTrace();
            }
            if ((exception = sAXException.getException()) == null) {
                exception = sAXException;
            }
            throw new SAXException(this.message(exception));
        }
        this.clearLine();
        this.lnum = 0;
    }

    public void parse(Reader reader) throws IOException, ParserConfigurationException, SAXException {
        String string = this.getProcess();
        this.setProcess("Parsing XML...");
        InputSource inputSource = new InputSource(reader);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        XMLReader xMLReader = sAXParser.getXMLReader();
        xMLReader.setContentHandler(this.ch);
        try {
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            Exception exception;
            if (X.debug) {
                sAXException.printStackTrace();
            }
            if ((exception = sAXException.getException()) == null) {
                exception = sAXException;
            }
            throw new SAXException(this.message(exception));
        }
        this.clearLine();
        this.lnum = 0;
        this.clearProcess();
        if (string != null) {
            this.setProcess(string);
        }
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.path = new Vector();
        this.planes = new Stack();
        this.text = new StringBuffer();
        this.lnum = 1;
        this.path.addElement(this.root);
    }

    public void endDocument() throws SAXException {
        this.text();
        try {
            this.pl.store();
        }
        catch (IOException iOException) {
            throw new SAXException(this.message(iOException));
        }
        this.pl = null;
        this.clearLine();
    }

    void text() {
        int n2 = this.text.length();
        if (n2 > 0) {
            if (this.c == ' ') {
                this.text.deleteCharAt(n2 - 1);
            }
            this.text.append('\"');
            if (this.pl != null) {
                this.pl.addRow(this.text.toString(), null, null);
            }
            this.text = new StringBuffer();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.text();
        try {
            this.pl.store();
        }
        catch (IOException iOException) {
            throw new SAXException(this.message(iOException));
        }
        int n2 = this.path.size() - 1;
        this.path.remove(n2);
        this.pl = (Plane)this.planes.pop();
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            if (cArray[i2] <= ' ') {
                if (cArray[i2] == '\n') {
                    ++this.lnum;
                    this.setLine(this.lnum);
                }
                if (this.c == ' ' || this.text.length() <= 0) continue;
                this.c = (char)32;
                this.text.append(this.c);
                continue;
            }
            this.c = cArray[i2];
            if (this.text.length() == 0) {
                this.text.append('\"');
            }
            this.text.append(this.c);
        }
    }

    public void setRoot(String string) {
        this.root = string;
    }

    public File folder() {
        return this.folder;
    }

    public void clear() {
        String[] stringArray = this.folder.list(new TableFilter(this));
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            File file = new File(this.folder, stringArray[i2]);
            file.delete();
        }
    }

    public void drop() {
        this.clear();
        this.folder.delete();
    }

    public void setProcessStatus(Status status) {
        this.stProcess = status;
    }

    public Status getProcessStatus() {
        return this.stProcess;
    }

    public void setLineStatus(LineStatus lineStatus) {
        this.stLine = lineStatus;
    }

    public LineStatus getLineStatus() {
        return this.stLine;
    }

    void setProcess(String string) {
        if (this.stProcess != null) {
            this.stProcess.set(string);
        }
    }

    String getProcess() {
        if (this.stProcess != null) {
            return this.stProcess.get();
        }
        return null;
    }

    void clearProcess() {
        if (this.stProcess != null) {
            this.stProcess.clear();
        }
    }

    void setLine(int n2) {
        if (this.stLine != null) {
            this.stLine.set(n2);
        }
    }

    String getLine() {
        if (this.stLine != null) {
            return this.stLine.get();
        }
        return null;
    }

    void clearLine() {
        if (this.stLine != null) {
            this.stLine.clear();
        }
    }

    String message(Exception exception) {
        Serializable serializable;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.xmlFile).append(": ");
        String string = exception.getMessage();
        Locator locator = this.locator();
        int n2 = -1;
        int n3 = -1;
        String string2 = null;
        String string3 = null;
        if (exception instanceof SAXParseException) {
            serializable = (SAXParseException)exception;
            n2 = ((SAXParseException)serializable).getLineNumber();
            n3 = ((SAXParseException)serializable).getColumnNumber();
            string2 = ((SAXParseException)serializable).getPublicId();
            string3 = ((SAXParseException)serializable).getSystemId();
        } else if (locator != null) {
            n2 = locator.getLineNumber();
            n3 = locator.getColumnNumber();
            string2 = locator.getPublicId();
            string3 = locator.getSystemId();
        } else {
            stringBuffer.append(string);
            return stringBuffer.toString();
        }
        stringBuffer.append("(");
        serializable = new StringBuffer();
        if (string3 != null) {
            ((StringBuffer)serializable).append(string3).append(" uri");
        }
        if (string2 != null) {
            if (((StringBuffer)serializable).length() > 0) {
                ((StringBuffer)serializable).append(",");
            }
            ((StringBuffer)serializable).append(string2).append(" id");
        }
        if (this.lnum >= 1) {
            if (((StringBuffer)serializable).length() > 0) {
                ((StringBuffer)serializable).append(",");
            }
            ((StringBuffer)serializable).append(this.lnum).append(" line");
        } else if (n2 >= 0) {
            if (((StringBuffer)serializable).length() > 0) {
                ((StringBuffer)serializable).append(",");
            }
            ((StringBuffer)serializable).append(n2).append(" line");
        }
        if (n3 >= 0) {
            if (((StringBuffer)serializable).length() > 0) {
                ((StringBuffer)serializable).append(",");
            }
            ((StringBuffer)serializable).append(n3).append(" column");
        }
        stringBuffer.append(serializable);
        stringBuffer.append("): ");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator locator() {
        return this.locator;
    }

    class XmlFilter
    implements FilenameFilter {
        XmlFilter(Planer planer) {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".xml");
        }
    }

    class TableFilter
    implements FilenameFilter {
        TableFilter(Planer planer) {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".tab");
        }
    }
}

