package cern.lhcias.csgui.interfaces;

import java.util.*;
import cern.lhcias.csgui.rtdb.*;
import cern.lhcias.csgui.Services.*;

/**
*<br> A TagArray handles a set of Tags. The objects (typically the TagsView or the DataServer) 
*<br> willing to modify the value of a tag are requested to do so using a TagArrays object.
*<br> By doing so, the correct events will be send.
*<br> TagsView objects should use the method setValue. This method will send it, if necessary,
*<br> to the related DataServer.
*<br> DataServer objects should use the method updateValue which doesn't send it back 
*<br> to the network.
*<br> It it possible to set a default DataServer which will be used by all 
*<br> the remote tags which don't have a link to a specific DataServer.
*<br> 
*<br> If the value of a tag has been changed, a TagArray sends the TagChangeEvent.
*/
public interface TagArrays {
	void		init(String config);
	void        addConfig(String config);
	String		toString();
	
	boolean		beforeRefreshData();
	boolean		afterRefreshData();
	
	boolean		onRefreshError(String ErrorMsg);
    /**
    Returns true if there is at least one acquisition error
    */
	boolean		AcquisitionError();             
	String		getNamesOfTagsOnError();

    void        addTagChangeListener( TagChangeListener listener);
    void        removeTagChangeListener(TagChangeListener listener);
    void        addAlarmListener(AlarmListener listener);
    void        removeAlarmListener(AlarmListener listener);

    /**
    Set the default DataServer
    */
	void		setDataServerManager(DataServerManager ta);        
    /**
    Set the DataServer of Tag which processName is ProcessName
    */
    void        setDataServerInTags(String ProcessName); 
    void        setDataServerofTag(String tagName, String ProcessName);
    /**
    Add a tag
    */
	void		addTag(String tagName);            
    /**
    Remove a tag
    */
	void		deleteTag(String tagName);         
    /**
    Remove all tags
    */
	void		clear();                        
    /**
    Delete all Tags which are not in TagList       
    */
    void        cleanDataBase(Vector TagList);  

    /**
    Returns a vector of string containing the names of all the Tags 
    */
	Vector  	getTagNames();                  
    /**
    Returns a vector of string containing the names of all the Tags updated by DataServers
    */
	Vector  	getRemoteTagNames();
    /**
    Returns a vector of string containing the names of all the Tags updated by the DataServer ta 
    */
	Vector      getRemoteTagNames(DataServer ta);
    /**
    Returns a Vector of Tags
    */
    Vector      getTags();                      
	Vector      getRemoteTags(DataServer ta);
	int			getNumberOfTags();
	int			getNumberOfRemoteTags();
	int			getNumberOfRemoteTags(DataServer ta);
    /**
    Date of last modification in tags list
    */
	long		getDefinitionDate();            
    
	boolean		tagExist(String tagName);
    Tag         getTag(String tagName);
	void		updateValue(String tagName, String value);  // From remote
	void		updateValue(String tagName, String value, long date);
	void		updateInvalidValue(String tagName); 
	void		updateInvalidValue(String tagName, long date);
	void		setValue(String tagName, String value);   // Send to remote if necessary 
	void		setValue(String tagName, String value, long date);
}


