/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCButton;
import jclass.bwt.JCComponent;
import jclass.bwt.JCContainer;
import jclass.bwt.JCLabel;
import jclass.bwt.JCTextArea;
import jclass.bwt.JCTextComponent;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.customizer.JCBooleanEditor;
import jclass.chart.customizer.JCFieldEditor;
import jclass.chart.customizer.JCPropertyPage;
import jclass.chart.customizer.TestChart;
import jclass.util.JCVector;

public class DataViewLabelPage
extends JCPropertyPage
implements JCActionListener {
    JCTextArea pointLabelArea;
    JCButton applyPointLabels;
    JCTextArea setLabelArea;
    JCButton applySetLabels;
    JCBooleanEditor autoLabelCheck;
    JCFieldEditor otherSliceLabel;
    JCLabel otherSliceLabelLabel;
    ChartDataView view;

    public void init() {
        super.init();
        this.setLayout(new GridLayout(1, 3, 2, 1));
        JCContainer jCContainer = new JCContainer();
        jCContainer.setLayout(new BorderLayout(2, 2));
        jCContainer.add("North", new JCLabel("Series Labels:"));
        this.setLabelArea = new JCTextArea(null, 6, 20);
        this.setLabelArea.getTextComponent().setBackground(JCPropertyPage.textBG);
        this.setLabelArea.setScrollbarDisplay(0);
        jCContainer.add("Center", this.setLabelArea);
        this.applySetLabels = new JCButton("Apply");
        this.applySetLabels.addActionListener(this);
        jCContainer.add("South", this.applySetLabels);
        this.add(jCContainer);
        JCContainer jCContainer2 = new JCContainer();
        jCContainer2.setLayout(new BorderLayout(2, 2));
        jCContainer2.add("North", new JCLabel("Point Labels:"));
        this.pointLabelArea = new JCTextArea(null, 6, 20);
        this.pointLabelArea.getTextComponent().setBackground(JCPropertyPage.textBG);
        this.pointLabelArea.setScrollbarDisplay(0);
        jCContainer2.add("Center", this.pointLabelArea);
        this.applyPointLabels = new JCButton("Apply");
        this.applyPointLabels.addActionListener(this);
        jCContainer2.add("South", this.applyPointLabels);
        this.add(jCContainer2);
        JCContainer jCContainer3 = new JCContainer();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jCContainer3.setLayout(gridBagLayout);
        this.autoLabelCheck = new JCBooleanEditor("AutoLabel Data");
        this.autoLabelCheck.setInsets(new Insets(30, 2, 0, 0));
        this.autoLabelCheck.addPropertyChangeListener(this);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 12;
        gridBagLayout.setConstraints(this.autoLabelCheck, gridBagConstraints);
        jCContainer3.add(this.autoLabelCheck);
        this.otherSliceLabelLabel = new JCLabel("Other Slice Label:");
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.otherSliceLabelLabel, gridBagConstraints);
        jCContainer3.add(this.otherSliceLabelLabel);
        this.otherSliceLabel = new JCFieldEditor("", 25);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagLayout.setConstraints(this.otherSliceLabel, gridBagConstraints);
        this.otherSliceLabel.setBackground(JCPropertyPage.textBG);
        this.otherSliceLabel.addActionListener(this);
        jCContainer3.add(this.otherSliceLabel);
        this.add(jCContainer3);
    }

    private String arrayToText(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setObject(Object object) {
        if (object instanceof ChartDataView) {
            this.view = (ChartDataView)object;
        }
        if (this.view != null) {
            ChartDataViewSeries[] chartDataViewSeriesArray = this.view.getSeries();
            String[] stringArray = new String[this.view.getNumSeries()];
            int n = 0;
            while (n < this.view.getNumSeries()) {
                stringArray[n] = chartDataViewSeriesArray[n].getLabel();
                ++n;
            }
            this.setLabelArea.setText(this.arrayToText(stringArray));
            this.setLabelArea.showPosition(0);
            String string = this.arrayToText(this.view.getPointLabels());
            this.pointLabelArea.setText(string);
            this.pointLabelArea.showPosition(0);
            this.autoLabelCheck.setValue(new Boolean(this.view.getAutoLabel()));
            if (this.view.getChartType() == 11) {
                this.otherSliceLabel.enable();
                this.otherSliceLabelLabel.enable();
                this.otherSliceLabel.setValue(this.view.getPieChartFormat().getOtherLabel());
                return;
            }
            this.otherSliceLabel.setValue("");
            this.otherSliceLabel.disable();
            this.otherSliceLabelLabel.disable();
        }
    }

    public void propertyChanged(Object object, Object object2) {
        if (this.view == null || object2 == null) {
            return;
        }
        if (object == this.autoLabelCheck) {
            this.view.setAutoLabel((Boolean)object2);
        }
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        JCComponent jCComponent;
        if (this.view == null) {
            return;
        }
        if (jCActionEvent.getSource() instanceof JCButton) {
            jCComponent = (JCButton)jCActionEvent.getSource();
            if (jCComponent == this.applyPointLabels) {
                int n;
                String string = this.pointLabelArea.getText();
                int n2 = 0;
                JCVector jCVector = new JCVector();
                while ((n = string.indexOf(10, n2)) >= 0) {
                    if (n <= n2) {
                        ++n2;
                        continue;
                    }
                    jCVector.addElement(string.substring(n2, n));
                    n2 = n;
                }
                String[] stringArray = new String[jCVector.size()];
                int n3 = 0;
                while (n3 < jCVector.size()) {
                    stringArray[n3] = (String)jCVector.elementAt(n3);
                    ++n3;
                }
                this.view.setPointLabels(stringArray);
                this.setObject();
            } else if (jCComponent == this.applySetLabels) {
                int n;
                String string = this.setLabelArea.getText();
                int n4 = 0;
                int n5 = 0;
                while ((n = string.indexOf(10, n4)) >= 0) {
                    if (n <= n4) {
                        ++n4;
                        continue;
                    }
                    this.view.getSeries(n5).setLabel(string.substring(n4, n));
                    n4 = n;
                    ++n5;
                }
                this.setObject();
            }
        }
        if (jCActionEvent.getSource() instanceof JCFieldEditor) {
            jCComponent = (JCFieldEditor)jCActionEvent.getSource();
            if (this.view.getChartType() == 11) {
                this.view.getPieChartFormat().setOtherLabel(((JCTextComponent)jCComponent).getText());
            }
            this.setObject();
        }
    }

    public static void main(String[] stringArray) {
        String string = DataViewLabelPage.getPageName();
        JCPropertyPage jCPropertyPage = JCPropertyPage.getPage(string);
        jCPropertyPage.init();
        jCPropertyPage.launch();
        Frame frame = JCPropertyPage.getFrame(jCPropertyPage);
        frame.setTitle(DataViewLabelPage.getPageTitle());
        jCPropertyPage.setObject(new TestChart());
    }

    public static String getPageTitle() {
        return "ChartDataView Labels Page";
    }

    public static String getPageName() {
        return "DataViewLabelPage";
    }
}

