/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Version 1.0
 *
 * PRePTagArg: Tag for temporary stored arguments
 *             
 *             Arguments are given with two colons (e.g. {TAG::ARG1::ARG2})
 *
 * History: - Creation nh
 *
 * @author nh
 * @version 1.0
 * @see PRePTagText.java
 */
package com.delec.prep;
import java.io.*;
import java.util.*;

public class PRePTagArg extends PRePTagText {

  /**
   * @param String the name of the tag
   */
  public PRePTagArg(String sTagName) {
    super(sTagName);
  }

  /**
   * @param String the name of the tag (e.g. "ARG1")
   * @param String the value of the tag (e.g. "abc")
   * @param Session 
   */

  public PRePTagArg(String sTagName, String arg, Session session) {
    super(sTagName);
    if(arg.length() > 0 && arg.charAt(0) == '!')
      {
	//don't compile
	value = arg.substring(1);

        	
	if (value.indexOf('\n') != -1 ) {
	  value = value.substring(0, value.indexOf('\n'))+value.substring(value.indexOf('\n'));
	}
	if (value.indexOf('\r') != -1 ) {
	  value = value.substring(0, value.indexOf('\r'))+value.substring(value.indexOf('\r'));
	}
    }
    else
	{
	PRePTagText ptt = new PRePTagText("dummy");
	ptt.setValue(arg);
	StringWriter swriter = new StringWriter();
	
	PrintWriter pwOld = session.getPrintWriter();
	
	session.setPrintWriter(new PrintWriter(swriter)); 
	ptt.compile(session);
	value = swriter.toString();
	
	if (value.indexOf('\n') != -1 ) {
	  value = value.substring(0, value.indexOf('\n'))+value.substring(value.indexOf('\n'));
	}
	if (value.indexOf('\r') != -1 ) {
	  value = value.substring(0, value.indexOf('\r'))+value.substring(value.indexOf('\r'));
	}
	
	session.setPrintWriter(pwOld);
      }
  }
  
  /**
   * @param Session session includes the TagList and the PrintWriter
   */
  public void compile(Session session) {
    super.compile(session);
  }

}

