/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.ui.dialogs;

import com.jniwrapper.*;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.Kernel32;
import com.jniwrapper.win32.VersionInfo;

/**
 * This class represents OPENFILENAME structure (both Ansi and Unicode kinds)
 *
 * @author Serge Piletsky
 */
class OFNStructure extends Structure
{
    public static final char FILES_DELIMETER = '\t';

    private UInt32 _structureSize = new UInt32();
    private Handle _owner = new Handle();
    private Handle _instance = new Handle();
    private PrimitiveArray _filter;
    private ZeroTerminatedString _customFilter;
    private UInt32 _maxCustFilter = new UInt32();
    private UInt32 _filterIndex = new UInt32();
    private PrimitiveArray _file;
    private UInt32 _maxFile = new UInt32();
    private ZeroTerminatedString _fileTitle;
    private UInt32 _maxFileTitle = new UInt32();
    private ZeroTerminatedString _initialDir;
    private ZeroTerminatedString _title;
    private UInt32 _flags = new UInt32();
    private UInt16 _fileOffset = new UInt16();
    private UInt16 _fileExtension = new UInt16();
    private ZeroTerminatedString _defExt;
    private UInt32 _custData = new UInt32();
    private Callback _hook = null;
    private ZeroTerminatedString _templateName;
    private Pointer _reserved = new Pointer(null, true);
    private UInt32 _reservedFlags = new UInt32();
    private UInt32 _flagsEx = new UInt32();
    private boolean _unicode;

    static final char NATIVE_DELIMETER_SPACE = ' ';
    static final char NATIVE_DELIMETER_NULL = '\0';

    public OFNStructure(Callback hook, int maxFile)
    {
        _hook = hook;
        setMaxFile(maxFile);
        initStringParameters();
        VersionInfo versionInfo = new VersionInfo();
        if (versionInfo.isWin2k() | versionInfo.isWinMe())
        {

            init(new Parameter[]{_structureSize, _owner, _instance, new Pointer(_filter), new Pointer(_customFilter),
                _maxCustFilter, _filterIndex, new Pointer(_file), _maxFile, new Pointer(_fileTitle), _maxFileTitle,
                new Pointer(_initialDir), new Pointer(_title), _flags, _fileOffset, _fileExtension, new Pointer(_defExt),
                _custData, _hook, new Pointer(_templateName), _reserved, _reservedFlags, _flagsEx});
        }
        else
        {
            init(new Parameter[]{_structureSize, _owner, _instance, new Pointer(_filter), new Pointer(_customFilter),
                _maxCustFilter, _filterIndex, new Pointer(_file), _maxFile, new Pointer(_fileTitle), _maxFileTitle,
                new Pointer(_initialDir), new Pointer(_title), _flags, _fileOffset, _fileExtension, new Pointer(_defExt),
                _custData, _hook, new Pointer(_templateName)});
        }
        _structureSize.setValue(getLength());
    }

    private void initStringParameters()
    {
        final Kernel32 kernel32 = Kernel32.getInstance();
        _unicode = kernel32.isUnicode();
        if (_unicode)
        {
            _file = new PrimitiveArray(new WideChar(), (int)getMaxFile() + 2);
            _filter = new PrimitiveArray(new WideChar(), (int)getMaxFile() + 2);
        }
        else
        {
            _file = new PrimitiveArray(new Char(), (int)getMaxFile() + 2);
            _filter = new PrimitiveArray(new Char(), (int)getMaxFile() + 2);
        }
        _customFilter = kernel32.stringParam();
        _fileTitle = kernel32.stringParam();
        _initialDir = kernel32.stringParam();
        _title = kernel32.stringParam();
        _defExt = kernel32.stringParam();
        _templateName = kernel32.stringParam();
    }

    public Handle getOwner()
    {
        return _owner;
    }

    public void setOwner(Handle owner)
    {
        _owner.setValue(owner==null?0:owner.getValue());
    }

    public Handle getInstance()
    {
        return _instance;
    }

    public void setInstance(Handle instance)
    {
        _instance.setValue(instance==null?0:instance.getValue());
    }

    public void setFilter(StringBuffer filter)
    {
        for (int i = 0; i < filter.length(); i++)
        {
            final char c = filter.charAt(i);
            Parameter character = _unicode?
                    (Parameter)new WideChar(c):
                    (Parameter)new Char(c);
            _filter.setElement(i, character);
        }
    }

    public String getCustomFilter()
    {
        return _customFilter.getValue();
    }

    public void setCustomFilter(String customFilter)
    {
        _customFilter.setValue(customFilter);
    }

    public long getMaxCustFilter()
    {
        return _maxCustFilter.getValue();
    }

    public void setMaxCustFilter(long maxCustFilter)
    {
        _maxCustFilter.setValue(maxCustFilter);
    }

    public long getFilterIndex()
    {
        return _filterIndex.getValue();
    }

    public void setFilterIndex(long filterIndex)
    {
        _filterIndex.setValue(filterIndex);
    }

    public String getFile()
    {
        StringBuffer result = new StringBuffer();
        int elementCount = _file.getElementCount();
        boolean zero = false;
        for (int i = 0; i < elementCount; i++)
        {
            char c = _unicode? ((WideChar)_file.getElement(i)).getValue(): ((Char)_file.getElement(i)).getValue();
            if (zero && c == NATIVE_DELIMETER_NULL)
            {
                break;
            }
            if (c == NATIVE_DELIMETER_NULL)
            {
                zero = true;
                result.append(FILES_DELIMETER);
            }
            else
            {
                zero = false;
                result.append(c);
            }
        }
        return result.toString();
    }

    public void setFile(String file)
    {
        if (file.length() > _file.getLength())
            throw new IllegalArgumentException("File name length is greater than allowed");

        for (int i = 0; i < file.length(); i++)
        {
            final char c = file.charAt(i);
            Parameter character = _unicode?
                    (Parameter)new WideChar(c):
                    (Parameter)new Char(c);
            _file.setElement(i, character);
        }
        _file.setElement(file.length(), _unicode?
                    (Parameter)new WideChar():
                    (Parameter)new Char());
    }

    public long getMaxFile()
    {
        return _maxFile.getValue();
    }

    public void setMaxFile(long maxFile)
    {
        _maxFile.setValue(maxFile);
    }

    public String getFileTitle()
    {
        return _fileTitle.getValue();
    }

    public void setFileTitle(String fileTitle)
    {
        _fileTitle.setValue(fileTitle);
    }

    public long getMaxFileTitle()
    {
        return _maxFileTitle.getValue();
    }

    public void setMaxFileTitle(long maxFileTitle)
    {
        _maxFileTitle.setValue(maxFileTitle);
    }

    public String getInitialDir()
    {
        return _initialDir.getValue();
    }

    public void setInitialDir(String initialDir)
    {
        _initialDir.setValue(initialDir);
    }

    public String getTitle()
    {
        return _title.getValue();
    }

    public void setTitle(String title)
    {
        _title.setValue(title);
    }

    public long getFlags()
    {
        return _flags.getValue();
    }

    public void setFlags(long flags)
    {
        _flags.setValue(flags);
    }

    public long getFileOffset()
    {
        return _fileOffset.getValue();
    }

    public void setFileOffset(long fileOffset)
    {
        _fileOffset.setValue(fileOffset);
    }

    public long getFileExtension()
    {
        return _fileExtension.getValue();
    }

    public void setFileExtension(long fileExtension)
    {
        _fileExtension.setValue(fileExtension);
    }

    public String getDefExt()
    {
        return _defExt.getValue();
    }

    public void setDefExt(String defExt)
    {
        _defExt.setValue(defExt);
    }

    public long getCustData()
    {
        return _custData.getValue();
    }

    public void setCustData(long custData)
    {
        _custData.setValue(custData);
    }

    public Callback getHook()
    {
        return _hook;
    }

    public void setHook(Callback hook)
    {
        _hook = hook;
    }

    public String getTemplateName()
    {
        return _templateName.getValue();
    }

    public void setTemplateName(String templateName)
    {
        _templateName.setValue(templateName);
    }

    public long getFlagsEx()
    {
        return _flagsEx.getValue();
    }

    public void setFlagsEx(long flagsEx)
    {
        _flagsEx.setValue(flagsEx);
    }
}
