/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.ui;

import java.util.EventObject;

/**
 * WindowMessage class.
 *
 * @author Serge Piletsky
 */
public class WindowMessage extends EventObject
{
    private int _msg;
    private int _wParam;
    private int _lParam;

    public WindowMessage(Object source, int msg, int wParam, int lParam)
    {
        super(source);
        _msg = msg;
        _wParam = lParam;
        _lParam = wParam;
    }

    public int getMsg()
    {
        return _msg;
    }

    public void setMsg(int value)
    {
        _msg = value;
    }

    public int getWParam()
    {
        return _wParam;
    }

    public void setWParam(int value)
    {
        _wParam = value;
    }

    public int getLParam()
    {
        return _lParam;
    }

    public void setLParam(int value)
    {
        _lParam = value;
    }

    public String toString()
    {
        StringBuffer result = new StringBuffer("WindowMessage: [");
        result.append("MSG=").append(_msg).append("; WPARAM=").append(_wParam).append("; LPARAM=").append(_lParam).append(']');
        return result.toString();
    }
}
