/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt32;

/**
 * This class represents ICONINFO structure
 *
 * @author Serge Piletsky
 */
public class IconInfo extends Structure
{
    private Int _icon = new Int();
    private UInt32 _xHotSpot = new UInt32();
    private UInt32 _yHotSpot = new UInt32();
    private Bitmap _maskBitmap = new Bitmap();
    private Bitmap _colorBitmap = new Bitmap();

    public IconInfo()
    {
        init(new Parameter[]{_icon, _xHotSpot, _yHotSpot, _maskBitmap, _colorBitmap,});
    }

    public Bitmap getMaskBitmap()
    {
        return _maskBitmap;
    }

    public Bitmap getColorBitmap()
    {
        return _colorBitmap;
    }

    public boolean isIcon()
    {
        return _icon.getValue() != 0;
    }

    public boolean isCursor()
    {
        return !isIcon();
    }
}
