/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Int32;
import com.jniwrapper.Int8;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.ShortInt;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt16;
import com.jniwrapper.UInt32;
import com.jniwrapper.ZeroTerminatedString;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.gdi.DC;
import com.jniwrapper.win32.gdi.Region;
import com.jniwrapper.win32.ui.Msg;
import com.jniwrapper.win32.ui.PaintStruct;
import com.jniwrapper.win32.ui.User32;

public class Wnd
extends Handle {
    private static final FunctionName FUNCTION_FIND_WINDOW = new FunctionName("FindWindow");
    private static final FunctionName FUNCTION_CREATE_WINDOW_EX = new FunctionName("CreateWindowEx");
    private static final String FUNCTION_GET_DESKTOP_WINDOW = "GetDesktopWindow";
    private static final String FUNCTION_UPDATE_WINDOW = "UpdateWindow";
    private static final String FUNCTION_DESTROY_WINDOW = "DestroyWindow";
    private static final String FUNCTION_GET_WINDOW_RECT = "GetWindowRect";
    private static final String FUNCTION_GET_CLIENT_RECT = "GetClientRect";
    private static final String FUNCTION_SET_WINDOW_RGN = "SetWindowRgn";
    private static final String FUNCTION_GET_WINDOW_RGN = "GetWindowRgn";
    private static final String FUNCTION_SET_WINDOW_POS = "SetWindowPos";
    private static final String FUNCTION_MOVE_WINDOW = "MoveWindow";
    private static final String FUNCTION_BEGIN_PAINT = "BeginPaint";
    private static final String FUNCTION_END_PAINT = "EndPaint";
    private static final String FUNCTION_SHOW_WINDOW = "ShowWindow";
    private static final FunctionName FUNCTION_SET_WINDOW_LONG;
    private static final FunctionName FUNCTION_GET_WINDOW_LONG;
    private static final String FUNCTION_SET_LAYERED_WINDOW_ATTRIBUTES = "SetLayeredWindowAttributes";
    private static final String FUNCTION_REDRAW_WINDOW = "RedrawWindow";
    private static final FunctionName FUNCTION_SEND_MESSAGE;
    private static final String FUNCTION_SET_PARENT = "SetParent";
    private static final String FUNCTION_GET_PARENT = "GetParent";
    private static final String FUNCTION_BRING_WINDOW_TO_TOP = "BringWindowToTop";
    private static final FunctionName FUNCTION_CALL_WINDOW_PROC;
    private static final String FUNCTION_GET_UPDATE_RECT = "GetUpdateRect";
    public static final int WS_OVERLAPPED = 0;
    public static final int WS_POPUP = Integer.MIN_VALUE;
    public static final int WS_CHILD = 0x40000000;
    public static final int WS_MINIMIZE = 0x20000000;
    public static final int WS_VISIBLE = 0x10000000;
    public static final int WS_DISABLED = 0x8000000;
    public static final int WS_CLIPSIBLINGS = 0x4000000;
    public static final int WS_CLIPCHILDREN = 0x2000000;
    public static final int WS_MAXIMIZE = 0x1000000;
    public static final int WS_CAPTION = 0xC00000;
    public static final int WS_BORDER = 0x800000;
    public static final int WS_DLGFRAME = 0x400000;
    public static final int WS_VSCROLL = 0x200000;
    public static final int WS_HSCROLL = 0x100000;
    public static final int WS_SYSMENU = 524288;
    public static final int WS_THICKFRAME = 262144;
    public static final int WS_GROUP = 131072;
    public static final int WS_TABSTOP = 65536;
    public static final int WS_MINIMIZEBOX = 131072;
    public static final int WS_MAXIMIZEBOX = 65536;
    public static final int WS_OVERLAPPEDWINDOW = 0xCF0000;
    public static final int WS_POPUPWINDOW = -2138570752;
    public static final int WS_CHILDWINDOW = 0x40000000;
    public static final int WS_TILED = 0;
    public static final int WS_ICONIC = 0x20000000;
    public static final int WS_SIZEBOX = 262144;
    public static final int WS_TILEDWINDOW = 0xCF0000;
    public static final int WS_EX_DLGMODALFRAME = 1;
    public static final int WS_EX_NOPARENTNOTIFY = 4;
    public static final int WS_EX_TOPMOST = 8;
    public static final int WS_EX_ACCEPTFILES = 16;
    public static final int WS_EX_TRANSPARENT = 32;
    public static final int WS_EX_MDICHILD = 64;
    public static final int WS_EX_TOOLWINDOW = 128;
    public static final int WS_EX_WINDOWEDGE = 256;
    public static final int WS_EX_CLIENTEDGE = 512;
    public static final int WS_EX_CONTEXTHELP = 1024;
    public static final int WS_EX_RIGHT = 4096;
    public static final int WS_EX_LEFT = 0;
    public static final int WS_EX_RTLREADING = 8192;
    public static final int WS_EX_LTRREADING = 0;
    public static final int WS_EX_LEFTSCROLLBAR = 16384;
    public static final int WS_EX_RIGHTSCROLLBAR = 0;
    public static final int WS_EX_CONTROLPARENT = 65536;
    public static final int WS_EX_STATICEDGE = 131072;
    public static final int WS_EX_APPWINDOW = 262144;
    public static final int WS_EX_OVERLAPPEDWINDOW = 768;
    public static final int WS_EX_PALETTEWINDOW = 392;
    public static final int WS_EX_LAYERED = 524288;
    public static final int LWA_ALPHA = 2;
    public static final int SWP_NOSIZE = 1;
    public static final int SWP_NOMOVE = 2;
    public static final int SWP_NOZORDER = 4;
    public static final int SWP_NOREDRAW = 8;
    public static final int SWP_NOACTIVATE = 16;
    public static final int SWP_FRAMECHANGED = 32;
    public static final int SWP_SHOWWINDOW = 64;
    public static final int SWP_HIDEWINDOW = 128;
    public static final int SWP_NOCOPYBITS = 256;
    public static final int SWP_NOOWNERZORDER = 512;
    public static final int SWP_NOSENDCHANGING = 1024;
    public static final int SWP_DRAWFRAME = 32;
    public static final int SWP_NOREPOSITION = 512;
    public static final int SWP_DEFERERASE = 8192;
    public static final int SWP_ASYNCWINDOWPOS = 16384;
    public static final int HWND_TOP = 0;
    public static final int HWND_BOTTOM = 1;
    public static final int HWND_TOPMOST = -1;
    public static final int HWND_NOTOPMOST = -2;
    public static final int GWL_WNDPROC = -4;
    public static final int GWL_HINSTANCE = -6;
    public static final int GWL_HWNDPARENT = -8;
    public static final int GWL_STYLE = -16;
    public static final int GWL_EXSTYLE = -20;
    public static final int GWL_USERDATA = -21;
    public static final int GWL_ID = -12;
    public static final int RDW_INVALIDATE = 1;
    public static final int RDW_INTERNALPAINT = 2;
    public static final int RDW_ERASE = 4;
    public static final int RDW_VALIDATE = 8;
    public static final int RDW_NOINTERNALPAINT = 16;
    public static final int RDW_NOERASE = 32;
    public static final int RDW_NOCHILDREN = 64;
    public static final int RDW_ALLCHILDREN = 128;
    public static final int RDW_UPDATENOW = 256;
    public static final int RDW_ERASENOW = 512;
    public static final int RDW_FRAME = 1024;
    public static final int RDW_NOFRAME = 2048;
    public static final int SW_HIDE = 0;
    public static final int SW_SHOWNORMAL = 1;
    public static final int SW_NORMAL = 1;
    public static final int SW_SHOWMINIMIZED = 2;
    public static final int SW_SHOWMAXIMIZED = 3;
    public static final int SW_MAXIMIZE = 3;
    public static final int SW_SHOWNOACTIVATE = 4;
    public static final int SW_SHOW = 5;
    public static final int SW_MINIMIZE = 6;
    public static final int SW_SHOWMINNOACTIVE = 7;
    public static final int SW_SHOWNA = 8;
    public static final int SW_RESTORE = 9;
    public static final int SW_SHOWDEFAULT = 10;
    public static final int SW_FORCEMINIMIZE = 11;
    public static final int SW_MAX = 11;

    public Wnd() {
    }

    public Wnd(long value) {
        super(value);
    }

    static Function getFunction(Object functionName) {
        return User32.getInstance().getFunction(functionName.toString());
    }

    public void eventLoop() {
        Wnd.eventLoop(this.getValue());
    }

    public static void eventLoop(long hwnd) {
        if (hwnd == 0L) {
            throw new IllegalArgumentException("Event processing window is not available");
        }
        Function getMessage = Wnd.getFunction(User32.FUNCTION_GET_MESSAGE);
        Function translateMessage = Wnd.getFunction("TranslateMessage");
        Function dispatchMessage = Wnd.getFunction(User32.FUNCTION_DISPATCH_MESSAGE);
        Wnd hWnd = new Wnd(hwnd);
        ShortInt result = new ShortInt(1L);
        Msg msg = new Msg();
        UInt32 nullValue = new UInt32(0L);
        while (result.getValue() != 0L) {
            Pointer msgPointer = new Pointer((Parameter)msg);
            getMessage.invoke((Parameter)result, (Parameter)msgPointer, (Parameter)hWnd, (Parameter)nullValue, (Parameter)nullValue);
            if (result.getValue() == -1L) break;
            translateMessage.invoke(null, (Parameter)msgPointer);
            dispatchMessage.invoke(null, (Parameter)msgPointer);
        }
    }

    public static Wnd findWindow(String className, String windowName) {
        Function function = Wnd.getFunction(FUNCTION_FIND_WINDOW);
        Wnd result = new Wnd();
        Handle wndName = windowName == null ? new Handle() : User32.getInstance().stringParam(windowName);
        ZeroTerminatedString cName = User32.getInstance().stringParam(className);
        function.invoke((Parameter)result, (Parameter)new Pointer((Parameter)cName), (Parameter)new Pointer((Parameter)wndName));
        return result;
    }

    public static Wnd findWindow(String className) {
        return Wnd.findWindow(className, null);
    }

    public static Wnd getDesktopWindow() {
        Function function = Wnd.getFunction(FUNCTION_GET_DESKTOP_WINDOW);
        Wnd result = new Wnd();
        function.invoke((Parameter)result);
        return result;
    }

    private static Wnd createWindow(Object functionName, Parameter[] parameters) {
        Wnd result = new Wnd();
        Function function = Wnd.getFunction(functionName);
        function.invoke((Parameter)result, parameters);
        if (result.getValue() == 0L) {
            throw new LastErrorException("Cannot create window.");
        }
        return result;
    }

    public static Wnd createWindow(String className, String windowName, int windowStyle, long x, long y, long nWidth, long nHeight, Wnd hWndParent, Handle hMenu, Handle hInstance, Handle lpParam) {
        return Wnd.createWindow(FUNCTION_CREATE_WINDOW_EX, new Parameter[]{new UInt(0L), new Pointer((Parameter)User32.getInstance().stringParam(className)), new Pointer((Parameter)User32.getInstance().stringParam(windowName)), new Int((long)windowStyle), new Int(x), new Int(y), new Int(nWidth), new Int(nHeight), hWndParent, hMenu, hInstance, lpParam});
    }

    public static Wnd createWindow(int windowStyleEx, String className, String windowName, int windowStyle, long x, long y, long nWidth, long nHeight, Wnd hWndParent, Handle hMenu, Handle hInstance, Handle lpParam) {
        return Wnd.createWindow(FUNCTION_CREATE_WINDOW_EX, new Parameter[]{new Int32(windowStyleEx), new Pointer((Parameter)User32.getInstance().stringParam(className)), new Pointer((Parameter)User32.getInstance().stringParam(windowName)), new Int((long)windowStyle), new Int(x), new Int(y), new Int(nWidth), new Int(nHeight), hWndParent, hMenu, hInstance, lpParam});
    }

    public static Wnd createWindow(String className) {
        Handle NULL = new Handle();
        Wnd parent = new Wnd();
        return Wnd.createWindow(0, className, className, 0, 0L, 0L, 0L, 0L, parent, NULL, NULL, NULL);
    }

    public void update() {
        Function function = Wnd.getFunction(FUNCTION_UPDATE_WINDOW);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)this);
        if (result.getValue() == 0L) {
            throw new LastErrorException("Error updating window.");
        }
    }

    public void destroy() {
        Function function = Wnd.getFunction(FUNCTION_DESTROY_WINDOW);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)this);
        if (result.getValue() == 0L) {
            throw new LastErrorException("Error destroying window.");
        }
    }

    public static void getWindowRect(Wnd handle, Int width, Int height) {
        Wnd.getWindowRect(handle, new Int(), new Int(), width, height);
    }

    public static void getWindowRect(Wnd handle, Int top, Int left, Int width, Int height) {
        Function function = Wnd.getFunction(FUNCTION_GET_WINDOW_RECT);
        function.invoke(null, (Parameter)handle, (Parameter)new Pointer.OutOnly((Parameter)new Structure(new Parameter[]{top, left, width, height})));
    }

    public static void getWindowRect(Wnd handle, Rect rect) {
        Function function = Wnd.getFunction(FUNCTION_GET_WINDOW_RECT);
        function.invoke(null, (Parameter)handle, (Parameter)new Pointer.OutOnly((Parameter)rect));
    }

    public static void centerWindow(Wnd handle) {
        Rect desktop = new Rect();
        Wnd.getWindowRect(Wnd.getDesktopWindow(), desktop);
        Rect windowRect = new Rect();
        Wnd.getWindowRect(handle, windowRect);
        long deltaX = (desktop.getRight() - windowRect.getRight() - windowRect.getLeft()) / 2L;
        long deltaY = (desktop.getBottom() - windowRect.getBottom() - windowRect.getTop()) / 2L;
        windowRect.moveBy((int)deltaX, (int)deltaY);
        Wnd.setWindowPos(handle, new Wnd(0L), windowRect.getLeft(), windowRect.getTop(), windowRect.getRight(), windowRect.getBottom(), 21L);
    }

    public static boolean getClientRect(Wnd handle, Rect rect) {
        Int result = new Int();
        Function function = Wnd.getFunction(FUNCTION_GET_CLIENT_RECT);
        function.invoke((Parameter)result, (Parameter)handle, (Parameter)new Pointer.OutOnly((Parameter)rect));
        return result.getValue() > 0L;
    }

    public static void setWindowRgn(Wnd hWnd, Region hRgn, boolean bRedraw) {
        Function function = Wnd.getFunction(FUNCTION_SET_WINDOW_RGN);
        function.invoke(null, (Parameter)hWnd, (Parameter)(hRgn == null ? new Handle() : hRgn), (Parameter)new Bool(bRedraw));
    }

    public void setWindowRegion(Region region) {
        Wnd.setWindowRgn(this, region, true);
    }

    public static Region getWindowRgn(Wnd hWnd) {
        Region result = new Region();
        Function function = Wnd.getFunction(FUNCTION_GET_WINDOW_RGN);
        function.invoke(null, (Parameter)hWnd, (Parameter)result);
        return result;
    }

    public static boolean setWindowPos(Wnd hWnd, Wnd hWndInsertAfter, long x, long y, long cx, long cy, long flags) {
        Function function = Wnd.getFunction(FUNCTION_SET_WINDOW_POS);
        Bool result = new Bool();
        function.invoke((Parameter)result, new Parameter[]{hWnd, hWndInsertAfter, new Int(x), new Int(y), new Int(cx), new Int(cy), new UInt(flags)});
        return result.getValue();
    }

    public DC beginPaint(PaintStruct paintStruct) {
        Function beginPaint = Wnd.getFunction(FUNCTION_BEGIN_PAINT);
        DC result = new DC();
        beginPaint.invoke((Parameter)result, (Parameter)this, (Parameter)new Pointer.OutOnly((Parameter)paintStruct));
        if (result.isNull()) {
            throw new LastErrorException("Failed to get DC.", true);
        }
        return result;
    }

    public void endPaint(PaintStruct paintStruct) {
        Function endPaint = User32.getInstance().getFunction(FUNCTION_END_PAINT);
        endPaint.invoke(null, (Parameter)this, (Parameter)new Pointer.Const((Parameter)paintStruct));
    }

    public boolean sendMessage(int msg, int wParam, int lParam) {
        Function sendMessage = Wnd.getFunction(FUNCTION_SEND_MESSAGE);
        Bool result = new Bool();
        sendMessage.invoke((Parameter)result, (Parameter)this, (Parameter)new UInt((long)msg), (Parameter)new UInt16(wParam), (Parameter)new UInt16(lParam));
        return result.getValue();
    }

    public void show(int nCmdShow) {
        Function show = Wnd.getFunction(FUNCTION_SHOW_WINDOW);
        show.invoke(null, (Parameter)this, (Parameter)new Int((long)nCmdShow));
    }

    public void setWindowLong(int nIndex, long dwNewLong) {
        this.setWindowLong(nIndex, (Parameter)new UInt(dwNewLong));
    }

    public long setWindowLong(int nIndex, Parameter newValue) {
        UInt result = new UInt();
        Function setWindowLong = Wnd.getFunction(FUNCTION_SET_WINDOW_LONG);
        setWindowLong.invoke((Parameter)result, (Parameter)this, (Parameter)new Int((long)nIndex), newValue);
        return result.getValue();
    }

    public long getWindowLong(int nIndex) {
        Function getWindowLong = Wnd.getFunction(FUNCTION_GET_WINDOW_LONG);
        UInt result = new UInt();
        getWindowLong.invoke((Parameter)result, (Parameter)this, (Parameter)new Int((long)nIndex));
        return result.getValue();
    }

    public void setLayeredWindowAttributes(int crKey, byte bAlpha, int dwFlags) {
        Function setLayeredWindowAttr = Wnd.getFunction(FUNCTION_SET_LAYERED_WINDOW_ATTRIBUTES);
        setLayeredWindowAttr.invoke(null, (Parameter)this, (Parameter)new Int((long)crKey), (Parameter)new Int8(bAlpha), (Parameter)new UInt((long)dwFlags));
    }

    public void redraw(Handle lprcUpdate, Handle hrgnUpdate, int flags) {
        Function redrawWindow = Wnd.getFunction(FUNCTION_REDRAW_WINDOW);
        redrawWindow.invoke(null, (Parameter)this, (Parameter)lprcUpdate, (Parameter)hrgnUpdate, (Parameter)new UInt((long)flags));
    }

    public void setParent(Wnd parent) {
        Function setParent = Wnd.getFunction(FUNCTION_SET_PARENT);
        setParent.invoke(null, (Parameter)this, (Parameter)parent);
    }

    public Wnd getParent() {
        Function getParent = Wnd.getFunction(FUNCTION_GET_PARENT);
        Wnd result = new Wnd();
        getParent.invoke((Parameter)result, (Parameter)this);
        return result;
    }

    public void bringToTop() {
        Function function = Wnd.getFunction(FUNCTION_BRING_WINDOW_TO_TOP);
        function.invoke(null, (Parameter)this);
    }

    public static long callWindowProc(Handle wndProc, Wnd wnd, UInt msg, UInt32 wParam, UInt32 lParam) {
        Function function = Wnd.getFunction(FUNCTION_CALL_WINDOW_PROC);
        UInt32 result = new UInt32();
        function.invoke((Parameter)result, new Parameter[]{wndProc, wnd, msg, wParam, lParam});
        return result.getValue();
    }

    public static boolean moveWindow(Wnd wnd, int x, int y, int width, int height, boolean repaint) {
        Function function = Wnd.getFunction(FUNCTION_MOVE_WINDOW);
        Bool result = new Bool();
        function.invoke((Parameter)result, new Parameter[]{wnd, new Int((long)x), new Int((long)y), new Int((long)width), new Int((long)height), new Bool(repaint)});
        return result.getValue();
    }

    public boolean moveWindow(int x, int y, int width, int height, boolean repaint) {
        return Wnd.moveWindow(this, x, y, width, height, repaint);
    }

    public boolean moveWindow(int x, int y, int width, int height) {
        return Wnd.moveWindow(this, x, y, width, height, false);
    }

    public static boolean getUpdateRect(Wnd wnd, Rect rect, boolean erase) {
        Function function = Wnd.getFunction(FUNCTION_GET_UPDATE_RECT);
        Bool result = new Bool();
        function.invoke((Parameter)result, (Parameter)wnd, (Parameter)new Pointer.OutOnly((Parameter)rect), (Parameter)new Bool(erase));
        return result.getValue();
    }

    public boolean getUpdateRect(Rect rect, boolean erase) {
        return Wnd.getUpdateRect(this, rect, erase);
    }

    public boolean getUpdateRect(Rect rect) {
        return Wnd.getUpdateRect(this, rect, false);
    }

    static {
        FUNCTION_GET_DESKTOP_WINDOW = FUNCTION_GET_DESKTOP_WINDOW;
        FUNCTION_UPDATE_WINDOW = FUNCTION_UPDATE_WINDOW;
        FUNCTION_DESTROY_WINDOW = FUNCTION_DESTROY_WINDOW;
        FUNCTION_GET_WINDOW_RECT = FUNCTION_GET_WINDOW_RECT;
        FUNCTION_GET_CLIENT_RECT = FUNCTION_GET_CLIENT_RECT;
        FUNCTION_SET_WINDOW_RGN = FUNCTION_SET_WINDOW_RGN;
        FUNCTION_GET_WINDOW_RGN = FUNCTION_GET_WINDOW_RGN;
        FUNCTION_SET_WINDOW_POS = FUNCTION_SET_WINDOW_POS;
        FUNCTION_MOVE_WINDOW = FUNCTION_MOVE_WINDOW;
        FUNCTION_BEGIN_PAINT = FUNCTION_BEGIN_PAINT;
        FUNCTION_END_PAINT = FUNCTION_END_PAINT;
        FUNCTION_SHOW_WINDOW = FUNCTION_SHOW_WINDOW;
        FUNCTION_SET_WINDOW_LONG = new FunctionName("SetWindowLong");
        FUNCTION_GET_WINDOW_LONG = new FunctionName("GetWindowLong");
        FUNCTION_SET_LAYERED_WINDOW_ATTRIBUTES = FUNCTION_SET_LAYERED_WINDOW_ATTRIBUTES;
        FUNCTION_REDRAW_WINDOW = FUNCTION_REDRAW_WINDOW;
        FUNCTION_SEND_MESSAGE = new FunctionName("SendMessage");
        FUNCTION_SET_PARENT = FUNCTION_SET_PARENT;
        FUNCTION_GET_PARENT = FUNCTION_GET_PARENT;
        FUNCTION_BRING_WINDOW_TO_TOP = FUNCTION_BRING_WINDOW_TO_TOP;
        FUNCTION_CALL_WINDOW_PROC = new FunctionName("CallWindowProc");
        FUNCTION_GET_UPDATE_RECT = FUNCTION_GET_UPDATE_RECT;
        WS_OVERLAPPED = 0;
        WS_POPUP = Integer.MIN_VALUE;
        WS_CHILD = 0x40000000;
        WS_MINIMIZE = 0x20000000;
        WS_VISIBLE = 0x10000000;
        WS_DISABLED = 0x8000000;
        WS_CLIPSIBLINGS = 0x4000000;
        WS_CLIPCHILDREN = 0x2000000;
        WS_MAXIMIZE = 0x1000000;
        WS_CAPTION = 0xC00000;
        WS_BORDER = 0x800000;
        WS_DLGFRAME = 0x400000;
        WS_VSCROLL = 0x200000;
        WS_HSCROLL = 0x100000;
        WS_SYSMENU = 524288;
        WS_THICKFRAME = 262144;
        WS_GROUP = 131072;
        WS_TABSTOP = 65536;
        WS_MINIMIZEBOX = 131072;
        WS_MAXIMIZEBOX = 65536;
        WS_OVERLAPPEDWINDOW = 0xCF0000;
        WS_POPUPWINDOW = -2138570752;
        WS_CHILDWINDOW = 0x40000000;
        WS_TILED = 0;
        WS_ICONIC = 0x20000000;
        WS_SIZEBOX = 262144;
        WS_TILEDWINDOW = 0xCF0000;
        WS_EX_DLGMODALFRAME = 1;
        WS_EX_NOPARENTNOTIFY = 4;
        WS_EX_TOPMOST = 8;
        WS_EX_ACCEPTFILES = 16;
        WS_EX_TRANSPARENT = 32;
        WS_EX_MDICHILD = 64;
        WS_EX_TOOLWINDOW = 128;
        WS_EX_WINDOWEDGE = 256;
        WS_EX_CLIENTEDGE = 512;
        WS_EX_CONTEXTHELP = 1024;
        WS_EX_RIGHT = 4096;
        WS_EX_LEFT = 0;
        WS_EX_RTLREADING = 8192;
        WS_EX_LTRREADING = 0;
        WS_EX_LEFTSCROLLBAR = 16384;
        WS_EX_RIGHTSCROLLBAR = 0;
        WS_EX_CONTROLPARENT = 65536;
        WS_EX_STATICEDGE = 131072;
        WS_EX_APPWINDOW = 262144;
        WS_EX_OVERLAPPEDWINDOW = 768;
        WS_EX_PALETTEWINDOW = 392;
        WS_EX_LAYERED = 524288;
        LWA_ALPHA = 2;
        SWP_NOSIZE = 1;
        SWP_NOMOVE = 2;
        SWP_NOZORDER = 4;
        SWP_NOREDRAW = 8;
        SWP_NOACTIVATE = 16;
        SWP_FRAMECHANGED = 32;
        SWP_SHOWWINDOW = 64;
        SWP_HIDEWINDOW = 128;
        SWP_NOCOPYBITS = 256;
        SWP_NOOWNERZORDER = 512;
        SWP_NOSENDCHANGING = 1024;
        SWP_DRAWFRAME = 32;
        SWP_NOREPOSITION = 512;
        SWP_DEFERERASE = 8192;
        SWP_ASYNCWINDOWPOS = 16384;
        HWND_TOP = 0;
        HWND_BOTTOM = 1;
        HWND_TOPMOST = -1;
        HWND_NOTOPMOST = -2;
        GWL_WNDPROC = -4;
        GWL_HINSTANCE = -6;
        GWL_HWNDPARENT = -8;
        GWL_STYLE = -16;
        GWL_EXSTYLE = -20;
        GWL_USERDATA = -21;
        GWL_ID = -12;
        RDW_INVALIDATE = 1;
        RDW_INTERNALPAINT = 2;
        RDW_ERASE = 4;
        RDW_VALIDATE = 8;
        RDW_NOINTERNALPAINT = 16;
        RDW_NOERASE = 32;
        RDW_NOCHILDREN = 64;
        RDW_ALLCHILDREN = 128;
        RDW_UPDATENOW = 256;
        RDW_ERASENOW = 512;
        RDW_FRAME = 1024;
        RDW_NOFRAME = 2048;
        SW_HIDE = 0;
        SW_SHOWNORMAL = 1;
        SW_NORMAL = 1;
        SW_SHOWMINIMIZED = 2;
        SW_SHOWMAXIMIZED = 3;
        SW_MAXIMIZE = 3;
        SW_SHOWNOACTIVATE = 4;
        SW_SHOW = 5;
        SW_MINIMIZE = 6;
        SW_SHOWMINNOACTIVE = 7;
        SW_SHOWNA = 8;
        SW_RESTORE = 9;
        SW_SHOWDEFAULT = 10;
        SW_FORCEMINIMIZE = 11;
        SW_MAX = 11;
    }
}

