/*
 * Decompiled with CFR 0.152.
 */
package jdbees;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;

public class JDBeesIntro
extends JPanel {
    static Color black = new Color(20, 20, 20);
    static Color white = new Color(240, 240, 255);
    static Color red = new Color(149, 43, 42);
    static Color blue = new Color(94, 105, 176);
    static Color yellow = new Color(255, 255, 140);
    static Surface surface;

    public JDBeesIntro() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.gray);
        surface = new Surface();
        this.add(surface);
    }

    public void start() {
        surface.start();
    }

    public void stop() {
        surface.stop();
    }

    static class Surface
    extends JPanel
    implements Runnable {
        static Surface surf;
        static BufferedImage bimg;
        public Director director;
        public int index;
        public long sleepAmt = 30L;
        private Thread thread;

        public Surface() {
            surf = this;
            this.setBackground(black);
            this.setLayout(new BorderLayout());
            this.director = new Director();
            this.index = 0;
        }

        static FontMetrics getMetrics(Font font) {
            return surf.getFontMetrics(font);
        }

        public void paint(Graphics g) {
            Dimension d = this.getSize();
            if (bimg == null || bimg.getWidth() != d.width || bimg.getHeight() != d.height) {
                bimg = (BufferedImage)this.createImage(d.width, d.height);
                int i = this.index + 1;
                while (i < this.director.size()) {
                    ((Scene)this.director.get(i)).reset(d.width, d.height);
                    ++i;
                }
            }
            Scene scene = (Scene)this.director.get(this.index);
            if (scene.index <= scene.length) {
                if (this.thread != null) {
                    scene.step(d.width, d.height);
                }
                Graphics2D g2 = bimg.createGraphics();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setBackground(this.getBackground());
                g2.clearRect(0, 0, d.width, d.height);
                scene.render(d.width, d.height, g2);
                if (this.thread != null) {
                    ++scene.index;
                }
                g2.dispose();
            }
            g.drawImage(bimg, 0, 0, this);
        }

        public void start() {
            if (this.thread == null) {
                this.thread = new Thread(this);
                this.thread.setPriority(1);
                this.thread.setName("JDBeesIntro");
                this.thread.start();
            }
        }

        public synchronized void stop() {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = null;
            this.notifyAll();
        }

        public void reset() {
            this.index = 0;
            Dimension d = this.getSize();
            int i = 0;
            while (i < this.director.size()) {
                ((Scene)this.director.get(i)).reset(d.width, d.height);
                ++i;
            }
        }

        public void run() {
            Thread me = Thread.currentThread();
            while (this.thread == me && !this.isShowing() || this.getSize().width <= 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            if (this.index == 0) {
                this.reset();
            }
            while (this.thread == me) {
                Scene scene = (Scene)this.director.get(this.index);
                if (((Boolean)scene.participate).booleanValue()) {
                    this.repaint();
                    try {
                        Thread.sleep(this.sleepAmt);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    if (scene.index <= scene.length) continue;
                    scene.pause(this.thread);
                    if (++this.index < this.director.size()) continue;
                    this.reset();
                    continue;
                }
                if (++this.index < this.director.size()) continue;
                this.reset();
            }
            this.thread = null;
        }

        static class LnE
        implements Part {
            static final int INC = 1;
            static final int DEC = 2;
            static final int R = 4;
            static final int RI = 5;
            static final int RD = 6;
            static final int ZOOM = 8;
            static final int ZOOMI = 9;
            static final int ZOOMD = 10;
            static final int AC = 32;
            static final int ACI = 33;
            static final int ACD = 34;
            private int beginning;
            private int ending;
            private double rIncr;
            private double rotate;
            private double zIncr;
            private double zoom;
            private Vector pts = new Vector();
            private float alpha;
            private float aIncr;
            private int type;

            public LnE(int type, int beg, int end) {
                this.type = type;
                this.beginning = beg;
                this.ending = end;
                this.rIncr = 360.0 / (double)(this.ending - this.beginning);
                this.aIncr = 0.9f / (float)(this.ending - this.beginning);
                this.zIncr = 2.0 / (double)(this.ending - this.beginning);
                if ((type & 2) != 0) {
                    this.rIncr = -this.rIncr;
                    this.aIncr = -this.aIncr;
                    this.zIncr = -this.zIncr;
                }
            }

            public void generatePts(int w, int h, double sizeF) {
                this.pts.clear();
                double size = (double)Math.min(w, h) * sizeF;
                Ellipse2D.Double ellipse = new Ellipse2D.Double((double)(w / 2) - size / 2.0, (double)(h / 2) - size / 2.0, size, size);
                PathIterator pi = ellipse.getPathIterator(null, 0.8);
                while (!pi.isDone()) {
                    double[] pt = new double[6];
                    switch (pi.currentSegment(pt)) {
                        case 0: 
                        case 1: {
                            this.pts.addElement(new Point2D.Double(pt[0], pt[1]));
                        }
                    }
                    pi.next();
                }
            }

            public void reset(int w, int h) {
                if ((this.type & 2) != 0) {
                    this.rotate = 360.0;
                    this.alpha = 1.0f;
                    this.zoom = 2.0;
                } else {
                    this.alpha = 0.0f;
                    this.rotate = 0.0f;
                    this.zoom = 0.0;
                }
                if ((this.type & 8) == 0) {
                    this.generatePts(w, h, 0.5);
                }
            }

            public void step(int w, int h) {
                if ((this.type & 8) != 0) {
                    this.generatePts(w, h, this.zoom += this.zIncr);
                }
                if ((this.type & 5) != 0 || (this.type & 5) != 0) {
                    this.rotate += this.rIncr;
                }
                if ((this.type & 0x21) != 0 || (this.type & 0x22) != 0) {
                    this.alpha += this.aIncr;
                }
            }

            public void render(int w, int h, Graphics2D g2) {
                Composite saveAC = null;
                if ((this.type & 0x20) != 0 && this.alpha >= 0.0f && this.alpha <= 1.0f) {
                    saveAC = g2.getComposite();
                    g2.setComposite(AlphaComposite.getInstance(3, this.alpha));
                }
                AffineTransform saveTx = null;
                if ((this.type & 4) != 0) {
                    saveTx = g2.getTransform();
                    AffineTransform at = new AffineTransform();
                    at.rotate(Math.toRadians(this.rotate), w / 2, h / 2);
                    g2.setTransform(at);
                }
                Point2D.Double p1 = new Point2D.Double(w / 2, h / 2);
                g2.setColor(Color.yellow);
                int i = 0;
                while (i < this.pts.size() - 1) {
                    g2.draw(new Line2D.Float(p1, (Point2D)this.pts.get(i)));
                    ++i;
                }
                if (saveTx != null) {
                    g2.setTransform(saveTx);
                }
                if (saveAC != null) {
                    g2.setComposite(saveAC);
                }
            }

            public int getBegin() {
                return this.beginning;
            }

            public int getEnd() {
                return this.ending;
            }

            static {
                INC = 1;
                DEC = 2;
                R = 4;
                RI = 5;
                RD = 6;
                ZOOM = 8;
                ZOOMI = 9;
                ZOOMD = 10;
                AC = 32;
                ACI = 33;
                ACD = 34;
            }
        }

        static class SiE
        implements Part {
            private int beginning;
            private int ending;
            private BufferedImage bimg;
            private double rIncr;
            private double sIncr;
            private double scale;
            private double rotate;
            private int siw;
            private int sih;
            private Vector subs = new Vector(20);
            private Vector pts = new Vector(20);

            public SiE(int siw, int sih, int beg, int end) {
                this.siw = siw;
                this.sih = sih;
                this.beginning = beg;
                this.ending = end;
                this.rIncr = 360.0 / (double)(this.ending - this.beginning);
                this.sIncr = 1.0 / (double)(this.ending - this.beginning);
            }

            public void reset(int w, int h) {
                this.scale = 1.0;
                this.rotate = 0.0;
                this.bimg = null;
                this.subs.clear();
                this.pts.clear();
            }

            public void step(int w, int h) {
                if (this.bimg == null) {
                    int biw = bimg.getWidth();
                    int bih = bimg.getHeight();
                    this.bimg = new BufferedImage(biw, bih, 1);
                    Graphics2D big = this.bimg.createGraphics();
                    big.drawImage((Image)bimg, 0, 0, null);
                    int x = 0;
                    while (x < w && this.scale > 0.0) {
                        int ww = x + this.siw < w ? this.siw : w - x;
                        int y = 0;
                        while (y < h) {
                            int hh = y + this.sih < h ? this.sih : h - y;
                            this.subs.addElement(this.bimg.getSubimage(x, y, ww, hh));
                            this.pts.addElement(new Point(x, y));
                            y += this.sih;
                        }
                        x += this.siw;
                    }
                }
                this.rotate += this.rIncr;
                this.scale -= this.sIncr;
            }

            public void render(int w, int h, Graphics2D g2) {
                AffineTransform saveTx = g2.getTransform();
                g2.setColor(blue);
                int i = 0;
                while (i < this.subs.size() && this.scale > 0.0) {
                    BufferedImage bi = (BufferedImage)this.subs.get(i);
                    Point p = (Point)this.pts.get(i);
                    int ww = bi.getWidth();
                    int hh = bi.getHeight();
                    AffineTransform at = new AffineTransform();
                    at.rotate(Math.toRadians(this.rotate), p.x + ww / 2, p.y + hh / 2);
                    at.translate(p.x, p.y);
                    at.scale(this.scale, this.scale);
                    Rectangle b1 = new Rectangle(0, 0, ww, hh);
                    Shape shape = at.createTransformedShape(b1);
                    Rectangle2D b2 = shape.getBounds2D();
                    double xx = (double)(p.x + ww / 2) - (b2.getX() + b2.getWidth() / 2.0);
                    double yy = (double)(p.y + hh / 2) - (b2.getY() + b2.getHeight() / 2.0);
                    AffineTransform toCenterAT = new AffineTransform();
                    toCenterAT.translate(xx, yy);
                    toCenterAT.concatenate(at);
                    g2.setTransform(toCenterAT);
                    g2.drawImage((Image)bi, 0, 0, null);
                    g2.draw(b1);
                    ++i;
                }
                g2.setTransform(saveTx);
            }

            public int getBegin() {
                return this.beginning;
            }

            public int getEnd() {
                return this.ending;
            }
        }

        static class DdE
        implements Part {
            private int beginning;
            private int ending;
            private BufferedImage bimg;
            private Graphics2D big;
            private List list;
            private List xlist;
            private List ylist;
            private int xeNum;
            private int yeNum;
            private int xcSize;
            private int ycSize;
            private int inc;
            private int blocksize;

            public DdE(int beg, int end, int blocksize) {
                this.beginning = beg;
                this.ending = end;
                this.blocksize = blocksize;
            }

            private void createShuffledLists() {
                int width = this.bimg.getWidth();
                int height = this.bimg.getHeight();
                Integer[] xarray = new Integer[width];
                Integer[] yarray = new Integer[height];
                Integer[] array = new Integer[this.ending - this.beginning + 1];
                int i = 0;
                while (i < xarray.length) {
                    xarray[i] = new Integer(i);
                    ++i;
                }
                int j = 0;
                while (j < yarray.length) {
                    yarray[j] = new Integer(j);
                    ++j;
                }
                int k = 0;
                while (k < array.length) {
                    array[k] = new Integer(k);
                    ++k;
                }
                this.xlist = Arrays.asList(xarray);
                Collections.shuffle(this.xlist);
                this.ylist = Arrays.asList(yarray);
                Collections.shuffle(this.ylist);
                this.list = Arrays.asList(array);
                Collections.shuffle(this.list);
            }

            public void reset(int w, int h) {
                this.bimg = null;
            }

            public void step(int w, int h) {
                if (this.bimg == null) {
                    int biw = bimg.getWidth();
                    int bih = bimg.getHeight();
                    this.bimg = new BufferedImage(biw, bih, 1);
                    this.createShuffledLists();
                    this.big = this.bimg.createGraphics();
                    this.big.drawImage((Image)bimg, 0, 0, null);
                    this.xcSize = this.xlist.size() / (this.ending - this.beginning) + 1;
                    this.ycSize = this.ylist.size() / (this.ending - this.beginning) + 1;
                    this.xeNum = 0;
                    this.inc = 0;
                }
                this.xeNum = this.xcSize * (Integer)this.list.get(this.inc);
                this.yeNum = -this.ycSize;
                ++this.inc;
            }

            public void render(int w, int h, Graphics2D g2) {
                this.big.setColor(black);
                int k = 0;
                while (k <= this.ending - this.beginning) {
                    this.xeNum = this.xeNum + this.xcSize > this.xlist.size() ? 0 : (this.xeNum += this.xcSize);
                    this.yeNum += this.ycSize;
                    int i = this.xeNum;
                    while (i < this.xeNum + this.xcSize && i < this.xlist.size()) {
                        int j = this.yeNum;
                        while (j < this.yeNum + this.ycSize && j < this.ylist.size()) {
                            int xval = (Integer)this.xlist.get(i);
                            int yval = (Integer)this.ylist.get(j);
                            if (xval % this.blocksize == 0 && yval % this.blocksize == 0) {
                                this.big.fillRect(xval, yval, this.blocksize, this.blocksize);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    ++k;
                }
                g2.drawImage((Image)this.bimg, 0, 0, null);
            }

            public int getBegin() {
                return this.beginning;
            }

            public int getEnd() {
                return this.ending;
            }
        }

        static class CoE
        implements Part {
            static final int WID = 1;
            static final int HEI = 2;
            static final int OVAL = 4;
            static final int RECT = 8;
            static final int RAND = 16;
            static final int ARC = 32;
            private int type;
            private int beginning;
            private int ending;
            private BufferedImage bimg;
            private Shape shape;
            private double zoom;
            private double extent;
            private double zIncr;
            private double eIncr;
            private boolean doRandom;

            public CoE(int type, int beg, int end) {
                this.type = type;
                this.beginning = beg;
                this.ending = end;
                this.zIncr = -(2.0 / (double)(this.ending - this.beginning));
                this.eIncr = 360.0 / (double)(this.ending - this.beginning);
                this.doRandom = (type & 0x10) != 0;
            }

            public void reset(int w, int h) {
                if (this.doRandom) {
                    int num = (int)(Math.random() * 5.0);
                    switch (num) {
                        case 0: {
                            this.type = 4;
                            break;
                        }
                        case 1: {
                            this.type = 8;
                            break;
                        }
                        case 2: {
                            this.type = 9;
                            break;
                        }
                        case 3: {
                            this.type = 10;
                            break;
                        }
                        case 4: {
                            this.type = 32;
                            break;
                        }
                        default: {
                            this.type = 4;
                        }
                    }
                }
                this.shape = null;
                this.bimg = null;
                this.extent = 360.0;
                this.zoom = 2.0;
            }

            public void step(int w, int h) {
                if (this.bimg == null) {
                    int biw = bimg.getWidth();
                    int bih = bimg.getHeight();
                    this.bimg = new BufferedImage(biw, bih, 1);
                    Graphics2D big = this.bimg.createGraphics();
                    big.drawImage((Image)bimg, 0, 0, null);
                }
                double z = (double)Math.min(w, h) * this.zoom;
                if ((this.type & 4) != 0) {
                    this.shape = new Ellipse2D.Double((double)(w / 2) - z / 2.0, (double)(h / 2) - z / 2.0, z, z);
                } else if ((this.type & 0x20) != 0) {
                    this.shape = new Arc2D.Double(-100.0, -100.0, w + 200, h + 200, 90.0, this.extent, 2);
                    this.extent -= this.eIncr;
                } else if ((this.type & 8) != 0) {
                    this.shape = (this.type & 1) != 0 ? new Rectangle2D.Double((double)(w / 2) - z / 2.0, 0.0, z, h) : ((this.type & 2) != 0 ? new Rectangle2D.Double(0.0, (double)(h / 2) - z / 2.0, w, z) : new Rectangle2D.Double((double)(w / 2) - z / 2.0, (double)(h / 2) - z / 2.0, z, z));
                }
                this.zoom += this.zIncr;
            }

            public void render(int w, int h, Graphics2D g2) {
                g2.clip(this.shape);
                g2.drawImage((Image)this.bimg, 0, 0, null);
            }

            public int getBegin() {
                return this.beginning;
            }

            public int getEnd() {
                return this.ending;
            }

            static {
                WID = 1;
                HEI = 2;
                OVAL = 4;
                RECT = 8;
                RAND = 16;
                ARC = 32;
            }
        }

        static class TpE
        implements Part {
            static final int INC = 1;
            static final int DEC = 2;
            static final int OVAL = 4;
            static final int RECT = 8;
            static final int HAF = 16;
            static final int OI = 5;
            static final int OD = 6;
            static final int RI = 9;
            static final int RD = 10;
            static final int NF = 32;
            private Paint p1;
            private Paint p2;
            private int beginning;
            private int ending;
            private float incr;
            private float index;
            private TexturePaint texture;
            private int type;
            private int size;
            private BufferedImage bimg;
            private Rectangle rect;

            public TpE(int type, Paint p1, Paint p2, int size, int beg, int end) {
                this.type = type;
                this.p1 = p1;
                this.p2 = p2;
                this.beginning = beg;
                this.ending = end;
                this.setTextureSize(size);
            }

            public void setTextureSize(int size) {
                this.size = size;
                this.bimg = new BufferedImage(size, size, 1);
                this.rect = new Rectangle(0, 0, size, size);
            }

            public void reset(int w, int h) {
                this.incr = (float)this.size / (float)(this.ending - this.beginning);
                if ((this.type & 0x10) != 0) {
                    this.incr /= 2.0f;
                }
                if ((this.type & 2) != 0) {
                    this.index = this.size;
                    if ((this.type & 0x10) != 0) {
                        this.index /= 2.0f;
                    }
                    this.incr = -this.incr;
                } else {
                    this.index = 0.0f;
                }
                this.index += this.incr;
            }

            public void step(int w, int h) {
                Graphics2D g2 = this.bimg.createGraphics();
                g2.setPaint(this.p1);
                g2.fillRect(0, 0, this.size, this.size);
                g2.setPaint(this.p2);
                if ((this.type & 4) != 0) {
                    g2.fill(new Ellipse2D.Float(0.0f, 0.0f, this.index, this.index));
                } else if ((this.type & 8) != 0) {
                    g2.fill(new Rectangle2D.Float(0.0f, 0.0f, this.index, this.index));
                }
                this.texture = new TexturePaint(this.bimg, this.rect);
                g2.dispose();
                this.index += this.incr;
            }

            public void render(int w, int h, Graphics2D g2) {
                g2.setPaint(this.texture);
                if ((this.type & 0x20) == 0) {
                    g2.fillRect(0, 0, w, h);
                }
            }

            public int getBegin() {
                return this.beginning;
            }

            public int getEnd() {
                return this.ending;
            }

            static {
                INC = 1;
                DEC = 2;
                OVAL = 4;
                RECT = 8;
                HAF = 16;
                OI = 5;
                OD = 6;
                RI = 9;
                RD = 10;
                NF = 32;
            }
        }

        static class GpE
        implements Part {
            static final int INC = 1;
            static final int DEC = 2;
            static final int CNT = 4;
            static final int WID = 8;
            static final int WI = 9;
            static final int WD = 10;
            static final int HEI = 16;
            static final int HI = 17;
            static final int HD = 18;
            static final int SPL = 36;
            static final int SIW = 45;
            static final int SDW = 46;
            static final int SIH = 53;
            static final int SDH = 54;
            static final int BUR = 68;
            static final int BURI = 69;
            static final int BURD = 70;
            static final int NF = 128;
            private Color c1;
            private Color c2;
            private int beginning;
            private int ending;
            private float incr;
            private float index;
            private Vector rect = new Vector();
            private Vector grad = new Vector();
            private int type;

            public GpE(int type, Color c1, Color c2, int beg, int end) {
                this.type = type;
                this.c1 = c1;
                this.c2 = c2;
                this.beginning = beg;
                this.ending = end;
            }

            public void reset(int w, int h) {
                this.incr = 1.0f / (float)(this.ending - this.beginning);
                if ((this.type & 4) != 0) {
                    this.incr /= 2.3f;
                }
                if ((this.type & 4) != 0 && (this.type & 1) != 0) {
                    this.index = 0.5f;
                } else if ((this.type & 2) != 0) {
                    this.index = 1.0f;
                    this.incr = -this.incr;
                } else {
                    this.index = 0.0f;
                }
                this.index += this.incr;
            }

            public void step(int w, int h) {
                this.rect.clear();
                this.grad.clear();
                if ((this.type & 8) != 0) {
                    float w2 = 0.0f;
                    float x1 = 0.0f;
                    float x2 = 0.0f;
                    if ((this.type & 0x24) != 0) {
                        w2 = (float)w * 0.5f;
                        x1 = (float)w * (1.0f - this.index);
                        x2 = (float)w * this.index;
                    } else {
                        x1 = x2 = (w2 = (float)w * this.index);
                    }
                    this.rect.addElement(new Rectangle2D.Float(0.0f, 0.0f, w2, h));
                    this.rect.addElement(new Rectangle2D.Float(w2, 0.0f, (float)w - w2, h));
                    this.grad.addElement(new GradientPaint(0.0f, 0.0f, this.c1, x1, 0.0f, this.c2));
                    this.grad.addElement(new GradientPaint(x2, 0.0f, this.c2, w, 0.0f, this.c1));
                } else if ((this.type & 0x10) != 0) {
                    float h2 = 0.0f;
                    float y1 = 0.0f;
                    float y2 = 0.0f;
                    if ((this.type & 0x24) != 0) {
                        h2 = (float)h * 0.5f;
                        y1 = (float)h * (1.0f - this.index);
                        y2 = (float)h * this.index;
                    } else {
                        y1 = y2 = (h2 = (float)h * this.index);
                    }
                    this.rect.addElement(new Rectangle2D.Float(0.0f, 0.0f, w, h2));
                    this.rect.addElement(new Rectangle2D.Float(0.0f, h2, w, (float)h - h2));
                    this.grad.addElement(new GradientPaint(0.0f, 0.0f, this.c1, 0.0f, y1, this.c2));
                    this.grad.addElement(new GradientPaint(0.0f, y2, this.c2, 0.0f, h, this.c1));
                } else if ((this.type & 0x44) != 0) {
                    float w2 = w / 2;
                    float h2 = h / 2;
                    this.rect.addElement(new Rectangle2D.Float(0.0f, 0.0f, w2, h2));
                    this.rect.addElement(new Rectangle2D.Float(w2, 0.0f, w2, h2));
                    this.rect.addElement(new Rectangle2D.Float(0.0f, h2, w2, h2));
                    this.rect.addElement(new Rectangle2D.Float(w2, h2, w2, h2));
                    float x1 = (float)w * (1.0f - this.index);
                    float x2 = (float)w * this.index;
                    float y1 = (float)h * (1.0f - this.index);
                    float y2 = (float)h * this.index;
                    this.grad.addElement(new GradientPaint(0.0f, 0.0f, this.c1, x1, y1, this.c2));
                    this.grad.addElement(new GradientPaint(w, 0.0f, this.c1, x2, y1, this.c2));
                    this.grad.addElement(new GradientPaint(0.0f, h, this.c1, x1, y2, this.c2));
                    this.grad.addElement(new GradientPaint(w, h, this.c1, x2, y2, this.c2));
                } else if ((this.type & 0x80) != 0) {
                    float x = (float)w * this.index;
                    float y = (float)h * this.index;
                    this.grad.addElement(new GradientPaint(0.0f, 0.0f, this.c1, 0.0f, y, this.c2));
                }
                if ((this.type & 1) != 0 || (this.type & 2) != 0) {
                    this.index += this.incr;
                }
            }

            public void render(int w, int h, Graphics2D g2) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                int i = 0;
                while (i < this.grad.size()) {
                    g2.setPaint((GradientPaint)this.grad.get(i));
                    if ((this.type & 0x80) == 0) {
                        g2.fill((Rectangle2D)this.rect.get(i));
                    }
                    ++i;
                }
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }

            public int getBegin() {
                return this.beginning;
            }

            public int getEnd() {
                return this.ending;
            }

            static {
                INC = 1;
                DEC = 2;
                CNT = 4;
                WID = 8;
                WI = 9;
                WD = 10;
                HEI = 16;
                HI = 17;
                HD = 18;
                SPL = 36;
                SIW = 45;
                SDW = 46;
                SIH = 53;
                SDH = 54;
                BUR = 68;
                BURI = 69;
                BURD = 70;
                NF = 128;
            }
        }

        static class TxE
        implements Part {
            static final int INC = 1;
            static final int DEC = 2;
            static final int R = 4;
            static final int RI = 5;
            static final int RD = 6;
            static final int SC = 8;
            static final int SCI = 9;
            static final int SCD = 10;
            static final int SCX = 16;
            static final int SCXI = 25;
            static final int SCXD = 26;
            static final int SCY = 32;
            static final int SCYI = 41;
            static final int SCYD = 42;
            static final int AC = 64;
            static final int CLIP = 128;
            static final int NOP = 512;
            private int beginning;
            private int ending;
            private int type;
            private double rIncr;
            private double sIncr;
            private double sx;
            private double sy;
            private double rotate;
            private Shape[] shapes;
            private Shape[] txShapes;
            private int sw;
            private int numRev;
            private Paint paint;

            public TxE(String text, Font font, int type, Paint paint, int beg, int end) {
                this.type = type;
                this.paint = paint;
                this.beginning = beg;
                this.ending = end;
                this.setIncrements(2.0);
                char[] chars = text.toCharArray();
                this.shapes = new Shape[chars.length];
                this.txShapes = new Shape[chars.length];
                FontRenderContext frc = new FontRenderContext(null, true, true);
                TextLayout tl = new TextLayout(text, font, frc);
                this.sw = (int)tl.getOutline(null).getBounds().getWidth();
                int j = 0;
                while (j < chars.length) {
                    String s = String.valueOf(chars[j]);
                    this.shapes[j] = new TextLayout(s, font, frc).getOutline(null);
                    ++j;
                }
            }

            public void setIncrements(double numRevolutions) {
                this.numRev = (int)numRevolutions;
                this.rIncr = 360.0 / ((double)(this.ending - this.beginning) / numRevolutions);
                this.sIncr = 1.0 / (double)(this.ending - this.beginning);
                if ((this.type & 0x10) != 0 || (this.type & 0x20) != 0) {
                    this.sIncr *= 2.0;
                }
                if ((this.type & 2) != 0) {
                    this.rIncr = -this.rIncr;
                    this.sIncr = -this.sIncr;
                }
            }

            public void reset(int w, int h) {
                if (this.type == 25) {
                    this.sx = -1.0;
                    this.sy = 1.0;
                } else if (this.type == 41) {
                    this.sx = 1.0;
                    this.sy = -1.0;
                } else {
                    this.sy = (this.type & 2) != 0 ? 1.0 : 0.0;
                    this.sx = this.sy;
                }
                this.rotate = 0.0;
            }

            public void step(int w, int h) {
                float charWidth = w / 2 - this.sw / 2;
                int i = 0;
                while (i < this.shapes.length) {
                    AffineTransform at = new AffineTransform();
                    Rectangle maxBounds = this.shapes[i].getBounds();
                    at.translate(charWidth, (double)(h / 2) + ((RectangularShape)maxBounds).getHeight() / 2.0);
                    charWidth += (float)((RectangularShape)maxBounds).getWidth() + 1.0f;
                    Shape shape = at.createTransformedShape(this.shapes[i]);
                    Rectangle2D b1 = shape.getBounds2D();
                    if ((this.type & 4) != 0) {
                        at.rotate(Math.toRadians(this.rotate));
                    }
                    if ((this.type & 8) != 0) {
                        at.scale(this.sx, this.sy);
                    }
                    shape = at.createTransformedShape(this.shapes[i]);
                    Rectangle2D b2 = shape.getBounds2D();
                    double xx = b1.getX() + b1.getWidth() / 2.0 - (b2.getX() + b2.getWidth() / 2.0);
                    double yy = b1.getY() + b1.getHeight() / 2.0 - (b2.getY() + b2.getHeight() / 2.0);
                    AffineTransform toCenterAT = new AffineTransform();
                    toCenterAT.translate(xx, yy);
                    toCenterAT.concatenate(at);
                    this.txShapes[i] = toCenterAT.createTransformedShape(this.shapes[i]);
                    ++i;
                }
                if (Math.abs(this.rotate) <= (double)(this.numRev * 360)) {
                    this.rotate += this.rIncr;
                    if ((this.type & 0x10) != 0) {
                        this.sx += this.sIncr;
                    } else if ((this.type & 0x20) != 0) {
                        this.sy += this.sIncr;
                    } else {
                        this.sx += this.sIncr;
                        this.sy += this.sIncr;
                    }
                }
            }

            public void render(int w, int h, Graphics2D g2) {
                Composite saveAC = null;
                if ((this.type & 0x40) != 0 && this.sx > 0.0 && this.sx < 1.0) {
                    saveAC = g2.getComposite();
                    g2.setComposite(AlphaComposite.getInstance(3, (float)this.sx));
                }
                GeneralPath path = null;
                if ((this.type & 0x80) != 0) {
                    path = new GeneralPath();
                }
                if (this.paint != null) {
                    g2.setPaint(this.paint);
                }
                int i = 0;
                while (i < this.txShapes.length) {
                    if ((this.type & 0x80) != 0) {
                        path.append(this.txShapes[i], false);
                    } else {
                        g2.fill(this.txShapes[i]);
                    }
                    ++i;
                }
                if ((this.type & 0x80) != 0) {
                    g2.clip(path);
                }
                if (saveAC != null) {
                    g2.setComposite(saveAC);
                }
            }

            public int getBegin() {
                return this.beginning;
            }

            public int getEnd() {
                return this.ending;
            }

            static {
                INC = 1;
                DEC = 2;
                R = 4;
                RI = 5;
                RD = 6;
                SC = 8;
                SCI = 9;
                SCD = 10;
                SCX = 16;
                SCXI = 25;
                SCXD = 26;
                SCY = 32;
                SCYI = 41;
                SCYD = 42;
                AC = 64;
                CLIP = 128;
                NOP = 512;
            }
        }

        static class Scene {
            public Object participate = new Boolean(true);
            public Object pauseAmt;
            public Vector parts;
            public int index;
            public int length;

            public Scene(Vector parts, Object pauseAmt) {
                this.parts = parts;
                this.pauseAmt = pauseAmt;
                int i = 0;
                while (i < parts.size()) {
                    if (((Part)parts.get(i)).getEnd() > this.length) {
                        this.length = ((Part)parts.get(i)).getEnd();
                    }
                    ++i;
                }
            }

            public void reset(int w, int h) {
                this.index = 0;
                int i = 0;
                while (i < this.parts.size()) {
                    ((Part)this.parts.get(i)).reset(w, h);
                    ++i;
                }
            }

            public void step(int w, int h) {
                int i = 0;
                while (i < this.parts.size()) {
                    Part part = (Part)this.parts.get(i);
                    if (this.index >= part.getBegin() && this.index <= part.getEnd()) {
                        part.step(w, h);
                    }
                    ++i;
                }
            }

            public void render(int w, int h, Graphics2D g2) {
                int i = 0;
                while (i < this.parts.size()) {
                    Part part = (Part)this.parts.get(i);
                    if (this.index >= part.getBegin() && this.index <= part.getEnd()) {
                        part.render(w, h, g2);
                    }
                    ++i;
                }
            }

            public void pause(Thread thread) {
                try {
                    Thread.sleep(Long.parseLong((String)this.pauseAmt));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.gc();
            }
        }

        static class Director
        extends Vector {
            GradientPaint gp = new GradientPaint(0.0f, 40.0f, blue, 38.0f, 2.0f, black);
            Font f1 = new Font("serif", 0, 200);
            Font f2 = new Font("serif", 0, 120);
            Font f3 = new Font("serif", 0, 72);
            Object[][][] parts = new Object[][][]{{{"0"}, {new GpE(69, black, blue, 0, 20), new TxE("J", this.f1, 9, yellow, 2, 20)}}, {{"0"}, {new GpE(69, blue, black, 0, 22), new TxE("D", this.f1, 13, yellow, 2, 22)}}, {{"0"}, {new GpE(69, black, blue, 0, 20), new TxE("B", this.f1, 9, yellow, 2, 20)}}, {{"1000"}, {new GpE(53, blue, black, 0, 40), new TxE("JDBees", this.f2, 13, yellow, 0, 40)}}, {{"0"}, {new DdE(0, 20, 1)}}, {{"1000"}, {new GpE(9, blue, black, 0, 20), new GpE(10, blue, black, 21, 40), new TpE(37, black, yellow, 4, 0, 10), new TpE(38, black, yellow, 4, 11, 20), new TpE(53, black, yellow, 5, 21, 40), new TxE("JDBees", this.f2, 0, null, 0, 40)}}, {{"0"}, {new CoE(16, 0, 20)}}, {{"1000"}, {new TpE(9, black, this.gp, 40, 0, 20), new TpE(10, black, this.gp, 40, 21, 40), new TpE(9, black, this.gp, 40, 41, 60), new TxE("JDBees", this.f2, 64, yellow, 0, 60)}}, {{"0"}, {new DdE(0, 20, 4)}}, {{"1000"}, {new GpE(54, blue, black, 0, 20), new GpE(53, blue, black, 21, 40), new GpE(54, blue, black, 41, 50), new GpE(129, red, yellow, 0, 50), new TxE("JDBees", this.f2, 512, null, 0, 50)}}, {{"0"}, {new CoE(4, 0, 20)}}, {{"2000"}, {new GpE(69, black, blue, 0, 20), new GpE(70, black, blue, 21, 30), new TpE(21, black, blue, 10, 31, 40), new TxE("JDBees", this.f2, 69, yellow, 0, 40)}}, {{"0"}, {new SiE(60, 60, 0, 40)}}, {{"1000"}, {new LnE(45, 0, 60), new TxE("JDBees", this.f3, 73, Color.red, 20, 30), new TxE("JDBees", this.f3, 26, Color.red, 31, 38), new TxE("JDBees", this.f3, 25, Color.red, 39, 48), new TxE("JDBees", this.f3, 26, Color.red, 49, 54), new TxE("JDBees", this.f3, 25, Color.red, 55, 60)}}, {{"0"}, {new LnE(46, 0, 45), new TxE("JDBees", this.f3, 0, Color.red, 0, 9), new TxE("JDBees", this.f3, 14, Color.red, 10, 30)}}};

            public Director() {
                int i = 0;
                while (i < this.parts.length) {
                    Vector<Object> v = new Vector<Object>();
                    int j = 0;
                    while (j < this.parts[i][1].length) {
                        v.addElement(this.parts[i][1][j]);
                        ++j;
                    }
                    this.addElement(new Scene(v, this.parts[i][0][0]));
                    ++i;
                }
            }
        }

        static interface Part {
            public void reset(int var1, int var2);

            public void step(int var1, int var2);

            public void render(int var1, int var2, Graphics2D var3);

            public int getBegin();

            public int getEnd();
        }
    }
}

